/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.validator.GenericValidator;

public class GenericTypeValidator
implements Serializable {
    public static Byte formatByte(String string) {
        Byte by = null;
        try {
            by = new Byte(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return by;
    }

    public static Short formatShort(String string) {
        Short s = null;
        try {
            s = new Short(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public static Integer formatInt(String string) {
        Integer n = null;
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public static Long formatLong(String string) {
        Long l = null;
        try {
            l = new Long(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public static Float formatFloat(String string) {
        Float f = null;
        try {
            f = new Float(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public static Double formatDouble(String string) {
        Double d = null;
        try {
            d = new Double(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public static Date formatDate(String string, Locale locale) {
        Date date = null;
        if (string != null) {
            try {
                DateFormat dateFormat = null;
                dateFormat = locale != null ? DateFormat.getDateInstance(3, locale) : DateFormat.getDateInstance(3, Locale.getDefault());
                dateFormat.setLenient(false);
                date = dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public static Date formatDate(String string, String string2, boolean bl) {
        Date date = null;
        if (string != null && string2 != null && string2.length() > 0) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
                simpleDateFormat.setLenient(false);
                date = simpleDateFormat.parse(string);
                if (bl && string2.length() != string.length()) {
                    date = null;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public static Long formatCreditCard(String string) {
        Long l = null;
        try {
            if (GenericValidator.validateCreditCardLuhnCheck(string) && GenericValidator.validateCreditCardPrefixCheck(string)) {
                l = new Long(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }
}

