/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common;

import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.HashSet;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaUtils {
    private static final Logger log = Logger.getLogger(JavaUtils.class);
    private static HashMap<String, Class> primitiveNames = new HashMap(8);
    private static HashMap<String, String> primitiveNameDescriptors = new HashMap(8);
    private static HashSet<String> reservedKeywords = new HashSet(50);

    public static Class loadJavaType(String string) throws ClassNotFoundException {
        return JavaUtils.loadJavaType(string, null);
    }

    public static Class loadJavaType(String string, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if ((clazz = primitiveNames.get(string)) == null) {
            clazz = JavaUtils.getArray(string, classLoader);
        }
        if (clazz == null) {
            clazz = classLoader.loadClass(string);
        }
        return clazz;
    }

    public static boolean isPrimitive(String string) {
        return JavaUtils.getPrimitiveType(string) != null;
    }

    public static boolean isPrimitive(Class clazz) {
        return clazz.isPrimitive() || clazz.isArray() && JavaUtils.isPrimitive(clazz.getComponentType());
    }

    public static Class getPrimitiveType(String string) {
        Class clazz = primitiveNames.get(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = JavaUtils.getArray(string, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    private static Class getArray(String string, ClassLoader classLoader) throws ClassNotFoundException {
        if (string.charAt(0) == '[') {
            return JavaUtils.getArrayFromJVMName(string, classLoader);
        }
        if (string.endsWith("[]")) {
            return JavaUtils.getArrayFromSourceName(string, classLoader);
        }
        return null;
    }

    private static Class getArrayFromJVMName(String string, ClassLoader classLoader) throws ClassNotFoundException {
        Class<Constable> clazz;
        int n = string.lastIndexOf(91) + 1;
        switch (string.charAt(n)) {
            case 'I': {
                clazz = Integer.TYPE;
                break;
            }
            case 'S': {
                clazz = Short.TYPE;
                break;
            }
            case 'Z': {
                clazz = Boolean.TYPE;
                break;
            }
            case 'B': {
                clazz = Byte.TYPE;
                break;
            }
            case 'J': {
                clazz = Long.TYPE;
                break;
            }
            case 'D': {
                clazz = Double.TYPE;
                break;
            }
            case 'F': {
                clazz = Float.TYPE;
                break;
            }
            case 'C': {
                clazz = Character.TYPE;
                break;
            }
            case 'L': {
                if (classLoader == null) {
                    return null;
                }
                String string2 = string.substring(n + 1, string.length() - 1);
                clazz = classLoader.loadClass(string2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid binary component for array: " + string.charAt(n));
            }
        }
        return Array.newInstance(clazz, new int[n]).getClass();
    }

    private static Class getArrayFromSourceName(String string, ClassLoader classLoader) throws ClassNotFoundException {
        int n = string.indexOf(91);
        String string2 = string.substring(0, n);
        Class<?> clazz = primitiveNames.get(string2);
        if (clazz == null) {
            if (classLoader == null) {
                return null;
            }
            clazz = classLoader.loadClass(string2);
        }
        int n2 = string.length() - n >> 1;
        return Array.newInstance(clazz, new int[n2]).getClass();
    }

    public static Class getPrimitiveType(Class clazz) {
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Integer[].class) {
            return int[].class;
        }
        if (clazz == Short[].class) {
            return short[].class;
        }
        if (clazz == Boolean[].class) {
            return boolean[].class;
        }
        if (clazz == Byte[].class) {
            return byte[].class;
        }
        if (clazz == Long[].class) {
            return long[].class;
        }
        if (clazz == Double[].class) {
            return double[].class;
        }
        if (clazz == Float[].class) {
            return float[].class;
        }
        if (clazz == Character[].class) {
            return char[].class;
        }
        if (clazz.isArray() && clazz.getComponentType().isArray()) {
            Class clazz2 = JavaUtils.getPrimitiveType(clazz.getComponentType());
            return Array.newInstance(clazz2, 0).getClass();
        }
        return clazz;
    }

    public static Object getPrimitiveValueArray(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            int n = Array.getLength(object);
            Object object2 = Array.newInstance(JavaUtils.getPrimitiveType(clazz.getComponentType()), n);
            for (int i = 0; i < n; ++i) {
                Object object3 = Array.get(object, i);
                Array.set(object2, i, JavaUtils.getPrimitiveValueArray(object3));
            }
            return object2;
        }
        return object;
    }

    public static Class getWrapperType(Class clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == int[].class) {
            return Integer[].class;
        }
        if (clazz == short[].class) {
            return Short[].class;
        }
        if (clazz == boolean[].class) {
            return Boolean[].class;
        }
        if (clazz == byte[].class) {
            return Byte[].class;
        }
        if (clazz == long[].class) {
            return Long[].class;
        }
        if (clazz == double[].class) {
            return Double[].class;
        }
        if (clazz == float[].class) {
            return Float[].class;
        }
        if (clazz == char[].class) {
            return Character[].class;
        }
        if (clazz.isArray() && clazz.getComponentType().isArray()) {
            Class clazz2 = JavaUtils.getWrapperType(clazz.getComponentType());
            return Array.newInstance(clazz2, 0).getClass();
        }
        return clazz;
    }

    public static Object getWrapperValueArray(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            int n = Array.getLength(object);
            Object object2 = Array.newInstance(JavaUtils.getWrapperType(clazz.getComponentType()), n);
            for (int i = 0; i < n; ++i) {
                Object object3 = Array.get(object, i);
                Array.set(object2, i, JavaUtils.getWrapperValueArray(object3));
            }
            return object2;
        }
        return object;
    }

    public static Object syncArray(Object object, Class clazz) {
        return JavaUtils.isPrimitive(clazz) ? JavaUtils.getPrimitiveValueArray(object) : JavaUtils.getWrapperValueArray(object);
    }

    public static boolean isAssignableFrom(Class clazz, Class clazz2) {
        if (clazz == null) {
            throw new IllegalArgumentException("Destination class cannot be null");
        }
        if (clazz2 == null) {
            throw new IllegalArgumentException("Source class cannot be null");
        }
        boolean bl = clazz.isAssignableFrom(clazz2);
        if (!bl && clazz.getName().equals(clazz2.getName())) {
            ClassLoader classLoader = clazz.getClassLoader();
            ClassLoader classLoader2 = clazz2.getClassLoader();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Not assignable because of conflicting class loaders:\ndstLoader=" + classLoader + "\nsrcLoader=" + classLoader2));
            }
        }
        if (!bl && JavaUtils.isPrimitive(clazz)) {
            clazz = JavaUtils.getWrapperType(clazz);
            bl = clazz.isAssignableFrom(clazz2);
        }
        if (!bl && JavaUtils.isPrimitive(clazz2)) {
            clazz2 = JavaUtils.getWrapperType(clazz2);
            bl = clazz.isAssignableFrom(clazz2);
        }
        return bl;
    }

    public static String convertJVMNameToSourceName(String string, ClassLoader classLoader) {
        try {
            Class clazz = JavaUtils.loadJavaType(string, classLoader);
            string = JavaUtils.getSourceName(clazz);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String toSignature(String string) {
        if (string == null) {
            return null;
        }
        String string2 = primitiveNameDescriptors.get(string);
        if (string2 != null) {
            return string2;
        }
        string2 = string.replace('.', '/');
        return string2.charAt(0) == '[' ? string2 : "L" + string2 + ";";
    }

    public static String printArray(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(objectArray[i].getClass().isArray() ? JavaUtils.printArray((Object[])objectArray[i]) : objectArray[i]);
        }
        return stringBuilder.append("]").toString();
    }

    public static String getSourceName(Class clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        String string = "";
        Class<?> clazz2 = clazz;
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
            string = string + "[]";
        }
        return clazz2.getName() + string;
    }

    public static String capitalize(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        char c = Character.toUpperCase(string.charAt(0));
        return c + string.substring(1);
    }

    public static boolean isLoaded(String string, ClassLoader classLoader) {
        try {
            JavaUtils.loadJavaType(string, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public static String getPackageName(Class<?> clazz) {
        String string = clazz.getName();
        return string.substring(0, string.lastIndexOf("."));
    }

    public static boolean isReservedKeyword(String string) {
        return reservedKeywords.contains(string);
    }

    public static Class erasure(Type type) {
        if (type instanceof ParameterizedType) {
            return JavaUtils.erasure(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            return JavaUtils.erasure(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            return JavaUtils.erasure(((WildcardType)type).getUpperBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(JavaUtils.erasure(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        return (Class)type;
    }

    public static String[] getRawParameterTypeArguments(ParameterizedType parameterizedType) {
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        String[] stringArray = new String[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            Class clazz = JavaUtils.erasure(typeArray[i]);
            stringArray[i] = clazz.getName();
        }
        return stringArray;
    }

    public static boolean isRetro14() {
        return !(String.class instanceof Type);
    }

    public static boolean isJBossRepositoryClassLoader(ClassLoader classLoader) {
        Class<?> clazz = classLoader.getClass();
        while (!clazz.getName().startsWith("java")) {
            if ("org.jboss.mx.loading.RepositoryClassLoader".equals(clazz.getName())) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static void clearBlacklists(ClassLoader classLoader) {
        if (JavaUtils.isJBossRepositoryClassLoader(classLoader)) {
            for (Method method : classLoader.getClass().getMethods()) {
                if (!"clearBlackLists".equalsIgnoreCase(method.getName())) continue;
                try {
                    method.invoke((Object)classLoader, new Object[0]);
                }
                catch (Exception exception) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Could not clear blacklists on " + classLoader));
                }
            }
        }
    }

    static {
        primitiveNames.put("int", Integer.TYPE);
        primitiveNames.put("short", Short.TYPE);
        primitiveNames.put("boolean", Boolean.TYPE);
        primitiveNames.put("byte", Byte.TYPE);
        primitiveNames.put("long", Long.TYPE);
        primitiveNames.put("double", Double.TYPE);
        primitiveNames.put("float", Float.TYPE);
        primitiveNames.put("char", Character.TYPE);
        primitiveNameDescriptors.put("int", "I");
        primitiveNameDescriptors.put("short", "S");
        primitiveNameDescriptors.put("boolean", "Z");
        primitiveNameDescriptors.put("byte", "B");
        primitiveNameDescriptors.put("long", "J");
        primitiveNameDescriptors.put("double", "D");
        primitiveNameDescriptors.put("float", "F");
        primitiveNameDescriptors.put("char", "C");
        reservedKeywords.add("abstract");
        reservedKeywords.add("continue");
        reservedKeywords.add("for");
        reservedKeywords.add("new");
        reservedKeywords.add("switch");
        reservedKeywords.add("assert");
        reservedKeywords.add("default");
        reservedKeywords.add("if");
        reservedKeywords.add("package");
        reservedKeywords.add("synchronized");
        reservedKeywords.add("boolean");
        reservedKeywords.add("do");
        reservedKeywords.add("goto");
        reservedKeywords.add("private");
        reservedKeywords.add("this");
        reservedKeywords.add("break");
        reservedKeywords.add("double");
        reservedKeywords.add("implements");
        reservedKeywords.add("protected");
        reservedKeywords.add("throw");
        reservedKeywords.add("byte");
        reservedKeywords.add("else");
        reservedKeywords.add("import");
        reservedKeywords.add("public");
        reservedKeywords.add("throws");
        reservedKeywords.add("case");
        reservedKeywords.add("enum");
        reservedKeywords.add("instanceof");
        reservedKeywords.add("return");
        reservedKeywords.add("transient");
        reservedKeywords.add("catch");
        reservedKeywords.add("extends");
        reservedKeywords.add("int");
        reservedKeywords.add("short");
        reservedKeywords.add("try");
        reservedKeywords.add("char");
        reservedKeywords.add("final");
        reservedKeywords.add("interface");
        reservedKeywords.add("static");
        reservedKeywords.add("void");
        reservedKeywords.add("class");
        reservedKeywords.add("finally");
        reservedKeywords.add("long");
        reservedKeywords.add("strictfp");
        reservedKeywords.add("volatile");
        reservedKeywords.add("const");
        reservedKeywords.add("float");
        reservedKeywords.add("native");
        reservedKeywords.add("super");
        reservedKeywords.add("while");
    }
}

