/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.mapping;

import java.io.IOException;
import javax.xml.rpc.encoding.TypeMapping;
import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.tools.helpers.MappingFileGeneratorHelper;

public class MappingFileGenerator {
    protected WSDLDefinitions wsdlDefinitions;
    protected String packageName;
    protected String serviceName;
    protected Class serviceEndpointInterface = null;
    protected LiteralTypeMapping typeMapping = null;
    protected String parameterStyle;

    public MappingFileGenerator(WSDLDefinitions wsdl, TypeMapping typeM) {
        this.wsdlDefinitions = wsdl;
        this.typeMapping = (LiteralTypeMapping)typeM;
    }

    public WSDLDefinitions getWsdlDefinitions() {
        return this.wsdlDefinitions;
    }

    public void setWsdlDefinitions(WSDLDefinitions wsdlDefinitions) {
        this.wsdlDefinitions = wsdlDefinitions;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceEndpointInterface(Class serviceEndpointInterface) {
        this.serviceEndpointInterface = serviceEndpointInterface;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setParameterStyle(String paramStyle) {
        this.parameterStyle = paramStyle;
    }

    public JavaWsdlMapping generate() throws IOException {
        MappingFileGeneratorHelper helper = new MappingFileGeneratorHelper(this.wsdlDefinitions, this.serviceName, this.packageName, this.serviceEndpointInterface, this.typeMapping, this.parameterStyle);
        JavaWsdlMapping jwm = new JavaWsdlMapping();
        helper.constructJavaXmlTypeMapping(jwm);
        WSDLService[] services = this.wsdlDefinitions.getServices();
        int lenServices = 0;
        if (services != null) {
            lenServices = services.length;
        }
        for (int i = 0; i < lenServices; ++i) {
            WSDLService wsdlService = services[i];
            jwm.addServiceInterfaceMappings(helper.constructServiceInterfaceMapping(jwm, wsdlService));
            helper.constructServiceEndpointInterfaceMapping(jwm, wsdlService);
        }
        String targetNS = this.wsdlDefinitions.getTargetNamespace();
        String typeNamespace = helper.getTypeNamespace();
        if (typeNamespace == null) {
            typeNamespace = targetNS;
        }
        if (typeNamespace != null && !typeNamespace.equals(targetNS) || this.isServerSideGeneration()) {
            jwm.addPackageMapping(helper.constructPackageMapping(jwm, this.packageName, typeNamespace));
        }
        jwm.addPackageMapping(helper.constructPackageMapping(jwm, this.packageName, targetNS));
        return jwm;
    }

    private boolean isServerSideGeneration() {
        return this.serviceEndpointInterface != null;
    }
}

