/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.lock.IdentityLock;
import org.jgroups.blocks.MethodCall;

public class TransactionTable {
    protected Map tx_map = new ConcurrentHashMap();
    protected Map txs = new ConcurrentHashMap();
    private static final Log log = LogFactory.getLog((Class)TransactionTable.class);

    public int getNumLocalTransactions() {
        return this.tx_map.size();
    }

    public int getNumGlobalTransactions() {
        return this.txs.size();
    }

    public GlobalTransaction get(Transaction tx) {
        if (tx == null) {
            return null;
        }
        return (GlobalTransaction)this.tx_map.get(tx);
    }

    public Transaction getLocalTransaction(GlobalTransaction gtx) {
        if (gtx == null) {
            return null;
        }
        Iterator it = this.tx_map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Transaction local_tx = (Transaction)entry.getKey();
            GlobalTransaction global_tx = (GlobalTransaction)entry.getValue();
            if (!gtx.equals(global_tx)) continue;
            return local_tx;
        }
        return null;
    }

    public void put(Transaction tx, GlobalTransaction gtx) {
        if (tx == null) {
            log.error((Object)"key (Transaction) is null");
            return;
        }
        this.tx_map.put(tx, gtx);
    }

    public TransactionEntry get(GlobalTransaction gtx) {
        return gtx != null ? (TransactionEntry)this.txs.get(gtx) : null;
    }

    public void put(GlobalTransaction tx, TransactionEntry entry) {
        if (tx == null) {
            log.error((Object)"key (GlobalTransaction) is null");
            return;
        }
        this.txs.put(tx, entry);
    }

    public TransactionEntry remove(GlobalTransaction tx) {
        return (TransactionEntry)this.txs.remove(tx);
    }

    public GlobalTransaction remove(Transaction tx) {
        if (tx == null) {
            return null;
        }
        return (GlobalTransaction)this.tx_map.remove(tx);
    }

    public void addModification(GlobalTransaction gtx, MethodCall m) {
        TransactionEntry entry = this.get(gtx);
        if (entry == null) {
            log.error((Object)("transaction not found (gtx=" + gtx + ")"));
            return;
        }
        entry.addModification(m);
    }

    public void addCacheLoaderModification(GlobalTransaction gtx, MethodCall m) {
        TransactionEntry entry = this.get(gtx);
        if (entry == null) {
            log.error((Object)("transaction not found (gtx=" + gtx + ")"));
            return;
        }
        entry.addCacheLoaderModification(m);
    }

    public void addUndoOperation(GlobalTransaction gtx, MethodCall m) {
        TransactionEntry entry = this.get(gtx);
        if (entry == null) {
            log.error((Object)("transaction not found (gtx=" + gtx + ")"));
            return;
        }
        entry.addUndoOperation(m);
    }

    public void addLock(GlobalTransaction gtx, IdentityLock l) {
        TransactionEntry entry = this.get(gtx);
        if (entry == null) {
            log.error((Object)("transaction entry not found for (gtx=" + gtx + ")"));
            return;
        }
        entry.addLock(l);
    }

    public void addLocks(GlobalTransaction gtx, Collection locks) {
        TransactionEntry entry = this.get(gtx);
        if (entry == null) {
            log.error((Object)("transaction entry not found for (gtx=" + gtx + ")"));
            return;
        }
        entry.addLocks(locks);
    }

    public void addRemovedNode(GlobalTransaction gtx, Fqn fqn) {
        TransactionEntry entry = this.get(gtx);
        if (entry == null) {
            log.error((Object)("transaction entry not found for (gtx=" + gtx + ")"));
            return;
        }
        entry.addRemovedNode(fqn);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.tx_map.size()).append(" mappings, ");
        sb.append(this.txs.size()).append(" transactions");
        return sb.toString();
    }

    public String toString(boolean print_details) {
        Map.Entry entry;
        if (!print_details) {
            return this.toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("LocalTransactions: ").append(this.tx_map.size()).append("\n");
        sb.append("GlobalTransactions: ").append(this.txs.size()).append("\n");
        sb.append("tx_map:\n");
        Iterator it = this.tx_map.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        sb.append("txs:\n");
        it = this.txs.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }
}

