/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.generator;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.ws.processor.generator.GeneratorBase;
import com.sun.tools.ws.processor.generator.GeneratorUtil;
import com.sun.tools.ws.processor.generator.Names;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.model.Service;
import com.sun.tools.ws.processor.model.java.JavaInterface;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.Options;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.util.JAXWSUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;

public class ServiceGenerator
extends GeneratorBase {
    public static void generate(Model model, WsimportOptions options, ErrorReceiver receiver) {
        ServiceGenerator serviceGenerator = new ServiceGenerator(model, options, receiver);
        serviceGenerator.doGeneration();
    }

    private ServiceGenerator(Model model, WsimportOptions options, ErrorReceiver receiver) {
        super(model, options, receiver);
    }

    private JInvocation createURL(URL url) {
        return JExpr._new((JClass)this.cm.ref(URL.class)).arg(url.toExternalForm());
    }

    public void visit(Service service) {
        try {
            JavaInterface intf = service.getJavaInterface();
            String className = Names.customJavaTypeClassName(intf);
            if (this.donotOverride && GeneratorUtil.classExists(this.options, className)) {
                this.log("Class " + className + " exists. Not overriding.");
                return;
            }
            JDefinedClass cls = this.getClass(className, ClassType.CLASS);
            cls._extends(javax.xml.ws.Service.class);
            String serviceFieldName = JAXBRIContext.mangleNameToClassName((String)service.getName().getLocalPart()).toUpperCase();
            String wsdlLocationName = serviceFieldName + "_WSDL_LOCATION";
            JFieldVar urlField = cls.field(28, URL.class, wsdlLocationName);
            JClass qNameCls = this.cm.ref(QName.class);
            JInvocation inv = JExpr._new((JClass)qNameCls);
            inv.arg("namespace");
            inv.arg("localpart");
            JBlock staticBlock = cls.init();
            URL url = new URL(JAXWSUtils.absolutize(JAXWSUtils.getFileOrURLName(this.wsdlLocation)));
            JVar urlVar = staticBlock.decl((JType)this.cm.ref(URL.class), "url", JExpr._null());
            JTryBlock tryBlock = staticBlock._try();
            tryBlock.body().assign((JAssignmentTarget)urlVar, (JExpression)this.createURL(url));
            JCatchBlock catchBlock = tryBlock._catch(this.cm.ref(MalformedURLException.class));
            catchBlock.param("e");
            catchBlock.body().directStatement("e.printStackTrace();");
            staticBlock.assign((JAssignmentTarget)urlField, (JExpression)urlVar);
            JDocComment comment = cls.javadoc();
            if (service.getJavaDoc() != null) {
                comment.add((Object)service.getJavaDoc());
                comment.add((Object)"\n\n");
            }
            for (String doc : this.getJAXWSClassComment()) {
                comment.add((Object)doc);
            }
            JMethod constructor = cls.constructor(1);
            constructor.param(URL.class, "wsdlLocation");
            constructor.param(QName.class, "serviceName");
            constructor.body().directStatement("super(wsdlLocation, serviceName);");
            constructor = cls.constructor(1);
            constructor.body().directStatement("super(" + wsdlLocationName + ", new QName(\"" + service.getName().getNamespaceURI() + "\", \"" + service.getName().getLocalPart() + "\"));");
            JAnnotationUse webServiceClientAnn = cls.annotate(this.cm.ref(WebServiceClient.class));
            this.writeWebServiceClientAnnotation(service, webServiceClientAnn);
            this.writeHandlerConfig(Names.customJavaTypeClassName(service.getJavaInterface()), cls, this.options);
            for (Port port : service.getPorts()) {
                if (port.isProvider()) continue;
                this.writeDefaultGetPort(port, cls);
                if (!this.options.target.isLaterThan(Options.Target.V2_1)) continue;
                this.writeGetPort(port, cls);
            }
        }
        catch (IOException e) {
            this.receiver.error(e);
        }
    }

    private void writeGetPort(Port port, JDefinedClass cls) {
        JDefinedClass retType = this.getClass(port.getJavaInterface().getName(), ClassType.INTERFACE);
        JMethod m = cls.method(1, (JType)retType, port.getPortGetter());
        JDocComment methodDoc = m.javadoc();
        if (port.getJavaDoc() != null) {
            methodDoc.add((Object)port.getJavaDoc());
        }
        JCommentPart ret = methodDoc.addReturn();
        JCommentPart paramDoc = methodDoc.addParam("features");
        paramDoc.append((Object)"A list of ");
        paramDoc.append((Object)("{@link " + WebServiceFeature.class.getName() + "}"));
        paramDoc.append((Object)"to configure on the proxy.  Supported features not in the <code>features</code> parameter will have their default values.");
        ret.add((Object)("returns " + retType.name()));
        m.varParam(WebServiceFeature.class, "features");
        JBlock body = m.body();
        StringBuffer statement = new StringBuffer("return (");
        statement.append(retType.name());
        statement.append(")super.getPort(new QName(\"").append(port.getName().getNamespaceURI()).append("\", \"").append(port.getName().getLocalPart()).append("\"), ");
        statement.append(retType.name());
        statement.append(".class, features);");
        body.directStatement(statement.toString());
        this.writeWebEndpoint(port, m);
    }

    private void writeDefaultGetPort(Port port, JDefinedClass cls) {
        JDefinedClass retType = this.getClass(port.getJavaInterface().getName(), ClassType.INTERFACE);
        String portGetter = port.getPortGetter();
        JMethod m = cls.method(1, (JType)retType, portGetter);
        JDocComment methodDoc = m.javadoc();
        if (port.getJavaDoc() != null) {
            methodDoc.add((Object)port.getJavaDoc());
        }
        JCommentPart ret = methodDoc.addReturn();
        ret.add((Object)("returns " + retType.name()));
        JBlock body = m.body();
        StringBuffer statement = new StringBuffer("return (");
        statement.append(retType.name());
        statement.append(")super.getPort(new QName(\"").append(port.getName().getNamespaceURI()).append("\", \"").append(port.getName().getLocalPart()).append("\"), ");
        statement.append(retType.name());
        statement.append(".class);");
        body.directStatement(statement.toString());
        this.writeWebEndpoint(port, m);
    }

    protected JDefinedClass getClass(String className, ClassType type) {
        JDefinedClass cls;
        try {
            cls = this.cm._class(className, type);
        }
        catch (JClassAlreadyExistsException e) {
            cls = this.cm._getClass(className);
        }
        return cls;
    }

    private void writeWebServiceClientAnnotation(Service service, JAnnotationUse wsa) {
        String serviceName = service.getName().getLocalPart();
        String serviceNS = service.getName().getNamespaceURI();
        wsa.param("name", serviceName);
        wsa.param("targetNamespace", serviceNS);
        wsa.param("wsdlLocation", this.wsdlLocation);
    }

    private void writeWebEndpoint(Port port, JMethod m) {
        JAnnotationUse webEndpointAnn = m.annotate(this.cm.ref(WebEndpoint.class));
        webEndpointAnn.param("name", port.getName().getLocalPart());
    }
}

