/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.TableCell;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebTable {
    private Element _dom;
    private URL _url;
    private String _parentTarget;
    private String _characterSet;
    private TableCell[][] _cells;

    public int getRowCount() {
        if (this._cells == null) {
            this.readTable();
        }
        return this._cells.length;
    }

    public int getColumnCount() {
        if (this._cells == null) {
            this.readTable();
        }
        if (this._cells.length == 0) {
            return 0;
        }
        return this._cells[0].length;
    }

    public String getCell(int row, int column) {
        return this.getCellAsText(row, column);
    }

    public String getCellAsText(int row, int column) {
        TableCell cell = this.getTableCell(row, column);
        return cell == null ? "" : cell.asText();
    }

    public TableCell getTableCell(int row, int column) {
        if (this._cells == null) {
            this.readTable();
        }
        return this._cells[row][column];
    }

    public TableCell getTableCellWithID(String id) {
        if (this._cells == null) {
            this.readTable();
        }
        int i = 0;
        while (i < this.getRowCount()) {
            int j = 0;
            while (j < this.getColumnCount()) {
                if (this._cells[i][j] != null) {
                    String idToCompare = NodeUtils.getNodeAttribute(this._cells[i][j].getOriginalDOM(), "id");
                    if (HttpUnitOptions.getMatchesIgnoreCase()) {
                        if (id.equalsIgnoreCase(idToCompare)) {
                            return this._cells[i][j];
                        }
                        if (id.equals(idToCompare)) {
                            return this._cells[i][j];
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public void purgeEmptyCells() {
        int numRowsWithText = 0;
        int numColumnsWithText = 0;
        boolean[] rowHasText = new boolean[this.getRowCount()];
        boolean[] columnHasText = new boolean[this.getColumnCount()];
        Hashtable<TableCell, int[]> spanningCells = new Hashtable<TableCell, int[]>();
        int i = 0;
        while (i < rowHasText.length) {
            int j = 0;
            while (j < columnHasText.length) {
                if (this.getCellAsText(i, j).trim().length() != 0) {
                    if (this.getTableCell(i, j).getColSpan() == 1 && this.getTableCell(i, j).getRowSpan() == 1) {
                        if (!rowHasText[i]) {
                            ++numRowsWithText;
                        }
                        if (!columnHasText[j]) {
                            ++numColumnsWithText;
                        }
                        columnHasText[j] = true;
                        rowHasText[i] = true;
                    } else if (!spanningCells.containsKey(this.getTableCell(i, j))) {
                        spanningCells.put(this.getTableCell(i, j), new int[]{i, j});
                    }
                }
                ++j;
            }
            ++i;
        }
        Enumeration e = spanningCells.keys();
        while (e.hasMoreElements()) {
            TableCell cell = (TableCell)e.nextElement();
            int[] coords = (int[])spanningCells.get(cell);
            boolean neededInRow = true;
            boolean neededInCol = true;
            int i2 = coords[0];
            while (neededInRow && i2 < coords[0] + cell.getRowSpan()) {
                neededInRow = !rowHasText[i2];
                ++i2;
            }
            int j = coords[1];
            while (neededInCol && j < coords[1] + cell.getColSpan()) {
                neededInCol = !columnHasText[j];
                ++j;
            }
            if (neededInRow) {
                rowHasText[coords[0]] = true;
                ++numRowsWithText;
            }
            if (!neededInCol) continue;
            columnHasText[coords[1]] = true;
            ++numColumnsWithText;
        }
        TableCell[][] remainingCells = new TableCell[numRowsWithText][numColumnsWithText];
        int targetRow = 0;
        int i3 = 0;
        while (i3 < rowHasText.length) {
            if (rowHasText[i3]) {
                int targetColumn = 0;
                int j = 0;
                while (j < columnHasText.length) {
                    if (columnHasText[j]) {
                        remainingCells[targetRow][targetColumn++] = this._cells[i3][j];
                    }
                    ++j;
                }
                ++targetRow;
            }
            ++i3;
        }
        this._cells = remainingCells;
    }

    public String[][] asText() {
        String[][] result = new String[this.getRowCount()][this.getColumnCount()];
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result[0].length) {
                result[i][j] = this.getCellAsText(i, j);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public String getSummary() {
        return NodeUtils.getNodeAttribute(this._dom, "summary");
    }

    public String getID() {
        return NodeUtils.getNodeAttribute(this._dom, "id");
    }

    public String toString() {
        String eol = System.getProperty("line.separator");
        if (this._cells == null) {
            this.readTable();
        }
        StringBuffer sb = new StringBuffer(2048).append("WebTable:").append(eol);
        int i = 0;
        while (i < this._cells.length) {
            sb.append("[").append(i).append("]: ");
            int j = 0;
            while (j < this._cells[i].length) {
                sb.append("  [").append(j).append("]=");
                if (this._cells[i][j] == null) {
                    sb.append("null");
                } else {
                    sb.append(this._cells[i][j].asText());
                }
                ++j;
            }
            sb.append(eol);
            ++i;
        }
        return sb.toString();
    }

    static WebTable[] getTables(Node domRoot, URL baseURL, String parentTarget, String characterSet) {
        NodeList nl = NodeUtils.getElementsByTagName(domRoot, "table");
        Vector<WebTable> topLevelTables = new Vector<WebTable>();
        int i = 0;
        while (i < nl.getLength()) {
            if (WebTable.isTopLevelTable(nl.item(i), domRoot)) {
                topLevelTables.addElement(new WebTable(nl.item(i), baseURL, parentTarget, characterSet));
            }
            ++i;
        }
        Object[] result = new WebTable[topLevelTables.size()];
        topLevelTables.copyInto(result);
        return result;
    }

    private WebTable(Node domTreeRoot, URL sourceURL, String parentTarget, String characterSet) {
        this._dom = (Element)domTreeRoot;
        this._url = sourceURL;
        this._parentTarget = parentTarget;
        this._characterSet = characterSet;
    }

    private void readTable() {
        TableRow[] rows = this.getRows();
        int[] columnsRequired = new int[rows.length];
        int i = 0;
        while (i < rows.length) {
            TableCell[] cells = rows[i].getCells();
            int j = 0;
            while (j < cells.length) {
                int spannedRows = Math.min(columnsRequired.length - i, cells[j].getRowSpan());
                int k = 0;
                while (k < spannedRows) {
                    int n = i + k;
                    columnsRequired[n] = columnsRequired[n] + cells[j].getColSpan();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int numColumns = 0;
        int i2 = 0;
        while (i2 < columnsRequired.length) {
            numColumns = Math.max(numColumns, columnsRequired[i2]);
            ++i2;
        }
        this._cells = new TableCell[columnsRequired.length][numColumns];
        int i3 = 0;
        while (i3 < rows.length) {
            TableCell[] cells = rows[i3].getCells();
            int j = 0;
            while (j < cells.length) {
                int spannedRows = Math.min(columnsRequired.length - i3, cells[j].getRowSpan());
                int k = 0;
                while (k < spannedRows) {
                    int l = 0;
                    while (l < cells[j].getColSpan()) {
                        this.placeCell(i3 + k, j + l, cells[j]);
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
    }

    private void placeCell(int row, int column, TableCell cell) {
        while (this._cells[row][column] != null) {
            ++column;
        }
        this._cells[row][column] = cell;
    }

    private static boolean isTopLevelTable(Node tableNode, Node root) {
        return WebTable.isMoreCloselyNested(tableNode, root, "table");
    }

    private static boolean isMoreCloselyNested(Node node, Node desiredParentNode, String undesiredParentTag) {
        node = node.getParentNode();
        while (node != desiredParentNode) {
            if (node.getNodeName().equalsIgnoreCase(undesiredParentTag)) {
                return false;
            }
            if (node.getParentNode() == null) {
                return true;
            }
            node = node.getParentNode();
        }
        return true;
    }

    private TableRow[] getRows() {
        final Vector rows = new Vector();
        WebTable.processChildren(this._dom, "tr", "table", new ElementHandler(){

            public void handleElement(Element element) {
                rows.addElement(new TableRow(element));
            }
        });
        Object[] result = new TableRow[rows.size()];
        rows.copyInto(result);
        return result;
    }

    static void processChildren(Element root, String childTag, String avoidingParentTag, ElementHandler handler) {
        NodeList nl = root.getElementsByTagName(childTag);
        int i = 0;
        while (i < nl.getLength()) {
            if (WebTable.isMoreCloselyNested(nl.item(i), root, avoidingParentTag)) {
                handler.handleElement((Element)nl.item(i));
            }
            ++i;
        }
    }

    static /* synthetic */ URL access$100(WebTable x0) {
        return x0._url;
    }

    static /* synthetic */ String access$200(WebTable x0) {
        return x0._parentTarget;
    }

    static /* synthetic */ String access$300(WebTable x0) {
        return x0._characterSet;
    }

    static interface ElementHandler {
        public void handleElement(Element var1);
    }

    class TableRow {
        private Element _element;

        Element getElement() {
            return this._element;
        }

        TableCell[] getCells() {
            Vector cells = new Vector();
            this.collectChildren("td", cells);
            this.collectChildren("th", cells);
            Object[] result = new TableCell[cells.size()];
            cells.copyInto(result);
            return result;
        }

        private void collectChildren(String childTag, Vector children) {
            WebTable.processChildren(this._element, childTag, "table", new ElementHandler(this, children){
                private final /* synthetic */ Vector val$children;
                private final /* synthetic */ TableRow this$1;
                {
                    this.this$1 = this$1;
                    this.val$children = val$children;
                }

                public void handleElement(Element element) {
                    this.val$children.addElement(new TableCell(element, WebTable.access$100(TableRow.access$000(this.this$1)), WebTable.access$200(TableRow.access$000(this.this$1)), WebTable.access$300(TableRow.access$000(this.this$1))));
                }
            });
        }

        TableRow(Element rowNode) {
            this._element = rowNode;
        }

        static /* synthetic */ WebTable access$000(TableRow x0) {
            return x0.WebTable.this;
        }
    }
}

