/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import java.net.URL;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ParsedHTML {
    private WebForm[] _forms;
    private Node _rootNode;
    private WebLink[] _links;
    private URL _baseURL;
    private String _baseTarget;
    private String _characterSet;

    ParsedHTML(URL baseURL, String baseTarget, Node rootNode, String characterSet) {
        this._baseURL = baseURL;
        this._baseTarget = baseTarget;
        this._rootNode = rootNode;
        this._characterSet = characterSet;
    }

    public WebForm[] getForms() {
        if (this._forms == null) {
            NodeList forms = NodeUtils.getElementsByTagName(this._rootNode, "form");
            this._forms = new WebForm[forms.getLength()];
            int i = 0;
            while (i < this._forms.length) {
                this._forms[i] = new WebForm(this._baseURL, this._baseTarget, forms.item(i), this._characterSet);
                ++i;
            }
        }
        return this._forms;
    }

    public WebForm getFormWithID(String ID) {
        WebForm[] forms = this.getForms();
        int i = 0;
        while (i < forms.length) {
            if (forms[i].getID().equals(ID)) {
                return forms[i];
            }
            if (HttpUnitOptions.getMatchesIgnoreCase() && forms[i].getID().equalsIgnoreCase(ID)) {
                return forms[i];
            }
            ++i;
        }
        return null;
    }

    public WebForm getFormWithName(String name) {
        WebForm[] forms = this.getForms();
        int i = 0;
        while (i < forms.length) {
            if (forms[i].getName().equals(name)) {
                return forms[i];
            }
            if (HttpUnitOptions.getMatchesIgnoreCase() && forms[i].getName().equalsIgnoreCase(name)) {
                return forms[i];
            }
            ++i;
        }
        return null;
    }

    public WebLink[] getLinks() {
        if (this._links == null) {
            Vector list = new Vector();
            this.addLinkAnchors(list, NodeUtils.getElementsByTagName(this._rootNode, "a"));
            this.addLinkAnchors(list, NodeUtils.getElementsByTagName(this._rootNode, "area"));
            this._links = new WebLink[list.size()];
            list.copyInto(this._links);
        }
        return this._links;
    }

    private void addLinkAnchors(Vector list, NodeList nl) {
        int i = 0;
        while (i < nl.getLength()) {
            Node child = nl.item(i);
            if (this.isLinkAnchor(child)) {
                list.addElement(new WebLink(this._baseURL, this._baseTarget, child));
            }
            ++i;
        }
    }

    public WebLink getLinkWith(String text) {
        WebLink[] links = this.getLinks();
        int i = 0;
        while (i < links.length) {
            if (this.contains(links[i].asText(), text)) {
                return links[i];
            }
            ++i;
        }
        return null;
    }

    public WebLink getLinkWithImageText(String text) {
        WebLink[] links = this.getLinks();
        int i = 0;
        while (i < links.length) {
            NodeList nl = ((Element)links[i].getDOMSubtree()).getElementsByTagName("img");
            int j = 0;
            while (j < nl.getLength()) {
                NamedNodeMap nnm = nl.item(j).getAttributes();
                if (text.equals(this.getValue(nnm.getNamedItem("alt")))) {
                    return links[i];
                }
                if (HttpUnitOptions.getMatchesIgnoreCase() && text.equalsIgnoreCase(this.getValue(nnm.getNamedItem("alt")))) {
                    return links[i];
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public WebLink getLinkWithID(String ID) {
        WebLink[] links = this.getLinks();
        int i = 0;
        while (i < links.length) {
            if (links[i].getID().equals(ID)) {
                return links[i];
            }
            if (HttpUnitOptions.getMatchesIgnoreCase() && links[i].getID().equalsIgnoreCase(ID)) {
                return links[i];
            }
            ++i;
        }
        return null;
    }

    public WebLink getLinkWithName(String name) {
        WebLink[] links = this.getLinks();
        int i = 0;
        while (i < links.length) {
            if (links[i].getName().equals(name)) {
                return links[i];
            }
            if (HttpUnitOptions.getMatchesIgnoreCase() && links[i].getName().equalsIgnoreCase(name)) {
                return links[i];
            }
            ++i;
        }
        return null;
    }

    public WebTable[] getTables() {
        return WebTable.getTables(this.getOriginalDOM(), this._baseURL, this._baseTarget, this._characterSet);
    }

    public WebTable getTableStartingWith(final String text) {
        return this.getTableSatisfyingPredicate(this.getTables(), new TablePredicate(){

            public boolean isTrue(WebTable table) {
                table.purgeEmptyCells();
                return table.getRowCount() > 0 && ParsedHTML.this.matches(table.getCellAsText(0, 0), text);
            }
        });
    }

    public WebTable getTableStartingWithPrefix(final String text) {
        return this.getTableSatisfyingPredicate(this.getTables(), new TablePredicate(){

            public boolean isTrue(WebTable table) {
                table.purgeEmptyCells();
                return table.getRowCount() > 0 && ParsedHTML.this.hasPrefix(table.getCellAsText(0, 0).toUpperCase(), text);
            }
        });
    }

    public WebTable getTableWithSummary(final String summary) {
        return this.getTableSatisfyingPredicate(this.getTables(), new TablePredicate(){

            public boolean isTrue(WebTable table) {
                return ParsedHTML.this.matches(table.getSummary(), summary);
            }
        });
    }

    public WebTable getTableWithID(final String ID) {
        return this.getTableSatisfyingPredicate(this.getTables(), new TablePredicate(){

            public boolean isTrue(WebTable table) {
                return ParsedHTML.this.matches(table.getID(), ID);
            }
        });
    }

    public Node getDOM() {
        return this._rootNode.cloneNode(true);
    }

    Node getOriginalDOM() {
        return this._rootNode;
    }

    public String toString() {
        return this._baseURL.toExternalForm() + System.getProperty("line.separator") + this._rootNode;
    }

    protected void setBaseURL(URL baseURL) {
        this._baseURL = baseURL;
    }

    protected void setBaseTarget(String baseTarget) {
        this._baseTarget = baseTarget;
    }

    URL getBaseURL() {
        return this._baseURL;
    }

    private boolean contains(String string, String substring) {
        if (HttpUnitOptions.getMatchesIgnoreCase()) {
            return string.toUpperCase().indexOf(substring.toUpperCase()) >= 0;
        }
        return string.indexOf(substring) >= 0;
    }

    private boolean hasPrefix(String string, String prefix) {
        if (HttpUnitOptions.getMatchesIgnoreCase()) {
            return string.toUpperCase().startsWith(prefix.toUpperCase());
        }
        return string.startsWith(prefix);
    }

    private boolean matches(String string1, String string2) {
        if (HttpUnitOptions.getMatchesIgnoreCase()) {
            return string1.equalsIgnoreCase(string2);
        }
        return string1.equals(string2);
    }

    private String getValue(Node node) {
        return node == null ? "" : node.getNodeValue();
    }

    private boolean isLinkAnchor(Node node) {
        if (node.getNodeType() != 1) {
            return false;
        }
        if (!node.getNodeName().equals("a") && !node.getNodeName().equals("area")) {
            return false;
        }
        return node.getAttributes().getNamedItem("href") != null;
    }

    private WebTable getTableSatisfyingPredicate(WebTable[] tables, TablePredicate predicate) {
        int i = 0;
        while (i < tables.length) {
            if (predicate.isTrue(tables[i])) {
                return tables[i];
            }
            int j = 0;
            while (j < tables[i].getRowCount()) {
                int k = 0;
                while (k < tables[i].getColumnCount()) {
                    WebTable result;
                    WebTable[] innerTables;
                    TableCell cell = tables[i].getTableCell(j, k);
                    if (cell != null && (innerTables = cell.getTables()).length != 0 && (result = this.getTableSatisfyingPredicate(innerTables, predicate)) != null) {
                        return result;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    static interface TablePredicate {
        public boolean isTrue(WebTable var1);
    }
}

