/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sos;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public abstract class SOS
extends Task {
    private String sosCmdDir = null;
    private String sosUsername = null;
    private String sosPassword = "";
    private String projectPath = null;
    private String vssServerPath = null;
    private String sosServerPath = null;
    private String sosHome = null;
    private String localPath = null;
    private String version = null;
    private String label = null;
    private String comment = null;
    private String filename = null;
    private boolean noCompress = false;
    private boolean noCache = false;
    private boolean recursive = false;
    private boolean verbose = false;

    public void setNoCache(boolean nocache) {
        this.noCache = nocache;
    }

    public void setNoCompress(boolean nocompress) {
        this.noCompress = nocompress;
    }

    public final void setSosCmd(String dir) {
        this.sosCmdDir = Project.translatePath((String)dir);
    }

    public final void setUsername(String username) {
        this.sosUsername = username;
    }

    public final void setPassword(String password) {
        this.sosPassword = password;
    }

    public final void setProjectPath(String projectpath) {
        this.projectPath = "$" + projectpath;
    }

    public final void setVssServerPath(String vssServerPath) {
        this.vssServerPath = vssServerPath;
    }

    public final void setSosHome(String sosHome) {
        this.sosHome = sosHome;
    }

    public final void setSosServerPath(String sosServerPath) {
        this.sosServerPath = sosServerPath;
    }

    public void setLocalPath(Path path) {
        this.localPath = path.toString();
    }

    public final void setFile(String filename) {
        this.filename = filename;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getSosCommand() {
        if (this.sosCmdDir == null) {
            return "soscmd";
        }
        return this.sosCmdDir + File.separator + "soscmd";
    }

    public String getComment() {
        return this.comment;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLabel() {
        return this.label;
    }

    public String getUsername() {
        return this.sosUsername;
    }

    public String getPassword() {
        return this.sosPassword;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getVssServerPath() {
        return this.vssServerPath;
    }

    public String getSosHome() {
        return this.sosHome;
    }

    public String getSosServerPath() {
        return this.sosServerPath;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getNoCompress() {
        if (!this.noCompress) {
            return "";
        }
        return "-nocompress";
    }

    public String getNoCache() {
        if (!this.noCache) {
            return "";
        }
        return "-nocache";
    }

    public String getVerbose() {
        if (!this.verbose) {
            return "";
        }
        return "-verbose";
    }

    public String getRecursive() {
        if (!this.recursive) {
            return "";
        }
        return "-recursive";
    }

    public String getLocalPath() {
        if (this.localPath == null) {
            return this.project.getBaseDir().getAbsolutePath();
        }
        File dir = this.project.resolveFile(this.localPath);
        if (!dir.exists()) {
            boolean done = dir.mkdirs();
            if (!done) {
                String msg = "Directory " + this.localPath + " creation was not " + "successful for an unknown reason";
                throw new BuildException(msg, this.location);
            }
            this.project.log("Created dir: " + dir.getAbsolutePath());
        }
        return dir.getAbsolutePath();
    }

    protected int run(Commandline cmd) {
        try {
            Execute exe = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1));
            exe.setAntRun(this.project);
            exe.setWorkingDirectory(this.project.getBaseDir());
            exe.setCommandline(cmd.getCommandline());
            return exe.execute();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.location);
        }
    }
}

