/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.optional.dotnet.NetCommand;

public class Ilasm
extends MatchingTask {
    protected static final String exe_name = "ilasm";
    protected static final String file_ext = "il";
    protected static final String file_pattern = "**/*.il";
    protected static final String exe_title = "ilasm";
    private File srcDir;
    protected String targetType;
    protected boolean verbose;
    protected boolean listing;
    protected File outputFile;
    protected File resourceFile;
    protected boolean failOnError;
    protected boolean debug;
    private File keyfile;
    protected String extraOptions;

    public Ilasm() {
        this.Clear();
        this.setIncludes(file_pattern);
    }

    public void Clear() {
        this.targetType = null;
        this.srcDir = null;
        this.listing = false;
        this.verbose = false;
        this.debug = true;
        this.outputFile = null;
        this.failOnError = true;
        this.resourceFile = null;
        this.extraOptions = null;
    }

    public void setSrcDir(File srcDirName) {
        this.srcDir = srcDirName;
    }

    public void setTargetType(String targetType) throws BuildException {
        this.targetType = targetType.toLowerCase();
        if (!targetType.equals("exe") && !targetType.equals("library")) {
            throw new BuildException("targetType " + targetType + " is not a valid type");
        }
    }

    public String getTargetType() {
        return this.targetType;
    }

    protected String getTargetTypeParameter() {
        if (!this.notEmpty(this.targetType)) {
            return null;
        }
        if (this.targetType.equals("exe")) {
            return "/exe";
        }
        if (this.targetType.equals("library")) {
            return "/dll";
        }
        return null;
    }

    public void setOwner(String s) {
        this.log("This option is not supported by ILASM as of Beta-2, and will be ignored", 1);
    }

    protected boolean notEmpty(String s) {
        return s != null && s.length() != 0;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    protected String getVerboseParameter() {
        return this.verbose ? null : "/quiet";
    }

    public void setListing(boolean b) {
        this.listing = b;
    }

    protected String getListingParameter() {
        return this.listing ? "/listing" : "/nolisting";
    }

    public void setOutputFile(File params) {
        this.outputFile = params;
    }

    protected String getOutputFileParameter() {
        if (this.outputFile == null || this.outputFile.length() == 0L) {
            return null;
        }
        File f = this.outputFile;
        return "/output=" + f.toString();
    }

    public void setResourceFile(File fileName) {
        this.resourceFile = fileName;
    }

    protected String getResourceFileParameter() {
        if (this.resourceFile != null) {
            return "/resource=" + this.resourceFile.toString();
        }
        return null;
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public boolean getFailFailOnError() {
        return this.failOnError;
    }

    public void setDebug(boolean f) {
        this.debug = f;
    }

    public boolean getDebug() {
        return this.debug;
    }

    protected String getDebugParameter() {
        return this.debug ? "/debug" : null;
    }

    public void setKeyfile(File keyfile) {
        this.keyfile = keyfile;
    }

    protected String getKeyfileParameter() {
        if (this.keyfile != null) {
            return "/keyfile:" + this.keyfile.toString();
        }
        return null;
    }

    public void setExtraOptions(String extraOptions) {
        this.extraOptions = extraOptions;
    }

    public String getExtraOptions() {
        return this.extraOptions;
    }

    protected String getExtraOptionsParameter() {
        if (this.extraOptions != null && this.extraOptions.length() != 0) {
            return this.extraOptions;
        }
        return null;
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            this.srcDir = this.project.resolveFile(".");
        }
        DirectoryScanner scanner = super.getDirectoryScanner(this.srcDir);
        String[] dependencies = scanner.getIncludedFiles();
        this.log("assembling " + dependencies.length + " file" + (dependencies.length == 1 ? "" : "s"));
        String baseDir = scanner.getBasedir().toString();
        int i = 0;
        while (i < dependencies.length) {
            String targetFile = dependencies[i];
            targetFile = baseDir + File.separator + targetFile;
            this.executeOneFile(targetFile);
            ++i;
        }
    }

    public void executeOneFile(String targetFile) throws BuildException {
        NetCommand command = new NetCommand((Task)this, "ilasm", "ilasm");
        command.setFailOnError(this.getFailFailOnError());
        command.setTraceCommandLine(true);
        command.addArgument(this.getDebugParameter());
        command.addArgument(this.getTargetTypeParameter());
        command.addArgument(this.getListingParameter());
        command.addArgument(this.getOutputFileParameter());
        command.addArgument(this.getResourceFileParameter());
        command.addArgument(this.getVerboseParameter());
        command.addArgument(this.getKeyfileParameter());
        command.addArgument(this.getExtraOptionsParameter());
        command.addArgument(targetFile);
        command.runCommand();
    }

    static {
        exe_name = "ilasm";
        file_ext = file_ext;
        file_pattern = file_pattern;
        exe_title = "ilasm";
    }
}

