/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javassist.CtBehavior;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.pointcut.ConstructorMatcher;
import org.jboss.aop.pointcut.MatcherHelper;
import org.jboss.aop.pointcut.MethodMatcher;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.Util;
import org.jboss.aop.pointcut.ast.ASTConstructor;
import org.jboss.aop.pointcut.ast.ASTMethod;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ASTWithin;
import org.jboss.aop.pointcut.ast.ASTWithincode;

public class WithinMatcher
extends MatcherHelper {
    CtBehavior behavior;
    Advisor advisor;
    AccessibleObject accessible;

    public WithinMatcher(Advisor advisor, CtBehavior behavior, ASTStart start) throws NotFoundException {
        super(start, advisor.getManager());
        this.advisor = advisor;
        this.behavior = behavior;
    }

    public WithinMatcher(Advisor advisor, AccessibleObject behavior, ASTStart start) {
        super(start, advisor.getManager());
        this.advisor = advisor;
        this.accessible = behavior;
    }

    protected Boolean resolvePointcut(Pointcut p) {
        throw new RuntimeException("NOT REACHABLE");
    }

    public Class getDeclaringClass() {
        if (this.accessible instanceof Constructor) {
            return ((Constructor)this.accessible).getDeclaringClass();
        }
        if (this.accessible instanceof Method) {
            return ((Method)this.accessible).getDeclaringClass();
        }
        return null;
    }

    public Object visit(ASTWithin node, Object data) {
        if (this.behavior != null ? !Util.matchesClassExpr(node.getClazz(), this.behavior.getDeclaringClass(), this.advisor) : !Util.matchesClassExpr(node.getClazz(), this.getDeclaringClass(), this.advisor)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Object visit(ASTWithincode node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, null);
    }

    public Object visit(ASTMethod node, Object data) {
        if (this.behavior != null) {
            if (this.behavior instanceof CtConstructor) {
                return Boolean.FALSE;
            }
            MethodMatcher matcher = new MethodMatcher(this.advisor, (CtMethod)this.behavior, null);
            return matcher.matches(node);
        }
        if (this.accessible instanceof Constructor) {
            return Boolean.FALSE;
        }
        MethodMatcher matcher = new MethodMatcher(this.advisor, (Method)this.accessible, null);
        return matcher.matches(node);
    }

    public Object visit(ASTConstructor node, Object data) {
        if (this.behavior != null) {
            try {
                if (this.behavior instanceof CtMethod) {
                    return Boolean.FALSE;
                }
                ConstructorMatcher matcher = new ConstructorMatcher(this.advisor, (CtConstructor)this.behavior, null);
                return matcher.matches(node);
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.accessible instanceof Method) {
            return Boolean.FALSE;
        }
        ConstructorMatcher matcher = new ConstructorMatcher(this.advisor, (Constructor)this.accessible, null);
        return matcher.matches(node);
    }
}

