/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.remoting.client;

import java.io.Serializable;
import java.rmi.AccessException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.UserTransaction;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.remoting.interfaces.HeuristicHazardException;
import org.jboss.tm.remoting.interfaces.Status;
import org.jboss.tm.remoting.interfaces.TransactionFactory;
import org.jboss.tm.remoting.interfaces.TransactionInactiveException;
import org.jboss.tm.remoting.interfaces.TxPropagationContext;

public class ClientUserTransaction
implements UserTransaction,
TransactionPropagationContextFactory,
Referenceable,
Serializable {
    static final long serialVersionUID = -3704980350844202097L;
    private static ClientUserTransaction singleton = null;
    public static final String TX_FACTORY_JNDI_NAME = "DTMTransactionFactory";
    private static TransactionFactory txFactory;
    private static ThreadLocal threadLocalData;

    private static void setThreadLocalTimeout(int timeout) {
        ((TransactionInfo)ClientUserTransaction.threadLocalData.get()).timeout = timeout;
    }

    private static int getThreadLocalTimeout() {
        return ((TransactionInfo)ClientUserTransaction.threadLocalData.get()).timeout;
    }

    private static void setThreadLocalTPC(TxPropagationContext tpc) {
        ((TransactionInfo)ClientUserTransaction.threadLocalData.get()).tpc = tpc;
    }

    private static TxPropagationContext getThreadLocalTPC() throws IllegalStateException {
        return ((TransactionInfo)ClientUserTransaction.threadLocalData.get()).tpc;
    }

    private static TransactionFactory getTxFactory() {
        if (txFactory == null) {
            try {
                InitialContext ctx = new InitialContext();
                txFactory = (TransactionFactory)ctx.lookup(TX_FACTORY_JNDI_NAME);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get transaction factory: ", e);
            }
        }
        return txFactory;
    }

    private static int jbossToJavax(Status status) {
        return status.toInteger();
    }

    private ClientUserTransaction() {
    }

    public static ClientUserTransaction getSingleton() {
        if (singleton == null) {
            singleton = new ClientUserTransaction();
        }
        return singleton;
    }

    public void begin() throws NotSupportedException, SystemException {
        if (ClientUserTransaction.getThreadLocalTPC() != null) {
            throw new NotSupportedException();
        }
        try {
            TxPropagationContext tpc = ClientUserTransaction.getTxFactory().create(ClientUserTransaction.getThreadLocalTimeout());
            ClientUserTransaction.setThreadLocalTPC(tpc);
        }
        catch (RemoteException e) {
            SystemException e2 = new SystemException("Unable to begin transaction");
            e2.initCause(e);
            throw e2;
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        try {
            TxPropagationContext tpc = ClientUserTransaction.getThreadLocalTPC();
            if (tpc == null) {
                throw new IllegalStateException();
            }
            tpc.terminator.commit(true);
        }
        catch (TransactionRolledbackException e) {
            RollbackException e2 = new RollbackException("Transaction rolled back");
            e2.initCause(e);
            throw e2;
        }
        catch (HeuristicHazardException e) {
            HeuristicRollbackException e2 = new HeuristicRollbackException("Heuristic hazard");
            e2.initCause(e);
            throw e2;
        }
        catch (AccessException e) {
            SecurityException e2 = new SecurityException("Access denied");
            e2.initCause(e);
            throw e2;
        }
        catch (RemoteException e) {
            SystemException e2 = new SystemException("Error during commit");
            e2.initCause(e);
            throw e2;
        }
        finally {
            ClientUserTransaction.setThreadLocalTPC(null);
        }
    }

    public void rollback() throws SecurityException, IllegalStateException, SystemException {
        try {
            TxPropagationContext tpc = ClientUserTransaction.getThreadLocalTPC();
            if (tpc == null) {
                throw new IllegalStateException();
            }
            tpc.terminator.rollback();
        }
        catch (AccessException e) {
            SecurityException e2 = new SecurityException("Access denied");
            e2.initCause(e);
            throw e2;
        }
        catch (RemoteException e) {
            SystemException e2 = new SystemException("Error during rollback");
            e2.initCause(e);
            throw e2;
        }
        finally {
            ClientUserTransaction.setThreadLocalTPC(null);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        try {
            TxPropagationContext tpc = ClientUserTransaction.getThreadLocalTPC();
            if (tpc == null) {
                throw new IllegalStateException();
            }
            tpc.coordinator.rollbackOnly();
        }
        catch (TransactionInactiveException e) {
            IllegalStateException e2 = new IllegalStateException("Transaction is not active");
            e2.initCause(e);
            throw e2;
        }
        catch (RemoteException e) {
            SystemException e2 = new SystemException("Error during rollback");
            e2.initCause(e);
            throw e2;
        }
    }

    public int getStatus() throws SystemException {
        try {
            TxPropagationContext tpc = ClientUserTransaction.getThreadLocalTPC();
            if (tpc == null) {
                return 6;
            }
            return ClientUserTransaction.jbossToJavax(tpc.coordinator.getStatus());
        }
        catch (NoSuchObjectException e) {
            return 6;
        }
        catch (RemoteException e) {
            SystemException e2 = new SystemException("Error getting status");
            e2.initCause(e);
            throw e2;
        }
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        ClientUserTransaction.setThreadLocalTimeout(seconds);
    }

    public Object getTransactionPropagationContext() {
        return ClientUserTransaction.getThreadLocalTPC();
    }

    public Object getTransactionPropagationContext(Transaction tx) {
        throw new InternalError("Should not have been used.");
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference("org.jboss.tm.remoting.client.ClientUserTransaction", "org.jboss.tm.remoting.client.ClientUserTransactionObjectFactory", null);
        return ref;
    }

    static {
        threadLocalData = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new TransactionInfo();
            }
        };
    }

    private static class TransactionInfo {
        int timeout = 0;
        TxPropagationContext tpc;

        private TransactionInfo() {
        }
    }
}

