/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.recovery;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jboss.logging.Logger;
import org.jboss.tm.recovery.HexDump;
import org.jboss.tm.recovery.LogRecord;

public class HeuristicStatusLog {
    private static Logger errorLog = Logger.getLogger(HeuristicStatusLog.class);
    private static boolean traceEnabled = errorLog.isTraceEnabled();
    private File logFile;
    RandomAccessFile os;
    private FileChannel channel;

    HeuristicStatusLog(File dir) throws IOException {
        this.logFile = File.createTempFile("HEURISTIC_STATUS_LOG", ".log", dir);
        this.os = new RandomAccessFile(this.logFile, "rw");
        this.channel = this.os.getChannel();
        this.channel.force(true);
    }

    void write(ByteBuffer record) {
        if (traceEnabled) {
            errorLog.trace("Heuristic status log record:" + HexDump.fromBuffer(record.array()));
            errorLog.trace(LogRecord.toString(record));
        }
        try {
            this.channel.write(record);
            this.channel.force(true);
        }
        catch (IOException e) {
            errorLog.error("Error writing heuristic status log " + this.logFile.getName(), e);
        }
    }

    void close() {
        try {
            this.os.close();
        }
        catch (IOException e) {
            errorLog.error("Error closing heuristic status log " + this.logFile.getName(), e);
        }
    }
}

