/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import javax.transaction.xa.Xid;
import org.jboss.system.server.ServerConfigUtil;
import org.jboss.tm.GlobalId;
import org.jboss.tm.XidFactoryBase;
import org.jboss.tm.XidImpl;

public class XidFactoryImpl
implements XidFactoryBase {
    private String baseGlobalId;
    private long globalIdNumber = 0L;
    private boolean pad = false;
    private String branchQualifier;
    private byte[] baseGlobalIdBytes;
    private byte[] branchQualifierBytes;
    private byte[] baseBranchQualifierBytes;
    private long uniqueInstanceId = System.currentTimeMillis();

    public void start() {
        String hostName = ServerConfigUtil.getSpecificBindAddress();
        this.baseGlobalId = hostName + ":" + this.uniqueInstanceId;
        if (this.baseGlobalId.length() > 49) {
            this.baseGlobalId = this.baseGlobalId.substring(0, 49);
        }
        this.baseGlobalId = this.baseGlobalId + "/";
        this.baseGlobalIdBytes = this.baseGlobalId.getBytes();
        this.branchQualifier = hostName + ":" + this.uniqueInstanceId;
        int len = this.pad ? 64 : this.branchQualifier.length();
        this.branchQualifierBytes = new byte[len];
        this.branchQualifier.getBytes(0, this.branchQualifier.length(), this.branchQualifierBytes, 0);
        String baseBranchQualifier = this.branchQualifier + "/";
        this.baseBranchQualifierBytes = new byte[baseBranchQualifier.length()];
        baseBranchQualifier.getBytes(0, baseBranchQualifier.length(), this.baseBranchQualifierBytes, 0);
    }

    public long getUniqueInstanceId() {
        return this.uniqueInstanceId;
    }

    public void setUniqueInstanceId(long uniqueInstanceId) {
        this.uniqueInstanceId = uniqueInstanceId;
    }

    public String getBaseGlobalId() {
        return this.baseGlobalId;
    }

    public void setBaseGlobalId(String baseGlobalId) {
        this.baseGlobalId = baseGlobalId;
        this.baseGlobalIdBytes = baseGlobalId.getBytes();
    }

    public synchronized long getGlobalIdNumber() {
        return this.globalIdNumber;
    }

    public synchronized void setGlobalIdNumber(long globalIdNumber) {
        this.globalIdNumber = globalIdNumber;
    }

    public String getBranchQualifier() {
        return this.branchQualifier;
    }

    public void setBranchQualifier(String branchQualifier) {
        this.branchQualifier = branchQualifier;
        int len = this.pad ? 64 : branchQualifier.length();
        this.branchQualifierBytes = new byte[len];
        branchQualifier.getBytes(0, branchQualifier.length(), this.branchQualifierBytes, 0);
        String baseBranchQualifier = branchQualifier + "/";
        this.baseBranchQualifierBytes = new byte[baseBranchQualifier.length()];
        baseBranchQualifier.getBytes(0, baseBranchQualifier.length(), this.baseBranchQualifierBytes, 0);
    }

    public boolean isPad() {
        return this.pad;
    }

    public void setPad(boolean pad) {
        if (this.pad != pad) {
            this.pad = pad;
            if (this.branchQualifier != null) {
                int len = pad ? 64 : this.branchQualifier.length();
                this.branchQualifierBytes = new byte[len];
                this.branchQualifier.getBytes(0, this.branchQualifier.length(), this.branchQualifierBytes, 0);
            }
        }
    }

    public XidImpl newXid() {
        long localId = this.getNextId();
        return new XidImpl(this.localIdToGlobalId(localId), this.branchQualifierBytes, (int)localId, localId);
    }

    public XidImpl newBranch(GlobalId globalId) {
        long localId = this.getNextId();
        return new XidImpl(globalId, this.branchQualifierBytes, localId);
    }

    public XidImpl newBranch(XidImpl xid, long branchNum) {
        String id = Long.toString(branchNum);
        int len = this.pad ? 64 : this.baseBranchQualifierBytes.length + id.length();
        byte[] branchQualifier = new byte[len];
        System.arraycopy(this.baseBranchQualifierBytes, 0, branchQualifier, 0, this.baseBranchQualifierBytes.length);
        id.getBytes(0, id.length(), branchQualifier, this.baseBranchQualifierBytes.length);
        return new XidImpl(xid, branchQualifier);
    }

    public XidImpl recreateXid(long localId) {
        return new XidImpl(this.localIdToGlobalId(localId), this.branchQualifierBytes, (int)localId, localId);
    }

    public XidImpl recreateXid(long localId, GlobalId globalId) {
        return new XidImpl(globalId, this.branchQualifierBytes, localId);
    }

    public byte[] localIdToGlobalId(long localId) {
        String id = Long.toString(localId);
        int len = this.pad ? 64 : id.length() + this.baseGlobalIdBytes.length;
        byte[] globalId = new byte[len];
        System.arraycopy(this.baseGlobalIdBytes, 0, globalId, 0, this.baseGlobalIdBytes.length);
        id.getBytes(0, id.length(), globalId, this.baseGlobalIdBytes.length);
        return globalId;
    }

    public long extractLocalIdFrom(byte[] globalId) {
        int len = globalId.length;
        int i = 0;
        while (globalId[i++] != 47) {
        }
        int start = i;
        while (i < len && globalId[i] != 0) {
            ++i;
        }
        String globalIdNumber = new String(globalId, 0, start, i - start);
        return Long.parseLong(globalIdNumber);
    }

    public String getBaseBranchQualifier(byte[] branchQualifier) {
        int i;
        int len = branchQualifier.length;
        for (i = 0; branchQualifier[i] != 47 && branchQualifier[i] != 0 && i < len; ++i) {
        }
        String base = new String(branchQualifier, 0, 0, i);
        return base;
    }

    public String toString(Xid xid) {
        return XidImpl.toString(xid);
    }

    private synchronized long getNextId() {
        return ++this.globalIdNumber;
    }
}

