/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.jboss.security.auth.login.XMLLoginConfigImpl;
import org.jboss.security.auth.login.XMLLoginConfigMBean;
import org.jboss.system.ServiceMBeanSupport;

public class XMLLoginConfig
extends ServiceMBeanSupport
implements XMLLoginConfigMBean {
    XMLLoginConfigImpl config = new XMLLoginConfigImpl();

    public URL getConfigURL() {
        return this.config.getConfigURL();
    }

    public void setConfigURL(URL configURL) {
        this.config.setConfigURL(configURL);
    }

    public void setConfigResource(String resourceName) throws IOException {
        this.config.setConfigResource(resourceName);
    }

    public boolean getValidateDTD() {
        return this.config.getValidateDTD();
    }

    public void setValidateDTD(boolean flag) {
        this.config.setValidateDTD(flag);
    }

    public void addAppConfig(String appName, AppConfigurationEntry[] entries) {
        this.config.addAppConfig(appName, entries);
    }

    public void removeAppConfig(String appName) {
        this.config.removeAppConfig(appName);
    }

    public Configuration getConfiguration(Configuration prevConfig) {
        this.config.setParentConfig(prevConfig);
        return this.config;
    }

    public String[] loadConfig(URL configURL) throws Exception {
        return this.config.loadConfig(configURL);
    }

    public void removeConfigs(String[] appNames) {
        int count = appNames == null ? 0 : appNames.length;
        for (int a = 0; a < count; ++a) {
            this.removeAppConfig(appNames[a]);
        }
    }

    public String displayAppConfig(String appName) {
        StringBuffer buffer = new StringBuffer("<h2>" + appName + " LoginConfiguration</h2>\n");
        AppConfigurationEntry[] appEntry = this.config.getAppConfigurationEntry(appName);
        if (appEntry == null) {
            buffer.append("No Entry\n");
        } else {
            for (int c = 0; c < appEntry.length; ++c) {
                AppConfigurationEntry entry = appEntry[c];
                buffer.append("LoginModule Class: " + entry.getLoginModuleName());
                buffer.append("\n<br>ControlFlag: " + entry.getControlFlag());
                buffer.append("\n<br>Options:<ul>");
                Map<String, ?> options = entry.getOptions();
                Iterator<Map.Entry<String, ?>> iter = options.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<String, ?> e = iter.next();
                    buffer.append("<li>");
                    buffer.append("name=" + e.getKey());
                    buffer.append(", value=" + e.getValue());
                    buffer.append("</li>\n");
                }
                buffer.append("</ul>\n");
            }
        }
        return buffer.toString();
    }

    protected void startService() throws Exception {
        this.config.loadConfig();
    }

    protected void destroyService() {
        this.config.clear();
    }
}

