/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.net.URL;
import java.net.URLClassLoader;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployerInterceptor;
import org.jboss.mx.server.Invocation;
import org.jboss.mx.server.MBeanInvoker;
import org.jboss.security.auth.login.XMLLoginConfigMBean;

public class LoginConfigInterceptor
extends SubDeployerInterceptor {
    public static final String DEPLOYMENT_INFO_CONTEXT_KEY = LoginConfigInterceptor.class.getName();
    private String authConf = "META-INF/login-config.xml";
    private ObjectName loginConfigService = XMLLoginConfigMBean.OBJECT_NAME;
    private ObjectName securityMgrService;

    public LoginConfigInterceptor(MBeanInvoker invoker) {
        super(LoginConfigInterceptor.class.getName());
        this.log.debug("Constructed");
    }

    public void setAuthConfig(String authConf) {
        this.authConf = authConf;
        this.log.debug("setAuthConfig('" + authConf + "')");
    }

    public String getAuthConfig() {
        return this.authConf;
    }

    public void setLoginConfigService(ObjectName serviceName) {
        this.loginConfigService = serviceName;
        this.log.debug("setLoginConfigService('" + serviceName + "')");
    }

    public ObjectName getLoginConfigService() {
        return this.loginConfigService;
    }

    public void setSecurityManagerService(ObjectName serviceName) {
        this.securityMgrService = serviceName;
        this.log.debug("setSecurityManagerService('" + serviceName + "')");
    }

    public ObjectName getSecurityManagerService() {
        return this.securityMgrService;
    }

    protected Object create(Invocation invocation, DeploymentInfo di) throws Throwable {
        try {
            this.createDomains(di);
        }
        catch (Exception e) {
            this.log.warn("Ignoring exception", e);
        }
        try {
            return this.invokeNext(invocation);
        }
        catch (Throwable t) {
            try {
                this.destroyDomains(di);
            }
            catch (Exception e) {
                this.log.warn("Ignoring exception", e);
            }
            throw t;
        }
    }

    protected Object start(Invocation invocation, DeploymentInfo di) throws Throwable {
        try {
            return this.invokeNext(invocation);
        }
        catch (Throwable t) {
            try {
                this.destroyDomains(di);
            }
            catch (Exception e) {
                this.log.warn("Ignoring exception", e);
            }
            throw t;
        }
    }

    protected Object stop(Invocation invocation, DeploymentInfo di) throws Throwable {
        try {
            return this.invokeNext(invocation);
        }
        catch (Throwable t) {
            try {
                this.destroyDomains(di);
            }
            catch (Exception e) {
                this.log.warn("Ignoring exception", e);
            }
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object destroy(Invocation invocation, DeploymentInfo di) throws Throwable {
        try {
            Object object = this.invokeNext(invocation);
            return object;
        }
        finally {
            try {
                this.destroyDomains(di);
            }
            catch (Exception e) {
                this.log.warn("Ignoring exception", e);
            }
        }
    }

    private void createDomains(DeploymentInfo di) throws Exception {
        URL loginConfig;
        URLClassLoader loader = di.localCl;
        if (loader != null && (loginConfig = loader.getResource(this.authConf)) != null) {
            this.log.debug("Using JAAS AuthConfig: " + loginConfig.toExternalForm());
            MBeanServer server = di.getServer();
            Object[] args = new Object[]{loginConfig};
            String[] sig = new String[]{URL.class.getName()};
            String[] configNames = (String[])server.invoke(this.loginConfigService, "loadConfig", args, sig);
            di.context.put(DEPLOYMENT_INFO_CONTEXT_KEY, configNames);
            int count = configNames == null ? 0 : configNames.length;
            for (int n = 0; n < count; ++n) {
                this.log.debug("Loaded config: " + configNames[n]);
            }
        }
    }

    private void destroyDomains(DeploymentInfo di) throws Exception {
        String[] configNames = (String[])di.context.get(DEPLOYMENT_INFO_CONTEXT_KEY);
        if (configNames != null && configNames.length > 0) {
            di.context.remove(DEPLOYMENT_INFO_CONTEXT_KEY);
            MBeanServer server = di.getServer();
            this.flushAuthenticationCaches(server, configNames);
            Object[] args = new Object[]{configNames};
            String[] sig = new String[]{configNames.getClass().getName()};
            server.invoke(this.loginConfigService, "removeConfigs", args, sig);
        }
    }

    private void flushAuthenticationCaches(MBeanServer server, String[] configNames) throws Exception {
        if (this.securityMgrService != null && server.isRegistered(this.securityMgrService)) {
            int count = configNames == null ? 0 : configNames.length;
            String[] sig = new String[]{String.class.getName()};
            for (int n = 0; n < count; ++n) {
                Object[] args = new Object[]{configNames[n]};
                server.invoke(this.securityMgrService, "flushAuthenticationCache", args, sig);
                this.log.debug("Flushed domain: " + configNames[n]);
            }
        }
    }
}

