/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.net.ServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.MarshallLoaderFactory;
import org.jboss.remoting.transport.ConnectorMBean;
import org.jboss.remoting.transport.PortUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Connector
implements MBeanRegistration,
ConnectorMBean {
    protected ServerInvoker invoker;
    private String locatorURI;
    private Element xml;
    private Map configuration = new HashMap();
    private MBeanServer server;
    private Connector marshallerLoaderConnector = null;
    private boolean isMarshallerLoader = false;
    private boolean isStarted = false;
    private boolean isCreated = false;
    protected final Logger log = Logger.getLogger(this.getClass());
    static /* synthetic */ Class class$org$jboss$remoting$ServerInvocationHandler;

    public Connector() {
    }

    public Connector(String locatorURI) {
        this.locatorURI = locatorURI;
    }

    public Connector(InvokerLocator locator) {
        if (locator != null) {
            this.locatorURI = locator.getLocatorURI();
        }
    }

    public Connector(Map configuration) {
        this.configuration.putAll(configuration);
    }

    public Connector(String locatorURI, Map configuration) {
        this.locatorURI = locatorURI;
        this.configuration.putAll(configuration);
    }

    public Connector(InvokerLocator locator, Map configuration) {
        if (locator != null) {
            this.locatorURI = locator.getLocatorURI();
        }
        this.configuration.putAll(configuration);
    }

    protected Connector(boolean isMarshallerConnector) {
        this();
        this.isMarshallerLoader = isMarshallerConnector;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void start() throws Exception {
        if (!this.isStarted) {
            ClassLoader cl;
            if (!this.isCreated) {
                this.create();
            }
            if ((cl = Thread.currentThread().getContextClassLoader()) == null) {
                cl = this.getClass().getClassLoader();
            }
            this.configureHandlers(cl);
            if (!this.isMarshallerLoader && this.marshallerLoaderConnector != null && !this.marshallerLoaderConnector.isStarted()) {
                this.marshallerLoaderConnector.start();
            }
            if (!this.invoker.isStarted()) {
                try {
                    this.invoker.start();
                }
                catch (Exception e) {
                    if (this.marshallerLoaderConnector != null) {
                        this.marshallerLoaderConnector.stop();
                    }
                    this.log.error("Error starting connector.", e);
                    throw e;
                }
            }
            this.isStarted = true;
        }
    }

    public void start(boolean runAsNewThread) throws Exception {
        Runnable r = new Runnable(){

            public void run() {
                try {
                    Connector.this.start();
                }
                catch (Exception e) {
                    Connector.this.log.error("Error starting Connector.", e);
                }
            }
        };
        Thread t = new Thread(r);
        t.setDaemon(false);
        t.start();
    }

    private void init() throws Exception {
        HashMap invokerConfig = new HashMap();
        if (this.locatorURI == null) {
            if (this.xml != null) {
                this.getInvokerConfig(invokerConfig);
            }
            this.configuration.putAll(invokerConfig);
        }
        if (this.locatorURI == null) {
            throw new IllegalStateException("Connector not configured with LocatorURI.");
        }
        InvokerLocator locator = new InvokerLocator(this.locatorURI);
        if (this.invoker == null) {
            this.invoker = InvokerRegistry.createServerInvoker(locator, this.configuration);
            if (this.server != null) {
                try {
                    ObjectName objName = new ObjectName(this.invoker.getMBeanObjectName());
                    if (!this.server.isRegistered(objName)) {
                        this.server.registerMBean(this.invoker, objName);
                        this.invoker.setMBeanServer(this.server);
                    }
                }
                catch (Throwable e) {
                    this.log.warn("Error registering invoker " + this.invoker + " with MBeanServer.", e);
                }
            }
            this.invoker.create();
        }
        this.locatorURI = this.invoker.getLocator().getLocatorURI();
        if (!this.isMarshallerLoader && this.marshallerLoaderConnector == null) {
            this.marshallerLoaderConnector = this.createMarshallerLoader(this.invoker.getLocator());
        }
    }

    private Connector createMarshallerLoader(InvokerLocator locator) {
        MarshalFactory.getMarshaller(locator, this.getClass().getClassLoader());
        Connector marshallerLoader = null;
        InvokerLocator loaderLocator = MarshallLoaderFactory.convertLocator(locator);
        if (loaderLocator != null) {
            marshallerLoader = MarshallLoaderFactory.createMarshallLoader(loaderLocator);
        }
        return marshallerLoader;
    }

    private void getInvokerConfig(Map invokerConfig) {
        try {
            NodeList invokerNodes = this.xml.getElementsByTagName("invoker");
            if (invokerNodes != null && invokerNodes.getLength() >= 1) {
                Node invokerNode = invokerNodes.item(0);
                NamedNodeMap attributes = invokerNode.getAttributes();
                Node transportNode = attributes.getNamedItem("transport");
                if (transportNode != null) {
                    int port;
                    String host;
                    String transport = transportNode.getNodeValue();
                    if (invokerNodes.getLength() > 1) {
                        this.log.warn("Found more than one invokers defined in configuration.  Will only be using the first one - " + transport);
                    }
                    HashMap<String, String> paramConfig = new HashMap<String, String>();
                    NodeList invokerAttributes = invokerNode.getChildNodes();
                    int len = invokerAttributes.getLength();
                    for (int x = 0; x < len; ++x) {
                        Node attr = invokerAttributes.item(x);
                        if (!"attribute".equals(attr.getNodeName())) continue;
                        String name = attr.getAttributes().getNamedItem("name").getNodeValue();
                        String value = attr.getFirstChild().getNodeValue();
                        invokerConfig.put(name, value);
                        Node isParamAttribute = attr.getAttributes().getNamedItem("isParam");
                        if (isParamAttribute == null || !Boolean.valueOf(isParamAttribute.getNodeValue()).booleanValue()) continue;
                        paramConfig.put(name, value);
                    }
                    String clientConnectAddress = (String)invokerConfig.get("clientConnectAddress");
                    String clientConnectPort = (String)invokerConfig.get("clientConnectPort");
                    String serverBindAddress = (String)invokerConfig.get("serverBindAddress");
                    String serverBindPort = (String)invokerConfig.get("serverBindPort");
                    String path = (String)invokerConfig.get("path");
                    String string = clientConnectAddress != null ? clientConnectAddress : (host = serverBindAddress != null ? serverBindAddress : InetAddress.getLocalHost().getHostAddress());
                    int n = clientConnectPort != null ? Integer.parseInt(clientConnectPort) : (serverBindPort != null ? Integer.parseInt(serverBindPort) : (port = PortUtil.findFreePort(serverBindAddress != null ? serverBindAddress : InetAddress.getLocalHost().getHostAddress())));
                    if ("0.0.0.0".equals(host)) {
                        host = InetAddress.getLocalHost().getHostAddress();
                    }
                    String tempURI = transport + "://" + host + ":" + port;
                    if (path != null) {
                        tempURI = tempURI + "/" + path;
                    }
                    if (paramConfig.size() > 0) {
                        Object value;
                        Object name;
                        tempURI = tempURI + "/?";
                        Iterator keyItr = paramConfig.keySet().iterator();
                        if (keyItr.hasNext()) {
                            name = keyItr.next();
                            value = paramConfig.get(name);
                            tempURI = tempURI + name + "=" + value;
                        }
                        while (keyItr.hasNext()) {
                            tempURI = tempURI + "&";
                            name = keyItr.next();
                            value = paramConfig.get(name);
                            tempURI = tempURI + name + "=" + value;
                        }
                    }
                    this.locatorURI = tempURI;
                } else {
                    this.log.error("Invoker element within Configuration attribute does not contain a transport attribute.");
                }
            }
        }
        catch (Exception e) {
            this.log.error("Error configuring invoker for connector.", e);
            throw new IllegalStateException("Error configuring invoker for connector.  Can not continue without invoker.");
        }
    }

    private void configureHandlers(ClassLoader cl) throws Exception {
        if (this.xml != null) {
            NodeList handlersNodes = this.xml.getElementsByTagName("handler");
            if (!(handlersNodes != null && handlersNodes.getLength() > 0 || this.getInvocationHandlers() != null && this.getInvocationHandlers().length != 0)) {
                throw new IllegalArgumentException("required 'handler' element not found and are no registered handlers found.");
            }
            int len = handlersNodes.getLength();
            for (int c = 0; c < len; ++c) {
                Node node = handlersNodes.item(c);
                Node subNode = node.getAttributes().getNamedItem("subsystem");
                if (subNode == null) {
                    throw new IllegalArgumentException("Required 'subsystem' attribute on 'handler' element");
                }
                String handlerClass = node.getFirstChild().getNodeValue();
                boolean isObjName = false;
                ServerInvocationHandler handler = null;
                try {
                    ObjectName objName = new ObjectName(handlerClass);
                    handler = this.createHandlerProxy(objName);
                    isObjName = true;
                }
                catch (MalformedObjectNameException e) {
                    this.log.debug("Handler supplied is not an object name.");
                }
                if (!isObjName) {
                    handler = (ServerInvocationHandler)cl.loadClass(handlerClass).newInstance();
                }
                StringTokenizer tok = new StringTokenizer(subNode.getNodeValue(), ",");
                while (tok.hasMoreTokens()) {
                    String subsystem = tok.nextToken();
                    this.addInvocationHandler(subsystem, handler);
                }
            }
        }
    }

    private ServerInvocationHandler createHandlerProxy(ObjectName objName) {
        if (this.server == null) {
            throw new RuntimeException("Can not register MBean invocation handler as the Connector has not been registered with a MBeanServer.");
        }
        ServerInvocationHandler handler = (ServerInvocationHandler)MBeanServerInvocationHandler.newProxyInstance(this.server, objName, class$org$jboss$remoting$ServerInvocationHandler == null ? (class$org$jboss$remoting$ServerInvocationHandler = Connector.class$("org.jboss.remoting.ServerInvocationHandler")) : class$org$jboss$remoting$ServerInvocationHandler, false);
        return handler;
    }

    public void addConnectionListener(ConnectionListener listener) {
        if (this.invoker != null) {
            this.invoker.addConnectionListener(listener);
        }
    }

    public void removeConnectionListener(ConnectionListener listener) {
        if (this.invoker != null) {
            this.invoker.removeConnectionListener(listener);
        }
    }

    public void setLeasePeriod(long leasePeriodValue) {
        if (this.invoker != null) {
            this.invoker.setLeasePeriod(leasePeriodValue);
        }
    }

    public long getLeasePeriod() {
        if (this.invoker != null) {
            return this.invoker.getLeasePeriod();
        }
        return -1L;
    }

    public void stop() {
        if (this.isStarted) {
            if (this.invoker != null) {
                this.invoker.stop();
                this.invoker.destroy();
                InvokerRegistry.destroyServerInvoker(this.invoker);
                this.invoker = null;
            }
            if (this.marshallerLoaderConnector != null && this.marshallerLoaderConnector.isStarted) {
                this.marshallerLoaderConnector.stop();
                this.marshallerLoaderConnector = null;
            }
            this.isCreated = false;
            this.isStarted = false;
        }
    }

    public void create() throws Exception {
        if (!this.isCreated) {
            this.init();
            this.isCreated = true;
        }
    }

    public void destroy() {
    }

    public ServerInvoker getServerInvoker() {
        return this.invoker;
    }

    public ServerInvocationHandler[] getInvocationHandlers() {
        ServerInvocationHandler[] handlers = null;
        if (this.invoker != null) {
            handlers = this.invoker.getInvocationHandlers();
        }
        return handlers;
    }

    public InvokerLocator getLocator() {
        return this.invoker.getLocator();
    }

    public void setInvokerLocator(String locator) throws Exception {
        if (this.isCreated) {
            throw new RuntimeException("Can not set the invoker locator on this Connector as has already been created with a different locator.");
        }
        this.locatorURI = locator;
    }

    public String getInvokerLocator() throws Exception {
        return this.locatorURI;
    }

    public void setConfiguration(Element xml) throws Exception {
        this.xml = xml;
    }

    public Element getConfiguration() {
        return this.xml;
    }

    public ServerInvocationHandler addInvocationHandler(String subsystem, ObjectName handlerObjectName) throws Exception {
        ServerInvocationHandler invocationHandler = this.createHandlerProxy(handlerObjectName);
        return this.addInvocationHandler(subsystem, invocationHandler);
    }

    public ServerInvocationHandler addInvocationHandler(String subsystem, ServerInvocationHandler handler) throws Exception {
        if (this.invoker == null) {
            throw new IllegalStateException("You may only add handlers once the Connector is created (via create() method).");
        }
        handler.setMBeanServer(this.server);
        return this.invoker.addInvocationHandler(subsystem, handler);
    }

    public void removeInvocationHandler(String subsystem) throws Exception {
        ServerInvocationHandler handler = this.invoker.removeInvocationHandler(subsystem);
        if (handler != null) {
            handler.setMBeanServer(null);
        }
    }

    public void setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        if (this.invoker != null) {
            this.invoker.setServerSocketFactory(serverSocketFactory);
        }
    }

    public ServerSocketFactory getServerSocketFactory() {
        if (this.invoker != null) {
            return this.invoker.getServerSocketFactory();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

