/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.detection;

import java.util.Date;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.detection.multicast.MulticastDetector;
import org.jboss.remoting.network.NetworkNotification;
import org.jboss.remoting.network.NetworkRegistry;

public class SimpleDetectorClient
implements NotificationListener {
    public void setupDetector() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        NetworkRegistry registry = NetworkRegistry.getInstance();
        server.registerMBean(registry, new ObjectName("remoting:type=NetworkRegistry"));
        SimpleDetectorClient.println("NetworkRegistry has been created");
        registry.addNotificationListener(this, null, null);
        SimpleDetectorClient.println("NetworkRegistry has added the client as a listener");
        MulticastDetector detector = new MulticastDetector();
        server.registerMBean(detector, new ObjectName("remoting:type=MulticastDetector"));
        detector.start();
        SimpleDetectorClient.println("MulticastDetector has been created and is listening for new NetworkRegistries to come online");
    }

    public void handleNotification(Notification notification, Object handback) {
        block4: {
            NetworkNotification networkNotification;
            block5: {
                if (!(notification instanceof NetworkNotification)) break block4;
                SimpleDetectorClient.println("GOT A NETWORK-REGISTRY NOTIFICATION: " + notification.getType());
                networkNotification = (NetworkNotification)notification;
                if (!"jboss.network.server.added".equals(networkNotification.getType())) break block5;
                SimpleDetectorClient.println("New server(s) have been detected - getting locators and sending welcome messages");
                InvokerLocator[] locators = networkNotification.getLocator();
                for (int x = 0; x < locators.length; ++x) {
                    try {
                        InvokerLocator newServerLocator = locators[x];
                        this.makeInvocation(newServerLocator.getLocatorURI());
                        continue;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                break block4;
            }
            if (!"jboss.network.server.removed".equals(networkNotification.getType())) break block4;
            InvokerLocator[] locators = networkNotification.getLocator();
            for (int x = 0; x < locators.length; ++x) {
                SimpleDetectorClient.println("It has been detected that a server has gone down with a locator of: " + locators[x]);
            }
        }
    }

    public void makeInvocation(String locatorURI) throws Throwable {
        InvokerLocator locator = new InvokerLocator(locatorURI);
        SimpleDetectorClient.println("Sending welcome message to remoting server with locator uri of: " + locatorURI);
        Client remotingClient = new Client(locator);
        Object response = remotingClient.invoke("Welcome Aboard!", null);
        SimpleDetectorClient.println("The newly discovered server sent this response to our welcome message: " + response);
    }

    public static void main(String[] args) {
        SimpleDetectorClient.println("Starting JBoss/Remoting client... to stop this client, kill it manually via Control-C");
        SimpleDetectorClient client = new SimpleDetectorClient();
        try {
            client.setupDetector();
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            SimpleDetectorClient.println("Stopping JBoss/Remoting client");
            return;
        }
    }

    public static void println(String msg) {
        System.out.println(new Date() + ": [CLIENT]: " + msg);
    }
}

