/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.reflect.plugins.javassist.JavassistAnnotatedInfo;
import org.jboss.reflect.plugins.javassist.JavassistMethod;
import org.jboss.reflect.plugins.javassist.JavassistParameterInfo;
import org.jboss.reflect.plugins.javassist.JavassistReflectionFactory;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.plugins.javassist.SignatureKey;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.ParameterInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class JavassistMethodInfo
extends JavassistAnnotatedInfo
implements MethodInfo {
    private static final JavassistReflectionFactory reflectionFactory = new JavassistReflectionFactory(true);
    private JavassistTypeInfo typeInfo;
    private SignatureKey key;
    private CtMethod ctMethod;
    private transient JavassistMethod method;
    private transient TypeInfo returnType;
    private transient ParameterInfo[] parameters;
    private transient TypeInfo[] parameterTypes;
    private transient ClassInfo[] exceptionTypes;

    public JavassistMethodInfo(JavassistTypeInfo typeInfo, SignatureKey key, CtMethod ctMethod) {
        this.typeInfo = typeInfo;
        this.key = key;
        this.ctMethod = ctMethod;
    }

    public String getName() {
        return this.key.name;
    }

    public ClassInfo getDeclaringClass() {
        return this.typeInfo;
    }

    public int getModifiers() {
        return this.ctMethod.getModifiers();
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public ClassInfo[] getExceptionTypes() {
        if (this.exceptionTypes == null) {
            try {
                CtClass[] types = this.ctMethod.getExceptionTypes();
                this.exceptionTypes = new ClassInfo[types.length];
                for (int i = 0; i < types.length; ++i) {
                    this.exceptionTypes[i] = (ClassInfo)this.typeInfo.getFactory().getTypeInfo(types[i]);
                }
            }
            catch (NotFoundException e) {
                throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for exception types of method " + this.getName(), e);
            }
        }
        return this.exceptionTypes;
    }

    public TypeInfo getReturnType() {
        if (this.returnType != null) {
            return this.returnType;
        }
        try {
            CtClass clazz = this.ctMethod.getReturnType();
            this.returnType = this.typeInfo.getFactory().getTypeInfo(clazz);
            return this.returnType;
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for return type of method " + this.getName(), e);
        }
    }

    public ParameterInfo[] getParameters() {
        if (this.parameters == null) {
            this.generateParameters();
        }
        return this.parameters;
    }

    public TypeInfo[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.generateParameters();
        }
        return this.parameterTypes;
    }

    public Object invoke(Object target, Object[] args) throws Throwable {
        if (this.method == null) {
            this.method = reflectionFactory.createMethod(this.ctMethod);
        }
        return this.method.invoke(target, args);
    }

    protected int getHashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MethodInfo)) {
            return false;
        }
        MethodInfo other = (MethodInfo)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getDeclaringClass().equals(other.getDeclaringClass())) {
            return false;
        }
        if (!this.getReturnType().equals(other.getReturnType())) {
            return false;
        }
        return Arrays.equals(this.getParameterTypes(), other.getParameterTypes());
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getName());
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.getName());
        super.toString(buffer);
    }

    protected void generateParameters() {
        try {
            int i;
            CtClass[] types = this.ctMethod.getParameterTypes();
            this.parameterTypes = new TypeInfo[types.length];
            for (i = 0; i < types.length; ++i) {
                this.parameterTypes[i] = this.typeInfo.getFactory().getTypeInfo(types[i]);
            }
            this.parameters = new ParameterInfo[types.length];
            for (i = 0; i < types.length; ++i) {
                this.parameters[i] = new JavassistParameterInfo(this, "arg" + i, this.parameterTypes[i]);
            }
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for parameters of " + this.getName(), e);
        }
    }
}

