/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import org.jboss.reflect.plugins.javassist.JavassistAnnotatedInfo;
import org.jboss.reflect.plugins.javassist.JavassistConstructor;
import org.jboss.reflect.plugins.javassist.JavassistParameterInfo;
import org.jboss.reflect.plugins.javassist.JavassistReflectionFactory;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.ParameterInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class JavassistConstructorInfo
extends JavassistAnnotatedInfo
implements ConstructorInfo {
    private static final JavassistReflectionFactory reflectionFactory = new JavassistReflectionFactory(true);
    private JavassistTypeInfo typeInfo;
    private CtConstructor ctConstructor;
    private transient JavassistConstructor constructor;
    private transient ParameterInfo[] parameters;
    private transient TypeInfo[] parameterTypes;
    private transient ClassInfo[] exceptionTypes;

    public JavassistConstructorInfo(JavassistTypeInfo typeInfo, CtConstructor ctConstructor) {
        this.typeInfo = typeInfo;
        this.ctConstructor = ctConstructor;
    }

    public int getModifiers() {
        return this.ctConstructor.getModifiers();
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public ClassInfo getDeclaringClass() {
        return this.typeInfo;
    }

    public ClassInfo[] getExceptionTypes() {
        if (this.exceptionTypes == null) {
            try {
                CtClass[] types = this.ctConstructor.getExceptionTypes();
                this.exceptionTypes = new ClassInfo[types.length];
                for (int i = 0; i < types.length; ++i) {
                    this.exceptionTypes[i] = (ClassInfo)this.typeInfo.getFactory().getTypeInfo(types[i]);
                }
            }
            catch (NotFoundException e) {
                throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for exception types of constructor", e);
            }
        }
        return this.exceptionTypes;
    }

    public ParameterInfo[] getParameters() {
        if (this.parameters == null) {
            this.generateParameters();
        }
        return this.parameters;
    }

    public TypeInfo[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.generateParameters();
        }
        return this.parameterTypes;
    }

    public Object newInstance(Object[] args) throws Throwable {
        if (this.constructor == null) {
            this.constructor = reflectionFactory.createConstructor(this.ctConstructor);
        }
        return this.constructor.newInstance(args);
    }

    protected int getHashCode() {
        int result = this.getDeclaringClass().hashCode();
        this.generateParameters();
        if (this.parameterTypes != null) {
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                result = 29 * result + this.parameterTypes[i].hashCode();
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ConstructorInfo)) {
            return false;
        }
        ConstructorInfo other = (ConstructorInfo)obj;
        if (!this.getDeclaringClass().equals(other.getDeclaringClass())) {
            return false;
        }
        return Arrays.equals(this.getParameterTypes(), other.getParameterTypes());
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append(Arrays.asList(this.getParameterTypes()));
        super.toString(buffer);
    }

    protected void generateParameters() {
        try {
            int i;
            CtClass[] types = this.ctConstructor.getParameterTypes();
            this.parameterTypes = new TypeInfo[types.length];
            for (i = 0; i < types.length; ++i) {
                this.parameterTypes[i] = this.typeInfo.getFactory().getTypeInfo(types[i]);
            }
            this.parameters = new ParameterInfo[types.length];
            for (i = 0; i < types.length; ++i) {
                this.parameters[i] = new JavassistParameterInfo(this, "arg" + i, this.parameterTypes[i]);
            }
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for parameters of constructor", e);
        }
    }
}

