/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.spi.AnnotatedInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.util.JBossObject;

public abstract class InheritableAnnotationHolder
extends JBossObject
implements AnnotatedInfo,
Serializable {
    private static final long serialVersionUID = 3257290210164289843L;
    static final Map UNKNOWN_ANNOTATIONS_MAP = Collections.unmodifiableMap(new HashMap());
    static final AnnotationValue[] UNKNOWN_ANNOTATIONS = new AnnotationValue[0];
    protected Map declaredAnnotations = UNKNOWN_ANNOTATIONS_MAP;
    protected Map allAnnotations = UNKNOWN_ANNOTATIONS_MAP;
    protected AnnotationValue[] allAnnotationsArray = UNKNOWN_ANNOTATIONS;
    protected AnnotationValue[] declaredAnnotationsArray = UNKNOWN_ANNOTATIONS;
    protected Object annotatedElement;
    protected AnnotationHelper annotationHelper;

    public void setAnnotationHelper(AnnotationHelper helper) {
        this.annotationHelper = helper;
    }

    public void setAnnotatedElement(Object annotatedElement) {
        this.annotatedElement = annotatedElement;
    }

    public AnnotationValue[] getDeclaredAnnotations() {
        if (this.declaredAnnotationsArray == UNKNOWN_ANNOTATIONS) {
            this.setupAnnotations(this.annotationHelper.getAnnotations(this.annotatedElement));
        }
        return this.declaredAnnotationsArray;
    }

    public AnnotationValue[] getAnnotations() {
        if (this.allAnnotationsArray == UNKNOWN_ANNOTATIONS) {
            this.setupAnnotations(this.annotationHelper.getAnnotations(this.annotatedElement));
        }
        return this.allAnnotationsArray;
    }

    public AnnotationValue getAnnotation(String name) {
        if (this.allAnnotations == UNKNOWN_ANNOTATIONS_MAP) {
            this.setupAnnotations(this.annotationHelper.getAnnotations(this.annotatedElement));
        }
        return (AnnotationValue)this.allAnnotations.get(name);
    }

    public boolean isAnnotationPresent(String name) {
        if (this.allAnnotations == UNKNOWN_ANNOTATIONS_MAP) {
            this.setupAnnotations(this.annotationHelper.getAnnotations(this.annotatedElement));
        }
        return this.allAnnotations.containsKey(name);
    }

    public void setupAnnotations(AnnotationValue[] annotations) {
        InheritableAnnotationHolder superHolder = this.getSuperHolder();
        if (superHolder == null) {
            return;
        }
        AnnotationValue[] superAllAnnotations = superHolder.getAnnotations();
        if (annotations != null && annotations.length > 0) {
            int i;
            this.declaredAnnotations = new HashMap();
            this.declaredAnnotationsArray = annotations;
            for (i = 0; i < annotations.length; ++i) {
                this.declaredAnnotations.put(annotations[i].getAnnotationType().getName(), annotations[i]);
            }
            this.allAnnotations = new HashMap();
            if (superHolder != null && superAllAnnotations != null && superAllAnnotations.length != 0) {
                for (i = 0; i < superAllAnnotations.length; ++i) {
                    AnnotationValue av = superAllAnnotations[i];
                    if (av.getAnnotationType().isAnnotationPresent("java.lang.annotation.Inherited")) {
                        // empty if block
                    }
                    this.allAnnotations.put(av.getAnnotationType().getName(), av);
                }
            } else {
                this.allAnnotationsArray = this.declaredAnnotationsArray;
            }
            for (i = 0; i < annotations.length; ++i) {
                this.allAnnotations.put(annotations[i].getAnnotationType().getName(), annotations[i]);
            }
            this.allAnnotationsArray = this.allAnnotations.values().toArray(new AnnotationValue[this.allAnnotations.size()]);
        } else if (superHolder != null) {
            this.allAnnotations = superHolder.getAllAnnotations();
            this.allAnnotationsArray = superAllAnnotations;
        }
    }

    protected Map getAllAnnotations() {
        if (this.allAnnotations == UNKNOWN_ANNOTATIONS_MAP) {
            this.setupAnnotations(this.annotationHelper.getAnnotations(this.annotatedElement));
        }
        return this.allAnnotations;
    }

    protected abstract InheritableAnnotationHolder getSuperHolder();
}

