/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.transaction.xa.Xid;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyQueue;
import org.jboss.mq.SpyTemporaryQueue;
import org.jboss.mq.SpyTemporaryTopic;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.SpyTransactionRolledBackException;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.pm.PersistenceManager;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.TxManager;
import org.jboss.mq.server.BasicQueueParameters;
import org.jboss.mq.server.ClientConsumer;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.JMSQueue;
import org.jboss.mq.server.JMSServerInterceptorSupport;
import org.jboss.mq.server.JMSTopic;
import org.jboss.mq.server.MessageCache;
import org.jboss.mq.server.MessageCounter;
import org.jboss.mq.sm.StateManager;
import org.jboss.util.threadpool.ThreadPool;
import org.jboss.util.timeout.TimeoutFactory;

public class JMSDestinationManager
extends JMSServerInterceptorSupport {
    public static final String JBOSS_VERSION = "JBossMQ Version 4.0";
    public Map destinations = new ConcurrentReaderHashMap();
    public Map closingDestinations = new ConcurrentReaderHashMap();
    public ThreadPool threadPool;
    public ThreadGroup threadGroup;
    public TimeoutFactory timeoutFactory;
    Map clientConsumers = new ConcurrentReaderHashMap();
    private int lastID = 1;
    private int lastTemporaryTopic = 1;
    private Object lastTemporaryTopicLock = new Object();
    private int lastTemporaryQueue = 1;
    private Object lastTemporaryQueueLock = new Object();
    private StateManager stateManager;
    private PersistenceManager persistenceManager;
    private MessageCache messageCache;
    private Object stateLock = new Object();
    private Object idLock = new Object();
    private boolean stopped = true;
    BasicQueueParameters parameters;

    public JMSDestinationManager(BasicQueueParameters parameters) {
        this.parameters = parameters;
    }

    public void setEnabled(ConnectionToken dc, boolean enabled) throws JMSException {
        ClientConsumer ClientConsumer2 = this.getClientConsumer(dc);
        ClientConsumer2.setEnabled(enabled);
    }

    public void setStateManager(StateManager newStateManager) {
        this.stateManager = newStateManager;
    }

    public void setPersistenceManager(PersistenceManager newPersistenceManager) {
        this.persistenceManager = newPersistenceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopped() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.stopped;
        }
    }

    protected void checkStopped() throws IllegalStateException {
        if (this.isStopped()) {
            throw new IllegalStateException("Server is stopped.");
        }
    }

    public int getClientCount() {
        return this.clientConsumers.size();
    }

    public HashMap getClients() {
        return new HashMap(this.clientConsumers);
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadGroup(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public TimeoutFactory getTimeoutFactory() {
        return this.timeoutFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getID() {
        String ID2 = null;
        while (!this.isStopped()) {
            if (this.stateManager == null) {
                throw new IllegalStateException("No statemanager");
            }
            try {
                Object object = this.idLock;
                synchronized (object) {
                    ID2 = "ID:" + new Integer(this.lastID++).toString();
                }
                this.stateManager.addLoggedOnClientId(ID2);
                break;
            }
            catch (Exception exception) {
            }
        }
        this.checkStopped();
        return ID2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryTopic getTemporaryTopic(ConnectionToken dc) throws JMSException {
        String topicName;
        this.checkStopped();
        Object object = this.lastTemporaryTopicLock;
        synchronized (object) {
            topicName = "JMS_TT" + new Integer(this.lastTemporaryTopic++).toString();
        }
        SpyTemporaryTopic topic = new SpyTemporaryTopic(topicName, dc);
        ClientConsumer ClientConsumer2 = this.getClientConsumer(dc);
        JMSTopic queue = new JMSTopic(topic, ClientConsumer2, this, this.parameters);
        this.destinations.put(topic, queue);
        return topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryQueue getTemporaryQueue(ConnectionToken dc) throws JMSException {
        String queueName;
        this.checkStopped();
        Object object = this.lastTemporaryQueueLock;
        synchronized (object) {
            queueName = "JMS_TQ" + new Integer(this.lastTemporaryQueue++).toString();
        }
        SpyTemporaryQueue newQueue = new SpyTemporaryQueue(queueName, dc);
        ClientConsumer ClientConsumer2 = this.getClientConsumer(dc);
        JMSQueue queue = new JMSQueue(newQueue, ClientConsumer2, this, this.parameters);
        this.destinations.put(newQueue, queue);
        return newQueue;
    }

    public ClientConsumer getClientConsumer(ConnectionToken dc) throws JMSException {
        ClientConsumer cq = (ClientConsumer)this.clientConsumers.get(dc);
        if (cq == null) {
            cq = new ClientConsumer(this, dc);
            this.clientConsumers.put(dc, cq);
        }
        return cq;
    }

    public JMSDestination getJMSDestination(SpyDestination dest) {
        return (JMSDestination)this.destinations.get(dest);
    }

    protected JMSDestination getPossiblyClosingJMSDestination(SpyDestination dest) {
        JMSDestination result = (JMSDestination)this.destinations.get(dest);
        if (result == null) {
            result = (JMSDestination)this.closingDestinations.get(dest);
        }
        return result;
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer() {
        Object object = this.stateLock;
        synchronized (object) {
            this.stopped = false;
            this.timeoutFactory = new TimeoutFactory(this.threadPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        Object object = this.stateLock;
        synchronized (object) {
            this.stopped = true;
            this.timeoutFactory.cancel();
            Iterator i = this.clientConsumers.keySet().iterator();
            while (i.hasNext()) {
                ConnectionToken token = (ConnectionToken)i.next();
                try {
                    this.connectionClosing(token);
                }
                catch (Throwable t) {
                    this.log.trace("Ignored error closing client connection " + token, t);
                }
            }
        }
    }

    public void checkID(String ID2) throws JMSException {
        this.checkStopped();
        this.stateManager.addLoggedOnClientId(ID2);
    }

    public void addMessage(ConnectionToken dc, SpyMessage val) throws JMSException {
        this.addMessage(dc, val, null);
    }

    public void addMessage(ConnectionToken dc, SpyMessage val, Tx txId) throws JMSException {
        this.checkStopped();
        JMSDestination queue = (JMSDestination)this.destinations.get(val.getJMSDestination());
        if (queue == null) {
            throw new InvalidDestinationException("This destination does not exist! " + val.getJMSDestination());
        }
        val.setJMSRedelivered(false);
        val.header.jmsProperties.remove("JMS_JBOSS_REDELIVERY_COUNT");
        val.setReadOnlyMode();
        queue.addMessage(val, txId);
    }

    public void transact(ConnectionToken dc, TransactionRequest t) throws JMSException {
        this.checkStopped();
        boolean trace = this.log.isTraceEnabled();
        TxManager txManager = this.persistenceManager.getTxManager();
        if (t.requestType == 0) {
            Tx txId = txManager.createTx();
            if (trace) {
                this.log.trace(dc + " 1PC " + t.xid + " txId=" + txId.longValue());
            }
            try {
                int i;
                if (t.messages != null) {
                    for (i = 0; i < t.messages.length; ++i) {
                        this.addMessage(dc, t.messages[i], txId);
                    }
                }
                if (t.acks != null) {
                    for (i = 0; i < t.acks.length; ++i) {
                        this.acknowledge(dc, t.acks[i], txId);
                    }
                }
                txManager.commitTx(txId);
            }
            catch (JMSException e) {
                this.log.debug("Exception occured, rolling back transaction: ", e);
                txManager.rollbackTx(txId);
                throw new SpyTransactionRolledBackException("Transaction was rolled back.", e);
            }
        } else if (t.requestType == 1) {
            Tx txId = txManager.createTx(dc, t.xid);
            if (trace) {
                this.log.trace(dc + " 2PC PREPARE " + t.xid + " txId=" + txId.longValue());
            }
            try {
                int i;
                if (t.messages != null) {
                    for (i = 0; i < t.messages.length; ++i) {
                        this.addMessage(dc, t.messages[i], txId);
                    }
                }
                if (t.acks != null) {
                    for (i = 0; i < t.acks.length; ++i) {
                        this.acknowledge(dc, t.acks[i], txId);
                    }
                }
                txManager.markPrepared(dc, t.xid, txId);
            }
            catch (JMSException e) {
                this.log.debug("Exception occured, rolling back transaction: ", e);
                txManager.rollbackTx(txId);
                throw new SpyTransactionRolledBackException("Transaction was rolled back.", e);
            }
        } else if (t.requestType == 3) {
            if (trace) {
                this.log.trace(dc + " 2PC ROLLBACK " + t.xid);
            }
            txManager.rollbackTx(dc, t.xid);
        } else if (t.requestType == 2) {
            if (trace) {
                this.log.trace(dc + " 2PC COMMIT " + t.xid);
            }
            txManager.commitTx(dc, t.xid);
        }
    }

    public Xid[] recover(ConnectionToken dc, int flags) throws Exception {
        this.checkStopped();
        TxManager txManager = this.persistenceManager.getTxManager();
        return txManager.recover(dc, flags);
    }

    public void acknowledge(ConnectionToken dc, AcknowledgementRequest item) throws JMSException {
        this.acknowledge(dc, item, null);
    }

    public void acknowledge(ConnectionToken dc, AcknowledgementRequest item, Tx txId) throws JMSException {
        this.checkStopped();
        ClientConsumer cc = this.getClientConsumer(dc);
        cc.acknowledge(item, txId);
    }

    public void connectionClosing(ConnectionToken dc) throws JMSException {
        if (dc == null) {
            return;
        }
        ClientConsumer cq = (ClientConsumer)this.clientConsumers.remove(dc);
        if (cq != null) {
            cq.close();
        }
        if (dc.getClientID() != null) {
            this.stateManager.removeLoggedOnClientId(dc.getClientID());
        }
        Iterator i = this.destinations.entrySet().iterator();
        while (i.hasNext()) {
            ClientConsumer cc;
            Map.Entry entry = i.next();
            JMSDestination sq = (JMSDestination)entry.getValue();
            if (sq == null || (cc = sq.temporaryDestination) == null || !dc.equals(cc.connectionToken)) continue;
            i.remove();
            this.deleteTemporaryDestination(dc, sq);
        }
        try {
            if (dc.clientIL != null) {
                dc.clientIL.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void connectionFailure(ConnectionToken dc) throws JMSException {
        this.log.error("The connection to client " + dc.getClientID() + " failed.");
        this.connectionClosing(dc);
    }

    public void subscribe(ConnectionToken dc, Subscription sub) throws JMSException {
        this.checkStopped();
        ClientConsumer clientConsumer = this.getClientConsumer(dc);
        clientConsumer.addSubscription(sub);
    }

    public void unsubscribe(ConnectionToken dc, int subscriptionId) throws JMSException {
        this.checkStopped();
        ClientConsumer clientConsumer = this.getClientConsumer(dc);
        clientConsumer.removeSubscription(subscriptionId);
    }

    public void destroySubscription(ConnectionToken dc, DurableSubscriptionID id) throws JMSException {
        this.checkStopped();
        this.getStateManager().setDurableSubscription(this, id, null);
    }

    public SpyMessage[] browse(ConnectionToken dc, Destination dest, String selector) throws JMSException {
        this.checkStopped();
        JMSDestination queue = (JMSDestination)this.destinations.get(dest);
        if (queue == null) {
            throw new InvalidDestinationException("That destination does not exist! " + dest);
        }
        if (!(queue instanceof JMSQueue)) {
            throw new JMSException("That destination is not a queue");
        }
        return ((JMSQueue)queue).browse(selector);
    }

    public SpyMessage receive(ConnectionToken dc, int subscriberId, long wait) throws JMSException {
        this.checkStopped();
        ClientConsumer clientConsumer = this.getClientConsumer(dc);
        SpyMessage msg = clientConsumer.receive(subscriberId, wait);
        return msg;
    }

    public Queue createQueue(ConnectionToken dc, String name) throws JMSException {
        this.checkStopped();
        SpyQueue newQueue = new SpyQueue(name);
        if (!this.destinations.containsKey(newQueue)) {
            throw new JMSException("This destination does not exist !" + newQueue);
        }
        return newQueue;
    }

    public Topic createTopic(ConnectionToken dc, String name) throws JMSException {
        this.checkStopped();
        SpyTopic newTopic = new SpyTopic(name);
        if (!this.destinations.containsKey(newTopic)) {
            throw new JMSException("This destination does not exist !" + newTopic);
        }
        return newTopic;
    }

    public void deleteTemporaryDestination(ConnectionToken dc, SpyDestination dest) throws JMSException {
        this.checkStopped();
        JMSDestination destination = (JMSDestination)this.destinations.get(dest);
        if (destination == null) {
            throw new InvalidDestinationException("That destination does not exist! " + destination);
        }
        if (destination.isInUse()) {
            throw new JMSException("Cannot delete temporary queue, it is in use.");
        }
        this.destinations.remove(dest);
        this.deleteTemporaryDestination(dc, destination);
    }

    protected void deleteTemporaryDestination(ConnectionToken dc, JMSDestination destination) throws JMSException {
        try {
            destination.removeAllMessages();
        }
        catch (Exception e) {
            this.log.error("An exception happened while removing all messages from temporary destination " + destination.getSpyDestination().getName(), e);
        }
    }

    public String checkUser(String userName, String password) throws JMSException {
        this.checkStopped();
        return this.stateManager.checkUser(userName, password);
    }

    public String authenticate(String id, String password) throws JMSException {
        this.checkStopped();
        return null;
    }

    public void addDestination(JMSDestination destination) throws JMSException {
        if (this.destinations.containsKey(destination.getSpyDestination())) {
            throw new JMSException("This destination has already been added to the server!");
        }
        this.destinations.put(destination.getSpyDestination(), destination);
        if (destination instanceof JMSTopic) {
            Collection durableSubs = this.getStateManager().getDurableSubscriptionIdsForTopic((SpyTopic)destination.getSpyDestination());
            Iterator i = durableSubs.iterator();
            while (i.hasNext()) {
                DurableSubscriptionID sub = (DurableSubscriptionID)i.next();
                this.log.debug("creating the durable subscription for :" + sub);
                ((JMSTopic)destination).createDurableSubscription(sub);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDestination(SpyDestination dest) throws JMSException {
        JMSDestination destination = (JMSDestination)this.destinations.remove(dest);
        if (destination == null) {
            throw new InvalidDestinationException("This destination is not open! " + dest);
        }
        this.log.debug("Closing destination " + dest);
        this.closingDestinations.put(dest, destination);
        try {
            destination.close();
        }
        finally {
            this.closingDestinations.remove(dest);
        }
    }

    public String toString() {
        return JBOSS_VERSION;
    }

    public void ping(ConnectionToken dc, long clientTime) throws JMSException {
        this.checkStopped();
        try {
            dc.clientIL.pong(System.currentTimeMillis());
        }
        catch (Exception e) {
            throw new SpyJMSException("Could not pong", e);
        }
    }

    public MessageCache getMessageCache() {
        return this.messageCache;
    }

    public void setMessageCache(MessageCache messageCache) {
        this.messageCache = messageCache;
    }

    public SpyTopic getDurableTopic(DurableSubscriptionID sub) throws JMSException {
        this.checkStopped();
        return this.getStateManager().getDurableTopic(sub);
    }

    public Subscription getSubscription(ConnectionToken dc, int subscriberId) throws JMSException {
        this.checkStopped();
        ClientConsumer clientConsumer = this.getClientConsumer(dc);
        return clientConsumer.getSubscription(subscriberId);
    }

    public MessageCounter[] getMessageCounter() {
        TreeMap<String, MessageCounter> map = new TreeMap<String, MessageCounter>();
        Iterator i = this.destinations.values().iterator();
        while (i.hasNext()) {
            JMSDestination dest = (JMSDestination)i.next();
            MessageCounter[] counter = dest.getMessageCounter();
            for (int j = 0; j < counter.length; ++j) {
                String key = counter[j].getDestinationName() + "-" + counter[j].getDestinationSubscription() + "-" + (counter[j].getDestinationTopic() ? "Topic" : "Queue");
                map.put(key, counter[j]);
            }
        }
        return map.values().toArray(new MessageCounter[0]);
    }

    public void resetMessageCounter() {
        Iterator i = this.destinations.values().iterator();
        while (i.hasNext()) {
            JMSDestination dest = (JMSDestination)i.next();
            MessageCounter[] counter = dest.getMessageCounter();
            for (int j = 0; j < counter.length; ++j) {
                counter[j].resetCounter();
            }
        }
    }

    public BasicQueueParameters getParameters() {
        return this.parameters;
    }
}

