/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.AssemblyDescriptorMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.ConfigurationMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.InvokerProxyBindingMetaData;
import org.jboss.metadata.MessageDestinationMetaData;
import org.jboss.metadata.MessageDrivenMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.MethodMetaData;
import org.jboss.metadata.RelationMetaData;
import org.jboss.metadata.SecurityRoleMetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.mx.util.MBeanServerLocator;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class ApplicationMetaData
extends MetaData {
    public static final int EJB_1x = 1;
    public static final int EJB_2x = 2;
    private URL url;
    protected int ejbVersion;
    protected int ejbMinorVersion;
    private ArrayList beans = new ArrayList();
    private HashMap wsdlPublishLocationMap = new HashMap();
    private boolean webServiceDeployment;
    private String configName;
    private String configFile;
    private ArrayList relationships = new ArrayList();
    private AssemblyDescriptorMetaData assemblyDescriptor = new AssemblyDescriptorMetaData();
    private HashMap configurations = new HashMap();
    private HashMap invokerBindings = new HashMap();
    private HashMap resources = new HashMap();
    private HashMap plugins = new HashMap();
    private String jmxName;
    private String securityDomain;
    private String unauthenticatedPrincipal;
    private String webServiceContextRoot;
    private boolean enforceEjbRestrictions;
    private boolean excludeMissingMethods = true;
    private boolean exceptionRollback = false;
    private URLClassLoader resourceCl;

    public URLClassLoader getResourceCl() {
        return this.resourceCl;
    }

    public void setResourceClassLoader(URLClassLoader resourceCl) {
        this.resourceCl = resourceCl;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL u) {
        this.url = u;
    }

    public boolean isEJB1x() {
        return this.ejbVersion == 1;
    }

    public boolean isEJB2x() {
        return this.ejbVersion == 2;
    }

    public boolean isEJB21() {
        return this.ejbVersion == 2 && this.ejbMinorVersion == 1;
    }

    public Iterator getEnterpriseBeans() {
        return this.beans.iterator();
    }

    public BeanMetaData getBeanByEjbName(String ejbName) {
        Iterator iterator = this.getEnterpriseBeans();
        while (iterator.hasNext()) {
            BeanMetaData current = (BeanMetaData)iterator.next();
            if (!current.getEjbName().equals(ejbName)) continue;
            return current;
        }
        return null;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public HashMap getWsdlPublishLocations() {
        return this.wsdlPublishLocationMap;
    }

    public String getWsdlPublishLocationByName(String name) {
        return (String)this.wsdlPublishLocationMap.get(name);
    }

    public String getWebServiceContextRoot() {
        return this.webServiceContextRoot;
    }

    public void setWebServiceContextRoot(String webServiceContextRoot) {
        this.webServiceContextRoot = webServiceContextRoot;
    }

    public boolean isWebServiceDeployment() {
        return this.webServiceDeployment;
    }

    public void setWebServiceDeployment(boolean webServiceDeployment) {
        this.webServiceDeployment = webServiceDeployment;
    }

    public Iterator getRelationships() {
        return this.relationships.iterator();
    }

    public AssemblyDescriptorMetaData getAssemblyDescriptor() {
        return this.assemblyDescriptor;
    }

    public Iterator getConfigurations() {
        return this.configurations.values().iterator();
    }

    public ConfigurationMetaData getConfigurationMetaDataByName(String name) {
        return (ConfigurationMetaData)this.configurations.get(name);
    }

    public Iterator getInvokerProxyBindings() {
        return this.invokerBindings.values().iterator();
    }

    public InvokerProxyBindingMetaData getInvokerProxyBindingMetaDataByName(String name) {
        return (InvokerProxyBindingMetaData)this.invokerBindings.get(name);
    }

    public String getResourceByName(String name) {
        return (String)this.resources.get(name);
    }

    public void addPluginData(String pluginName, Object pluginData) {
        this.plugins.put(pluginName, pluginData);
    }

    public Object getPluginData(String pluginName) {
        return this.plugins.get(pluginName);
    }

    public String getJmxName() {
        return this.jmxName;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public String getUnauthenticatedPrincipal() {
        return this.unauthenticatedPrincipal;
    }

    public void setUnauthenticatedPrincipal(String unauthenticatedPrincipal) {
        this.unauthenticatedPrincipal = unauthenticatedPrincipal;
    }

    public boolean getEnforceEjbRestrictions() {
        return this.enforceEjbRestrictions;
    }

    public boolean isExcludeMissingMethods() {
        return this.excludeMissingMethods;
    }

    public MessageDestinationMetaData getMessageDestination(String name) {
        return this.assemblyDescriptor.getMessageDestinationMetaData(name);
    }

    public boolean getExceptionRollback() {
        return this.exceptionRollback;
    }

    public void addBeanMetaData(BeanMetaData metaData) {
        this.beans.add(metaData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importEjbJarXml(Element element) throws DeploymentException {
        Element descrElement;
        DocumentType docType = element.getOwnerDocument().getDoctype();
        if (docType == null) {
            if (!"http://java.sun.com/xml/ns/j2ee".equals(element.getNamespaceURI())) throw new DeploymentException("ejb-jar.xml must either obey the right xml schema or define a valid DOCTYPE!");
            this.ejbVersion = 2;
            this.ejbMinorVersion = 1;
        } else {
            String publicId = docType.getPublicId();
            if (publicId == null) {
                throw new DeploymentException("The DOCTYPE declaration in ejb-jar.xml must define a PUBLIC id");
            }
            if (publicId.startsWith("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0")) {
                this.ejbVersion = 2;
            } else {
                if (!publicId.startsWith("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1")) throw new DeploymentException("Unknown PUBLIC id in ejb-jar.xml: " + publicId);
                this.ejbVersion = 1;
            }
        }
        Element enterpriseBeans = ApplicationMetaData.getUniqueChild(element, "enterprise-beans");
        HashMap<String, EntityMetaData> schemaNameMap = new HashMap<String, EntityMetaData>();
        Iterator iterator = ApplicationMetaData.getChildrenByTagName(enterpriseBeans, "entity");
        while (iterator.hasNext()) {
            Element currentEntity = (Element)iterator.next();
            EntityMetaData entityMetaData = new EntityMetaData(this);
            try {
                entityMetaData.importEjbJarXml(currentEntity);
            }
            catch (DeploymentException e) {
                throw new DeploymentException("Error in ejb-jar.xml for Entity Bean " + entityMetaData.getEjbName() + ": " + e.getMessage());
            }
            String abstractSchemaName = entityMetaData.getAbstractSchemaName();
            if (abstractSchemaName != null) {
                if (schemaNameMap.containsKey(abstractSchemaName)) {
                    throw new DeploymentException(entityMetaData.getEjbName() + ": Duplicate abstract-schema name '" + abstractSchemaName + "'. Already defined for Entity '" + ((EntityMetaData)schemaNameMap.get(abstractSchemaName)).getEjbName() + "'.");
                }
                schemaNameMap.put(abstractSchemaName, entityMetaData);
            }
            this.beans.add(entityMetaData);
        }
        iterator = ApplicationMetaData.getChildrenByTagName(enterpriseBeans, "session");
        while (iterator.hasNext()) {
            Element currentSession = (Element)iterator.next();
            SessionMetaData sessionMetaData = new SessionMetaData(this);
            try {
                sessionMetaData.importEjbJarXml(currentSession);
            }
            catch (DeploymentException e) {
                throw new DeploymentException("Error in ejb-jar.xml for Session Bean " + sessionMetaData.getEjbName() + ": " + e.getMessage());
            }
            this.beans.add(sessionMetaData);
        }
        iterator = ApplicationMetaData.getChildrenByTagName(enterpriseBeans, "message-driven");
        while (iterator.hasNext()) {
            Element currentMessageDriven = (Element)iterator.next();
            MessageDrivenMetaData messageDrivenMetaData = new MessageDrivenMetaData(this);
            try {
                messageDrivenMetaData.importEjbJarXml(currentMessageDriven);
            }
            catch (DeploymentException e) {
                throw new DeploymentException("Error in ejb-jar.xml for Message Driven Bean " + messageDrivenMetaData.getEjbName() + ": " + e.getMessage());
            }
            this.beans.add(messageDrivenMetaData);
        }
        HashSet<String> ejbNames = new HashSet<String>();
        for (BeanMetaData bmd : this.beans) {
            String beanName = bmd.getEjbName();
            if (ejbNames.contains(beanName)) {
                throw new DeploymentException("Duplicate definition of an EJB with name '" + beanName + "'.");
            }
            ejbNames.add(beanName);
        }
        Element relationshipsElement = ApplicationMetaData.getOptionalChild(element, "relationships");
        if (relationshipsElement != null) {
            HashSet<String> relationNames = new HashSet<String>();
            iterator = ApplicationMetaData.getChildrenByTagName(relationshipsElement, "ejb-relation");
            while (iterator.hasNext()) {
                Element relationElement = (Element)iterator.next();
                RelationMetaData relationMetaData = new RelationMetaData();
                try {
                    relationMetaData.importEjbJarXml(relationElement);
                }
                catch (DeploymentException e) {
                    throw new DeploymentException("Error in ejb-jar.xml for relation " + relationMetaData.getRelationName() + ": " + e.getMessage());
                }
                String relationName = relationMetaData.getRelationName();
                if (relationName != null) {
                    if (relationNames.contains(relationName)) {
                        throw new DeploymentException("ejb-relation-name must be unique in ejb-jar.xml file: ejb-relation-name is " + relationName);
                    }
                    relationNames.add(relationName);
                }
                this.relationships.add(relationMetaData);
            }
        }
        if ((descrElement = ApplicationMetaData.getOptionalChild(element, "assembly-descriptor")) == null) return;
        iterator = ApplicationMetaData.getChildrenByTagName(descrElement, "security-role");
        while (iterator.hasNext()) {
            Element securityRole = (Element)iterator.next();
            try {
                String roleName = ApplicationMetaData.getElementContent(ApplicationMetaData.getUniqueChild(securityRole, "role-name"));
                SecurityRoleMetaData srMetaData = new SecurityRoleMetaData(roleName);
                this.assemblyDescriptor.addSecurityRoleMetaData(srMetaData);
            }
            catch (DeploymentException e) {
                throw new DeploymentException("Error in ejb-jar.xml for security-role: " + e.getMessage());
            }
        }
        iterator = ApplicationMetaData.getChildrenByTagName(descrElement, "method-permission");
        try {
            while (iterator.hasNext()) {
                Element methodPermission = (Element)iterator.next();
                Element unchecked = ApplicationMetaData.getOptionalChild(methodPermission, "unchecked");
                boolean isUnchecked = false;
                HashSet<String> roles = null;
                if (unchecked != null) {
                    isUnchecked = true;
                } else {
                    roles = new HashSet<String>();
                    Iterator rolesIterator = ApplicationMetaData.getChildrenByTagName(methodPermission, "role-name");
                    while (rolesIterator.hasNext()) {
                        roles.add(ApplicationMetaData.getElementContent((Element)rolesIterator.next()));
                    }
                    if (roles.size() == 0) {
                        throw new DeploymentException("An unchecked element or one or more role-name elements must be specified in method-permission");
                    }
                }
                Iterator methods = ApplicationMetaData.getChildrenByTagName(methodPermission, "method");
                while (methods.hasNext()) {
                    MethodMetaData method = new MethodMetaData();
                    method.importEjbJarXml((Element)methods.next());
                    if (isUnchecked) {
                        method.setUnchecked();
                    } else {
                        method.setRoles(roles);
                    }
                    BeanMetaData bean = this.getBeanByEjbName(method.getEjbName());
                    if (bean == null) {
                        throw new DeploymentException(method.getEjbName() + " doesn't exist");
                    }
                    bean.addPermissionMethod(method);
                }
            }
        }
        catch (DeploymentException e) {
            throw new DeploymentException("Error in ejb-jar.xml, in method-permission: " + e.getMessage());
        }
        iterator = ApplicationMetaData.getChildrenByTagName(descrElement, "container-transaction");
        try {
            while (iterator.hasNext()) {
                int transactionType;
                Element containerTransaction = (Element)iterator.next();
                String type = ApplicationMetaData.getElementContent(ApplicationMetaData.getUniqueChild(containerTransaction, "trans-attribute"));
                if (type.equalsIgnoreCase("NotSupported") || type.equalsIgnoreCase("Not_Supported")) {
                    transactionType = 0;
                } else if (type.equalsIgnoreCase("Supports")) {
                    transactionType = 2;
                } else if (type.equalsIgnoreCase("Required")) {
                    transactionType = 1;
                } else if (type.equalsIgnoreCase("RequiresNew") || type.equalsIgnoreCase("Requires_New")) {
                    transactionType = 3;
                } else if (type.equalsIgnoreCase("Mandatory")) {
                    transactionType = 4;
                } else {
                    if (!type.equalsIgnoreCase("Never")) throw new DeploymentException("invalid <transaction-attribute> : " + type);
                    transactionType = 5;
                }
                Iterator methods = ApplicationMetaData.getChildrenByTagName(containerTransaction, "method");
                while (methods.hasNext()) {
                    MethodMetaData method = new MethodMetaData();
                    method.importEjbJarXml((Element)methods.next());
                    method.setTransactionType((byte)transactionType);
                    BeanMetaData bean = this.getBeanByEjbName(method.getEjbName());
                    if (bean == null) {
                        throw new DeploymentException("bean " + method.getEjbName() + " doesn't exist");
                    }
                    bean.addTransactionMethod(method);
                }
            }
        }
        catch (DeploymentException e) {
            throw new DeploymentException("Error in ejb-jar.xml, in <container-transaction>: " + e.getMessage());
        }
        Element excludeList = ApplicationMetaData.getOptionalChild(descrElement, "exclude-list");
        if (excludeList != null) {
            iterator = ApplicationMetaData.getChildrenByTagName(excludeList, "method");
            while (iterator.hasNext()) {
                Element methodInf = (Element)iterator.next();
                MethodMetaData method = new MethodMetaData();
                method.importEjbJarXml(methodInf);
                method.setExcluded();
                BeanMetaData bean = this.getBeanByEjbName(method.getEjbName());
                if (bean == null) {
                    throw new DeploymentException("bean " + method.getEjbName() + " doesn't exist");
                }
                bean.addExcludedMethod(method);
            }
        }
        iterator = ApplicationMetaData.getChildrenByTagName(descrElement, "message-destination");
        while (iterator.hasNext()) {
            Element messageDestination = (Element)iterator.next();
            try {
                MessageDestinationMetaData messageDestinationMetaData = new MessageDestinationMetaData();
                messageDestinationMetaData.importEjbJarXml(messageDestination);
                this.assemblyDescriptor.addMessageDestinationMetaData(messageDestinationMetaData);
            }
            catch (Throwable t) {
                throw new DeploymentException("Error in ejb-jar.xml for message destination: " + t.getMessage());
            }
        }
    }

    public void importJbossXml(Element element) throws DeploymentException {
        Element resmans;
        Element descrElement;
        Element entBeans;
        Element webservices;
        Element confs;
        Iterator iterator;
        Element jmxNameElement;
        Element enforce = ApplicationMetaData.getOptionalChild(element, "enforce-ejb-restrictions");
        if (enforce != null) {
            String tmp = ApplicationMetaData.getElementContent(enforce);
            this.enforceEjbRestrictions = Boolean.valueOf(tmp);
        }
        if ((jmxNameElement = ApplicationMetaData.getOptionalChild(element, "jmx-name")) != null) {
            this.jmxName = ApplicationMetaData.getElementContent(jmxNameElement);
        }
        this.exceptionRollback = MetaData.getOptionalChildBooleanContent(element, "exception-on-rollback", false);
        Element securityDomainElement = ApplicationMetaData.getOptionalChild(element, "security-domain");
        if (securityDomainElement != null) {
            this.securityDomain = ApplicationMetaData.getElementContent(securityDomainElement);
        }
        this.excludeMissingMethods = MetaData.getOptionalChildBooleanContent(element, "missing-method-permissions-excluded-mode", true);
        Element unauth = ApplicationMetaData.getOptionalChild(element, "unauthenticated-principal");
        if (unauth != null) {
            this.unauthenticatedPrincipal = ApplicationMetaData.getElementContent(unauth);
        } else {
            try {
                MBeanServer server = MBeanServerLocator.locateJBoss();
                ObjectName oname = new ObjectName("jboss.security:service=JaasSecurityManager");
                this.unauthenticatedPrincipal = (String)server.getAttribute(oname, "DefaultUnauthenticatedPrincipal");
            }
            catch (Exception e) {
                log.error("Cannot obtain unauthenticated principal");
            }
        }
        Element invokerConfs = ApplicationMetaData.getOptionalChild(element, "invoker-proxy-bindings");
        if (invokerConfs != null) {
            iterator = ApplicationMetaData.getChildrenByTagName(invokerConfs, "invoker-proxy-binding");
            while (iterator.hasNext()) {
                Element invoker = (Element)iterator.next();
                String invokerName = ApplicationMetaData.getElementContent(ApplicationMetaData.getUniqueChild(invoker, "name"));
                InvokerProxyBindingMetaData invokerMetaData = this.getInvokerProxyBindingMetaDataByName(invokerName);
                if (invokerMetaData == null) {
                    invokerMetaData = new InvokerProxyBindingMetaData(invokerName);
                    this.invokerBindings.put(invokerName, invokerMetaData);
                }
                try {
                    invokerMetaData.importJbossXml(invoker);
                }
                catch (DeploymentException e) {
                    throw new DeploymentException("Error in jboss.xml for invoker-proxy-binding " + invokerMetaData.getName() + ": " + e.getMessage());
                }
            }
        }
        if ((confs = ApplicationMetaData.getOptionalChild(element, "container-configurations")) != null) {
            iterator = ApplicationMetaData.getChildrenByTagName(confs, "container-configuration");
            while (iterator.hasNext()) {
                Element conf = (Element)iterator.next();
                String confName = ApplicationMetaData.getElementContent(ApplicationMetaData.getUniqueChild(conf, "container-name"));
                String parentConfName = conf.getAttribute("extends");
                if (parentConfName != null && parentConfName.trim().length() == 0) {
                    parentConfName = null;
                }
                ConfigurationMetaData configurationMetaData = null;
                if (parentConfName != null) {
                    configurationMetaData = this.getConfigurationMetaDataByName(parentConfName);
                    if (configurationMetaData == null) {
                        throw new DeploymentException("Failed to find parent config=" + parentConfName);
                    }
                    configurationMetaData = (ConfigurationMetaData)configurationMetaData.clone();
                    this.configurations.put(confName, configurationMetaData);
                }
                if (configurationMetaData == null) {
                    configurationMetaData = this.getConfigurationMetaDataByName(confName);
                }
                if (configurationMetaData == null) {
                    configurationMetaData = new ConfigurationMetaData(confName);
                    this.configurations.put(confName, configurationMetaData);
                }
                try {
                    configurationMetaData.importJbossXml(conf);
                }
                catch (DeploymentException e) {
                    throw new DeploymentException("Error in jboss.xml for container-configuration " + configurationMetaData.getName() + ": " + e.getMessage());
                }
            }
        }
        if ((webservices = ApplicationMetaData.getOptionalChild(element, "webservices")) != null) {
            Element contextRoot = ApplicationMetaData.getOptionalChild(webservices, "context-root");
            if (contextRoot != null) {
                this.webServiceContextRoot = ApplicationMetaData.getElementContent(contextRoot);
                if (this.webServiceContextRoot.charAt(0) != '/') {
                    this.webServiceContextRoot = "/" + this.webServiceContextRoot;
                }
            }
            iterator = ApplicationMetaData.getChildrenByTagName(webservices, "webservice-description");
            while (iterator.hasNext()) {
                Element wsd = (Element)iterator.next();
                String wsdName = ApplicationMetaData.getElementContent(ApplicationMetaData.getUniqueChild(wsd, "webservice-description-name"));
                this.configName = MetaData.getOptionalChildContent(wsd, "config-name");
                this.configFile = MetaData.getOptionalChildContent(wsd, "config-file");
                String wsdlPublishLocation = ApplicationMetaData.getOptionalChildContent(wsd, "wsdl-publish-location");
                this.wsdlPublishLocationMap.put(wsdName, wsdlPublishLocation);
            }
        }
        if ((entBeans = ApplicationMetaData.getOptionalChild(element, "enterprise-beans")) != null) {
            String ejbName = null;
            try {
                BeanMetaData beanMetaData;
                Element bean;
                iterator = ApplicationMetaData.getChildrenByTagName(entBeans, "entity");
                while (iterator.hasNext()) {
                    bean = (Element)iterator.next();
                    ejbName = ApplicationMetaData.getElementContent(ApplicationMetaData.getUniqueChild(bean, "ejb-name"));
                    beanMetaData = this.getBeanByEjbName(ejbName);
                    if (beanMetaData == null) {
                        throw new DeploymentException("found in jboss.xml but not in ejb-jar.xml");
                    }
                    beanMetaData.importJbossXml(bean);
                }
                iterator = ApplicationMetaData.getChildrenByTagName(entBeans, "session");
                while (iterator.hasNext()) {
                    bean = (Element)iterator.next();
                    ejbName = ApplicationMetaData.getElementContent(ApplicationMetaData.getUniqueChild(bean, "ejb-name"));
                    beanMetaData = this.getBeanByEjbName(ejbName);
                    if (beanMetaData == null) {
                        throw new DeploymentException("found in jboss.xml but not in ejb-jar.xml");
                    }
                    beanMetaData.importJbossXml(bean);
                }
                iterator = ApplicationMetaData.getChildrenByTagName(entBeans, "message-driven");
                while (iterator.hasNext()) {
                    bean = (Element)iterator.next();
                    ejbName = ApplicationMetaData.getElementContent(ApplicationMetaData.getUniqueChild(bean, "ejb-name"));
                    beanMetaData = this.getBeanByEjbName(ejbName);
                    if (beanMetaData == null) {
                        throw new DeploymentException("found in jboss.xml but not in ejb-jar.xml");
                    }
                    beanMetaData.importJbossXml(bean);
                }
            }
            catch (DeploymentException e) {
                throw new DeploymentException("Error in jboss.xml for Bean " + ejbName + ": " + e.getMessage());
            }
        }
        if ((descrElement = ApplicationMetaData.getOptionalChild(element, "assembly-descriptor")) != null) {
            iterator = ApplicationMetaData.getChildrenByTagName(descrElement, "security-role");
            while (iterator.hasNext()) {
                Element securityRole = (Element)iterator.next();
                String roleName = ApplicationMetaData.getElementContent(ApplicationMetaData.getUniqueChild(securityRole, "role-name"));
                SecurityRoleMetaData securityRoleMetaData = this.assemblyDescriptor.getSecurityRoleByName(roleName);
                if (securityRoleMetaData == null) {
                    securityRoleMetaData = new SecurityRoleMetaData(roleName);
                    this.assemblyDescriptor.addSecurityRoleMetaData(securityRoleMetaData);
                }
                Iterator itPrincipalNames = ApplicationMetaData.getChildrenByTagName(securityRole, "principal-name");
                while (itPrincipalNames.hasNext()) {
                    String principalName = ApplicationMetaData.getElementContent((Element)itPrincipalNames.next());
                    securityRoleMetaData.addPrincipalName(principalName);
                }
            }
            iterator = ApplicationMetaData.getChildrenByTagName(descrElement, "message-destination");
            while (iterator.hasNext()) {
                Element messageDestination = (Element)iterator.next();
                try {
                    String messageDestinationName = ApplicationMetaData.getUniqueChildContent(messageDestination, "message-destination-name");
                    MessageDestinationMetaData messageDestinationMetaData = this.getMessageDestination(messageDestinationName);
                    if (messageDestinationMetaData == null) {
                        throw new DeploymentException("message-destination " + messageDestinationName + " found in jboss.xml but not in ejb-jar.xml");
                    }
                    messageDestinationMetaData.importJbossXml(messageDestination);
                }
                catch (Throwable t) {
                    throw new DeploymentException("Error in ejb-jar.xml for message destination: " + t.getMessage());
                }
            }
        }
        if ((resmans = ApplicationMetaData.getOptionalChild(element, "resource-managers")) != null) {
            iterator = ApplicationMetaData.getChildrenByTagName(resmans, "resource-manager");
            try {
                while (iterator.hasNext()) {
                    Element resourceManager = (Element)iterator.next();
                    String resName = ApplicationMetaData.getElementContent(ApplicationMetaData.getUniqueChild(resourceManager, "res-name"));
                    String jndi = ApplicationMetaData.getElementContent(ApplicationMetaData.getOptionalChild(resourceManager, "res-jndi-name"));
                    String url = ApplicationMetaData.getElementContent(ApplicationMetaData.getOptionalChild(resourceManager, "res-url"));
                    if (jndi != null && url == null) {
                        this.resources.put(resName, jndi);
                        continue;
                    }
                    if (jndi == null && url != null) {
                        this.resources.put(resName, url);
                        continue;
                    }
                    throw new DeploymentException(resName + " : expected res-url or res-jndi-name tag");
                }
            }
            catch (DeploymentException e) {
                throw new DeploymentException("Error in jboss.xml, in resource-manager: " + e.getMessage());
            }
        }
    }
}

