/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mdb;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.annotation.ejb.MessageProperties;
import org.jboss.annotation.ejb.MessagePropertiesImpl;
import org.jboss.annotation.ejb.Producer;
import org.jboss.annotation.ejb.Producers;
import org.jboss.aop.util.MethodHashing;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.JndiProxyFactory;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.mdb.ConsumerContainer;
import org.jboss.ejb3.mdb.ProducerImpl;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

public abstract class ProducerFactory
implements ProxyFactory {
    private static final Logger log = Logger.getLogger(ProducerFactory.class);
    protected Class producer;
    protected MessageProperties props;
    protected Destination dest;
    protected HashMap methodMap;
    protected ProducerImpl pImpl;
    protected String jndiName;
    protected InitialContext ctx;
    protected Hashtable initialContextProperties;
    public static final String PROXY_FACTORY_NAME = "PRODUCER_FACTORY";
    static /* synthetic */ Class class$org$jboss$annotation$ejb$MessageProperties;

    protected ProducerFactory(ConsumerContainer container, Class producer, MessageProperties props, Destination dest, InitialContext ctx, Hashtable ctxProperties) {
        this.producer = producer;
        this.props = props;
        this.dest = dest;
        this.ctx = ctx;
        this.initialContextProperties = ctxProperties;
        this.methodMap = new HashMap();
        Method[] methods = producer.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            MessageProperties mProps = (MessageProperties)methods[i].getAnnotation(class$org$jboss$annotation$ejb$MessageProperties == null ? ProducerFactory.class$("org.jboss.annotation.ejb.MessageProperties") : class$org$jboss$annotation$ejb$MessageProperties);
            if (mProps == null) continue;
            try {
                this.methodMap.put(new Long(MethodHashing.methodHash(methods[i])), new MessagePropertiesImpl(mProps));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Producer p = (Producer)producer.getAnnotation(Producer.class);
        if (p == null) {
            p = (Producer)container.resolveAnnotation(Producer.class);
        }
        if (p == null) {
            Producers annotation = (Producers)container.resolveAnnotation(Producers.class);
            Producer[] producers = annotation.value();
            for (int i = 0; i < producers.length; ++i) {
                if (producers[i].producer() == null || !producers[i].producer().equals(producer)) continue;
                p = producers[i];
            }
        }
        this.pImpl = new ProducerImpl(p);
        this.jndiName = producer.getName();
    }

    public void setContainer(Container container) {
    }

    public void start() throws Exception {
        Context baseCtx = this.ctx;
        Name name = baseCtx.getNameParser("").parse(this.jndiName);
        baseCtx = Util.createSubcontext(baseCtx, name.getPrefix(name.size() - 1));
        String atom = name.get(name.size() - 1);
        StringRefAddr refAddr = new StringRefAddr("FACTORY", atom + PROXY_FACTORY_NAME);
        Reference ref = new Reference("java.lang.Object", refAddr, JndiProxyFactory.class.getName(), null);
        try {
            Util.bind(baseCtx, atom, (Object)ref);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind producer factory into JNDI under jndiName: " + baseCtx.getNameInNamespace() + "/" + atom);
            namingException.setRootCause(e);
            throw namingException;
        }
    }

    public void stop() throws Exception {
        Util.unbind((Context)this.ctx, this.jndiName);
    }
}

