/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.util.Properties;
import javax.management.ObjectName;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.TreeCache;
import org.jboss.cache.TreeCacheMBean;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;

public class TreeCacheProviderHook
implements CacheProvider {
    private org.jboss.cache.TreeCache cache;

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        return new TreeCache(this.cache, regionName, TxUtil.getTransactionManager());
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public void start(Properties properties) {
        try {
            ObjectName mbeanObjectName = new ObjectName((String)properties.get("hibernate.treecache.mbean.object_name"));
            TreeCacheMBean mbean = (TreeCacheMBean)MBeanProxyExt.create(TreeCacheMBean.class, mbeanObjectName, MBeanServerLocator.locateJBoss());
            this.cache = mbean.getInstance();
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void stop() {
    }
}

