/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.bridge;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.GenericEntityObjectFactory;
import org.jboss.ejb.plugins.cmp.bridge.SelectorBridge;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCQueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;

public class JDBCSelectorBridge
implements SelectorBridge {
    private final JDBCQueryMetaData queryMetaData;
    private final JDBCStoreManager manager;
    private TransactionManager tm;
    private boolean syncBeforeSelect;

    public JDBCSelectorBridge(JDBCStoreManager manager, JDBCQueryMetaData queryMetaData) {
        this.queryMetaData = queryMetaData;
        this.manager = manager;
        EntityContainer container = manager.getContainer();
        this.tm = container.getTransactionManager();
        this.syncBeforeSelect = !container.getBeanMetaData().getContainerConfiguration().getSyncOnCommitOnly();
    }

    public Object invoke(EntityEnterpriseContext ctx, Method method, Object[] args) throws Exception {
        Transaction tx;
        Transaction transaction = tx = ctx != null ? ctx.getTransaction() : this.tm.getTransaction();
        if (this.syncBeforeSelect) {
            EntityContainer.synchronizeEntitiesWithinTransaction(tx);
        }
        return this.execute(args);
    }

    public String getSelectorName() {
        return this.queryMetaData.getMethod().getName();
    }

    public Method getMethod() {
        return this.queryMetaData.getMethod();
    }

    private Class getReturnType() {
        return this.queryMetaData.getMethod().getReturnType();
    }

    public Object execute(Object[] args) throws FinderException {
        Collection retVal;
        Method method = this.getMethod();
        try {
            JDBCQueryCommand query = this.manager.getQueryManager().getQueryCommand(method);
            GenericEntityObjectFactory factory = this.queryMetaData.isResultTypeMappingLocal() ? query.getSelectManager().getContainer().getLocalProxyFactory() : query.getSelectManager().getContainer().getProxyFactory();
            retVal = query.execute(method, args, null, factory);
        }
        catch (FinderException e) {
            throw e;
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Error in " + this.getSelectorName(), e);
        }
        if (!Collection.class.isAssignableFrom(this.getReturnType())) {
            if (retVal.size() == 0) {
                throw new ObjectNotFoundException();
            }
            if (retVal.size() > 1) {
                throw new FinderException(this.getSelectorName() + " returned " + retVal.size() + " objects");
            }
            Object o = retVal.iterator().next();
            if (o == null && method.getReturnType().isPrimitive()) {
                throw new FinderException("Cannot return null as a value of primitive type " + method.getReturnType().getName());
            }
            return o;
        }
        if (Set.class.isAssignableFrom(this.getReturnType())) {
            return new HashSet(retVal);
        }
        return retVal;
    }
}

