/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.jmx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;

public class JmxIntrospectingMixin
implements DynamicMBean {
    private final Object target;
    private final HashMap ops = new HashMap();
    private final HashMap gets = new HashMap();
    private final HashMap sets = new HashMap();
    private MBeanInfo mbeanInfo;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;

    public JmxIntrospectingMixin(Object target) {
        this.target = target;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Method get = (Method)this.gets.get(attribute);
        if (get == null) {
            throw new AttributeNotFoundException(attribute);
        }
        try {
            return get.invoke(this.target, null);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Exception) {
                throw new MBeanException((Exception)e.getTargetException());
            }
            throw new MBeanException(new Exception(e.getTargetException().getMessage()));
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Method set = (Method)this.sets.get(attribute.getName());
        if (set == null) {
            throw new AttributeNotFoundException(attribute.getName());
        }
        try {
            Object[] args = new Object[]{attribute.getValue()};
            set.invoke(this.target, args);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Exception) {
                throw new MBeanException((Exception)e.getTargetException());
            }
            throw new MBeanException(new Exception(e.getTargetException().getMessage()));
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            try {
                list.add(0, new Attribute(attributes[i], this.getAttribute(attributes[i])));
                continue;
            }
            catch (AttributeNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (MBeanException e) {
                throw new RuntimeException(e);
            }
            catch (ReflectionException e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        for (int i = 0; i < attributes.size(); ++i) {
            try {
                Attribute attr = (Attribute)attributes.get(i);
                this.setAttribute(attr);
                continue;
            }
            catch (InvalidAttributeValueException inv) {
                throw new RuntimeException(inv);
            }
            catch (AttributeNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (MBeanException e) {
                throw new RuntimeException(e);
            }
            catch (ReflectionException e) {
                throw new RuntimeException(e);
            }
        }
        return attributes;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        OpsKey key = new OpsKey(actionName, signature);
        Method m = (Method)this.ops.get(key);
        if (m == null) {
            throw new NoSuchMethodError(actionName);
        }
        try {
            return m.invoke(this.target, params);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof Exception) {
                throw new MBeanException((Exception)cause);
            }
            throw new MBeanException(new Exception(e.getMessage()));
        }
    }

    public MBeanInfo getMBeanInfo() {
        if (this.mbeanInfo != null) {
            return this.mbeanInfo;
        }
        try {
            Method m;
            Method[] methods = this.target.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (methods[i].getName().equals("_getInstanceAdvisor") || methods[i].getName().equals("_setInstanceAdvisor") || methods[i].getName().equals("_getAdvisor") || methods[i].getName().equals("setAttribute") || methods[i].getName().equals("getMBeanInfo") || methods[i].getName().equals("getAttribute") || methods[i].getName().equals("setAttributes") || methods[i].getName().equals("getAttributes") || methods[i].getName().equals("invoke") || methods[i].getName().indexOf("$aop") != -1 || methods[i].getDeclaringClass().equals(class$java$lang$Object == null ? JmxIntrospectingMixin.class$("java.lang.Object") : class$java$lang$Object)) continue;
                if (methods[i].getName().startsWith("get") && methods[i].getParameterTypes().length == 0) {
                    this.gets.put(methods[i].getName().substring(3), methods[i]);
                    continue;
                }
                if (methods[i].getName().startsWith("is") && methods[i].getParameterTypes().length == 0 && (methods[i].getReturnType().equals(class$java$lang$Boolean == null ? JmxIntrospectingMixin.class$("java.lang.Boolean") : class$java$lang$Boolean) || methods[i].getReturnType().equals(Boolean.TYPE))) {
                    this.gets.put(methods[i].getName().substring(2), methods[i]);
                    continue;
                }
                if (methods[i].getName().startsWith("set") && methods[i].getParameterTypes().length == 1) {
                    this.sets.put(methods[i].getName().substring(3), methods[i]);
                    continue;
                }
                String[] signature = new String[methods[i].getParameterTypes().length];
                for (int j = 0; j < methods[i].getParameterTypes().length; ++j) {
                    signature[j] = methods[i].getParameterTypes()[j].getName();
                }
                this.ops.put(new OpsKey(methods[i].getName(), signature), methods[i]);
            }
            HashMap<String, MBeanAttributeInfo> attributes = new HashMap<String, MBeanAttributeInfo>();
            Iterator<Object> it = this.gets.keySet().iterator();
            while (it.hasNext()) {
                String attribute = (String)it.next();
                m = (Method)this.gets.get(attribute);
                boolean isWritable = this.sets.containsKey(attribute);
                boolean isIs = m.getName().startsWith("is");
                MBeanAttributeInfo info = new MBeanAttributeInfo(attribute, m.getReturnType().getName(), this.target.getClass().getName() + "." + attribute, true, isWritable, isIs);
                attributes.put(attribute, info);
            }
            it = this.sets.keySet().iterator();
            while (it.hasNext()) {
                String attribute = (String)it.next();
                if (this.gets.containsKey(attribute)) continue;
                m = (Method)this.sets.get(attribute);
                MBeanAttributeInfo info = new MBeanAttributeInfo(attribute, m.getReturnType().getName(), this.target.getClass().getName() + "." + attribute, false, true, false);
                attributes.put(attribute, info);
            }
            MBeanOperationInfo[] operations = new MBeanOperationInfo[this.ops.size()];
            it = this.ops.values().iterator();
            int i = 0;
            while (it.hasNext()) {
                Method m2 = (Method)it.next();
                operations[i++] = new MBeanOperationInfo(m2.toString(), m2);
            }
            MBeanAttributeInfo[] attrs = attributes.values().toArray(new MBeanAttributeInfo[attributes.size()]);
            this.mbeanInfo = new MBeanInfo(this.target.getClass().getName(), this.target.getClass().getName(), attrs, null, operations, null);
            return this.mbeanInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public class OpsKey {
        private final String methodName;
        private final String[] signature;
        private final int hash;

        public OpsKey(String methodName, String[] signature) {
            this.methodName = methodName;
            this.signature = signature;
            int tmp = methodName.hashCode();
            for (int i = 0; i < signature.length; ++i) {
                tmp += signature[i].hashCode();
            }
            this.hash = tmp;
        }

        public int hashCode() {
            return this.hash;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String[] getSignature() {
            return this.signature;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            OpsKey key = (OpsKey)obj;
            if (key.hash != this.hash) {
                return false;
            }
            if (!key.methodName.equals(this.methodName)) {
                return false;
            }
            if (key.signature.length != this.signature.length) {
                return false;
            }
            for (int i = 0; i < this.signature.length; ++i) {
                if (this.signature[i].equals(key.signature[i])) continue;
                return false;
            }
            return true;
        }
    }
}

