/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.Map;
import javassist.ByteArrayClassPath;
import javassist.ClassPath;
import javassist.CtClass;
import javassist.NotFoundException;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.Advised;
import org.jboss.aop.AdvisorFactory;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.WeavingStrategySupport;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.InstrumentorFactory;

public class SuperClassesFirstWeavingStrategy
extends WeavingStrategySupport {
    private boolean verbose = AspectManager.verbose;
    public static final String AOP_PACKAGE = Advised.class.getPackage().getName();
    private Map instrumentedClassCache = new ConcurrentReaderHashMap();

    public byte[] translate(AspectManager manager, String className, ClassLoader loader, byte[] classfileBuffer) throws Exception {
        if (SuperClassesFirstWeavingStrategy.isReEntry()) {
            return null;
        }
        SuperClassesFirstWeavingStrategy.setReEntry();
        manager.transformationStarted = true;
        try {
            CtClassTransformationInfo info;
            if (manager.isNonAdvisableClassName(className)) {
                byte[] byArray = null;
                return byArray;
            }
            AOPClassPool pool = (AOPClassPool)manager.registerClassLoader(loader);
            CtClass clazz = this.instrumentClass(manager, loader, pool, info = this.obtainCtClassInfo(pool, className, classfileBuffer), true);
            if (clazz != null) {
                pool.lockInCache(info.getClazz());
                byte[] rtn = info.getClazz().toBytecode();
                if (AspectManager.prune) {
                    info.getClazz().prune();
                }
                byte[] byArray = rtn;
                return byArray;
            }
            pool.soften(info.getClazz());
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception ex) {
            if (!(ex instanceof NotFoundException)) {
                if (this.verbose) {
                    ex.printStackTrace();
                } else {
                    System.err.println("[error] " + ex.getMessage() + ".. Do verbose mode if you want full stack trace.");
                }
            }
            throw ex;
        }
        finally {
            SuperClassesFirstWeavingStrategy.clearReEntry();
        }
    }

    private CtClassTransformationInfo obtainCtClassInfo(AOPClassPool pool, String className, byte[] classfileBuffer) throws NotFoundException {
        CtClassTransformationInfo cachedInfo = (CtClassTransformationInfo)this.instrumentedClassCache.get(className);
        if (cachedInfo != null) {
            return cachedInfo;
        }
        try {
            return new CtClassTransformationInfo(pool.getLocally(className), className);
        }
        catch (NotFoundException e) {
            ByteArrayClassPath cp = new ByteArrayClassPath(className, classfileBuffer);
            pool.insertClassPath((ClassPath)cp);
            return new CtClassTransformationInfo(pool.getLocally(className), className);
        }
    }

    private CtClass instrumentClass(AspectManager manager, ClassLoader loader, AOPClassPool pool, CtClassTransformationInfo info, boolean isLoadedClass) throws NotFoundException, Exception {
        block22: {
            Instrumentor instrumentor;
            ClassAdvisor advisor;
            block28: {
                block26: {
                    CtClassTransformationInfo superCached;
                    block27: {
                        block25: {
                            block24: {
                                block23: {
                                    block21: {
                                        CtClass superClass = info.getClazz().getSuperclass();
                                        if (superClass != null && !Instrumentor.implementsAdvised(info.getClazz())) {
                                            superCached = (CtClassTransformationInfo)this.instrumentedClassCache.get(superClass.getName());
                                            if (superCached == null) {
                                                superCached = new CtClassTransformationInfo(superClass, superClass.getName());
                                            }
                                            this.instrumentClass(manager, loader, pool, superCached, false);
                                        }
                                        if (this.instrumentedClassCache.get(info.getClassName()) == null) break block21;
                                        if (isLoadedClass && info.isTransformed()) {
                                            superCached = info.getClazz();
                                            return superCached;
                                        }
                                        break block22;
                                    }
                                    if (!manager.isNonAdvisableClassName(info.getClassName())) break block23;
                                    superCached = null;
                                    return superCached;
                                }
                                if (!info.getClass().isArray()) break block24;
                                if (this.verbose) {
                                    System.out.println("[cannot compile] isArray: " + info.getClassName());
                                }
                                pool.flushClass(info.getClassName());
                                superCached = null;
                                return superCached;
                            }
                            if (!info.getClazz().isInterface()) break block25;
                            if (this.verbose) {
                                System.out.println("[cannot compile] isInterface: " + info.getClassName());
                            }
                            info.getClazz().prune();
                            superCached = null;
                            return superCached;
                        }
                        if (!info.getClazz().isFrozen()) break block26;
                        if (!this.isAdvised(pool, info.getClazz())) break block27;
                        superCached = null;
                        return superCached;
                    }
                    if (this.verbose) {
                        System.out.println("[warning] isFrozen: " + info.getClassName());
                    }
                    if (!isLoadedClass) {
                        info = this.obtainCtClassInfo(pool, info.getClassName(), null);
                        break block26;
                    }
                    superCached = null;
                    return superCached;
                }
                advisor = AdvisorFactory.getClassAdvisor(info.getClassName(), manager);
                instrumentor = InstrumentorFactory.getInstrumentor(pool, manager, manager.dynamicStrategy.getJoinpointClassifier(), manager.dynamicStrategy.getDynamicTransformationObserver(info.getClazz()));
                if (Instrumentor.isTransformable(info.getClazz())) break block28;
                if (this.verbose) {
                    System.out.println("[cannot compile] implements Untransformable: " + info.getClassName());
                }
                CtClass ctClass = null;
                return ctClass;
            }
            manager.attachMetaData(advisor, info.getClazz(), true);
            manager.applyInterfaceIntroductions(advisor, info.getClazz());
            boolean transformed = instrumentor.transform(info.getClazz(), advisor);
            if (!transformed) break block22;
            if (!isLoadedClass) {
                info.setTransformed(transformed);
            }
            CtClass ctClass = info.getClazz();
            return ctClass;
        }
        try {
            CtClass ctClass = null;
            return ctClass;
        }
        catch (Exception e) {
            throw new RuntimeException("Error converting class ", e);
        }
    }

    public boolean isAdvised(AOPClassPool pool, CtClass clazz) throws NotFoundException {
        CtClass[] interfaces = clazz.getInterfaces();
        CtClass advised = pool.get(AOP_PACKAGE + ".Advised");
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i].equals(advised)) {
                return true;
            }
            if (!interfaces[i].getName().equals(AOP_PACKAGE + ".Advised")) continue;
            return true;
        }
        return false;
    }

    private class CtClassTransformationInfo {
        boolean transformed;
        CtClass clazz;
        String className;

        private CtClassTransformationInfo(CtClass clazz, String className) {
            this.clazz = clazz;
            this.className = className;
        }

        private CtClassTransformationInfo(CtClass clazz, String className, boolean transformed) {
            this.clazz = clazz;
            this.className = className;
            this.transformed = transformed;
        }

        private CtClass getClazz() {
            return this.clazz;
        }

        private boolean isTransformed() {
            return this.transformed;
        }

        private void setTransformed(boolean transformed) {
            this.transformed = transformed;
        }

        private String getClassName() {
            return this.className;
        }
    }
}

