/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.jboss.aop.AspectManager;
import org.jboss.util.collection.SoftValueHashMap;

public class AOPClassPool
extends ClassPool {
    protected AspectManager manager;
    private WeakReference dcl;
    protected LoaderClassPath classPath;
    protected SoftValueHashMap softcache = new SoftValueHashMap();
    protected ConcurrentReaderHashMap generatedClasses = new ConcurrentReaderHashMap();

    public AOPClassPool(ClassLoader cl, ClassPool src, AspectManager manager) {
        super(src);
        this.manager = manager;
        this.setClassLoader(cl);
        if (cl != null) {
            this.classPath = new LoaderClassPath(cl);
            this.insertClassPath((ClassPath)this.classPath);
        }
        this.childFirstLookup = true;
    }

    protected AOPClassPool(ClassPool src, AspectManager manager) {
        this(null, src, manager);
    }

    public void registerGeneratedClass(String className) {
        this.generatedClasses.put((Object)className, (Object)className);
    }

    public ClassLoader getClassLoader() {
        if (this.dcl == null) {
            return null;
        }
        return (ClassLoader)this.dcl.get();
    }

    public void setClassLoader(ClassLoader loader) {
        this.dcl = loader == null ? null : new WeakReference<ClassLoader>(loader);
    }

    public void close() {
        this.removeClassPath((ClassPath)this.classPath);
        this.classPath.close();
        this.classes.clear();
        this.softcache.clear();
    }

    public synchronized void flushClass(String classname) {
        this.classes.remove(classname);
        this.softcache.remove(classname);
    }

    public synchronized void soften(CtClass clazz) {
        if (AspectManager.prune) {
            clazz.prune();
        }
        this.classes.remove(clazz.getName());
        this.softcache.put(clazz.getName(), clazz);
    }

    public boolean isUnloadedClassLoader() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CtClass getCached(String classname) {
        CtClass clazz = this.getCachedLocally(classname);
        if (clazz == null) {
            Object o;
            boolean isLocal = false;
            if (this.getClassLoader() != null) {
                String classReeourceName = this.getResuorceName(classname);
                isLocal = this.isLocalResource(classReeourceName);
            }
            if (!isLocal && (o = this.generatedClasses.get((Object)classname)) == null) {
                Map registeredCLs;
                Map map = registeredCLs = this.manager.getRegisteredCLs();
                synchronized (map) {
                    Iterator it = registeredCLs.values().iterator();
                    while (it.hasNext()) {
                        AOPClassPool pool = (AOPClassPool)((Object)it.next());
                        if (pool.isUnloadedClassLoader()) {
                            AspectManager.instance().unregisterClassLoader(pool.getClassLoader());
                            continue;
                        }
                        clazz = pool.getCachedLocally(classname);
                        if (clazz == null) continue;
                        return clazz;
                    }
                }
            }
        }
        return clazz;
    }

    protected String getResuorceName(String classname) {
        int lastIndex = classname.lastIndexOf(36);
        if (lastIndex < 0) {
            return classname.replaceAll("[\\.]", "/") + ".class";
        }
        return classname.substring(0, lastIndex).replaceAll("[\\.]", "/") + classname.substring(lastIndex) + ".class";
    }

    protected boolean isLocalResource(String resourceName) {
        String classResourceName = this.getResuorceName(resourceName);
        return this.getClassLoader().getResource(classResourceName) != null;
    }

    protected void cacheCtClass(String classname, CtClass c, boolean dynamic) {
        if (dynamic) {
            super.cacheCtClass(classname, c, dynamic);
        } else {
            if (AspectManager.prune) {
                c.prune();
            }
            this.softcache.put(classname, c);
        }
    }

    public void lockInCache(CtClass c) {
        super.cacheCtClass(c.getName(), c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CtClass getCachedLocally(String classname) {
        CtClass cached = (CtClass)this.classes.get(classname);
        if (cached != null) {
            return cached;
        }
        SoftValueHashMap softValueHashMap = this.softcache;
        synchronized (softValueHashMap) {
            return (CtClass)this.softcache.get(classname);
        }
    }

    public synchronized CtClass getLocally(String classname) throws NotFoundException {
        this.softcache.remove(classname);
        CtClass clazz = (CtClass)this.classes.get(classname);
        if (clazz == null) {
            clazz = this.createCtClass(classname, true);
            if (clazz == null) {
                throw new NotFoundException(classname);
            }
            super.cacheCtClass(classname, clazz, false);
        }
        return clazz;
    }

    public static AOPClassPool createAOPClassPool(ClassLoader cl, ClassPool src, AspectManager manager) {
        return AspectManager.classPoolFactory.create(cl, src, manager);
    }

    public static AOPClassPool createAOPClassPool(ClassPool src, AspectManager manager) {
        return AspectManager.classPoolFactory.create(src, manager);
    }

    public Class toClass(CtClass ct, ClassLoader loader) throws CannotCompileException {
        this.lockInCache(ct);
        return super.toClass(ct, this.getClassLoader());
    }

    static {
        ClassPool.doPruning = false;
        ClassPool.releaseUnmodifiedClassFile = false;
    }
}

