/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.message.properties;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.objectweb.jtests.jms.framework.PTPTestCase;

public class MessagePropertyConversionTest
extends PTPTestCase {
    public void testString2String() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("pi", "3.14159");
            MessagePropertyConversionTest.assertEquals((String)"3.14159", (String)message.getStringProperty("pi"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Double_2() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("pi", "not_a_number");
            message.getDoubleProperty("pi");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The String to numeric conversions must throw the java.lang.NumberFormatException  if the numeric's valueOf() method does not accept the String value as a valid representation.\n");
        }
        catch (NumberFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Double_1() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("pi", "3.14159");
            MessagePropertyConversionTest.assertEquals((double)3.14159, (double)message.getDoubleProperty("pi"), (double)0.0);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Float_2() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("pi", "not_a_number");
            message.getFloatProperty("pi");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The String to numeric conversions must throw the java.lang.NumberFormatException  if the numeric's valueOf() method does not accept the String value as a valid representation.\n");
        }
        catch (NumberFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Float_1() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("pi", "3.14159");
            MessagePropertyConversionTest.assertEquals((float)3.14159f, (float)message.getFloatProperty("pi"), (float)0.0f);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Long_2() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("pi", "3.14159");
            message.getLongProperty("pi");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The String to numeric conversions must throw the java.lang.NumberFormatException  if the numeric's valueOf() method does not accept the String value as a valid representation.\n");
        }
        catch (NumberFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Long_1() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("prop", "0");
            MessagePropertyConversionTest.assertEquals((long)0L, (long)message.getLongProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Int_2() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("pi", "3.14159");
            message.getIntProperty("pi");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The String to numeric conversions must throw the java.lang.NumberFormatException  if the numeric's valueOf() method does not accept the String value as a valid representation.\n");
        }
        catch (NumberFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Int_1() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("prop", "0");
            MessagePropertyConversionTest.assertEquals((int)0, (int)message.getIntProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Short_2() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("pi", "3.14159");
            message.getShortProperty("pi");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The String to numeric conversions must throw the java.lang.NumberFormatException  if the numeric's valueOf() method does not accept the String value as a valid representation.\n");
        }
        catch (NumberFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Short_1() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("prop", "0");
            MessagePropertyConversionTest.assertEquals((short)0, (short)message.getShortProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Byte_2() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("pi", "3.14159");
            message.getByteProperty("pi");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The String to numeric conversions must throw the java.lang.NumberFormatException  if the numeric's valueOf() method does not accept the String value as a valid representation.\n");
        }
        catch (NumberFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Byte_1() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("prop", "0");
            MessagePropertyConversionTest.assertEquals((byte)0, (byte)message.getByteProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Boolean_2() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("prop", "test");
            MessagePropertyConversionTest.assertEquals((boolean)false, (boolean)message.getBooleanProperty("prop"));
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Boolean_1() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("prop", "true");
            MessagePropertyConversionTest.assertEquals((boolean)true, (boolean)message.getBooleanProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testDouble2String() {
        try {
            Message message = this.senderSession.createMessage();
            message.setDoubleProperty("prop", 127.0);
            MessagePropertyConversionTest.assertEquals((String)"127.0", (String)message.getStringProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testDouble2Double() {
        try {
            Message message = this.senderSession.createMessage();
            message.setDoubleProperty("prop", 127.0);
            MessagePropertyConversionTest.assertEquals((double)127.0, (double)message.getDoubleProperty("prop"), (double)0.0);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testDouble2Float() {
        try {
            Message message = this.senderSession.createMessage();
            message.setDoubleProperty("prop", 127.0);
            message.getFloatProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testDouble2Long() {
        try {
            Message message = this.senderSession.createMessage();
            message.setDoubleProperty("prop", 127.0);
            message.getLongProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testDouble2Int() {
        try {
            Message message = this.senderSession.createMessage();
            message.setDoubleProperty("prop", 127.0);
            message.getIntProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testDouble2Short() {
        try {
            Message message = this.senderSession.createMessage();
            message.setDoubleProperty("prop", 127.0);
            message.getShortProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testDouble2Byte() {
        try {
            Message message = this.senderSession.createMessage();
            message.setDoubleProperty("prop", 127.0);
            message.getByteProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testDouble2Boolean() {
        try {
            Message message = this.senderSession.createMessage();
            message.setDoubleProperty("prop", 127.0);
            message.getBooleanProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testFloat2String() {
        try {
            Message message = this.senderSession.createMessage();
            message.setFloatProperty("prop", 127.0f);
            MessagePropertyConversionTest.assertEquals((String)"127.0", (String)message.getStringProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testFloat2Double() {
        try {
            Message message = this.senderSession.createMessage();
            message.setFloatProperty("prop", 127.0f);
            MessagePropertyConversionTest.assertEquals((double)127.0, (double)message.getDoubleProperty("prop"), (double)0.0);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testFloat2Float() {
        try {
            Message message = this.senderSession.createMessage();
            message.setFloatProperty("prop", 127.0f);
            MessagePropertyConversionTest.assertEquals((float)127.0f, (float)message.getFloatProperty("prop"), (float)0.0f);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testFloat2Long() {
        try {
            Message message = this.senderSession.createMessage();
            message.setFloatProperty("prop", 127.0f);
            message.getLongProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testFloat2Int() {
        try {
            Message message = this.senderSession.createMessage();
            message.setFloatProperty("prop", 127.0f);
            message.getIntProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testFloat2Short() {
        try {
            Message message = this.senderSession.createMessage();
            message.setFloatProperty("prop", 127.0f);
            message.getShortProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testFloat2Byte() {
        try {
            Message message = this.senderSession.createMessage();
            message.setFloatProperty("prop", 127.0f);
            message.getByteProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testFloat2Boolean() {
        try {
            Message message = this.senderSession.createMessage();
            message.setFloatProperty("prop", 127.0f);
            message.getBooleanProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLong2String() {
        try {
            Message message = this.senderSession.createMessage();
            message.setLongProperty("prop", 127L);
            MessagePropertyConversionTest.assertEquals((String)"127", (String)message.getStringProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLong2Double() {
        try {
            Message message = this.senderSession.createMessage();
            message.setLongProperty("prop", 127L);
            message.getDoubleProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLong2Float() {
        try {
            Message message = this.senderSession.createMessage();
            message.setLongProperty("prop", 127L);
            message.getFloatProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLong2Long() {
        try {
            Message message = this.senderSession.createMessage();
            message.setLongProperty("prop", 127L);
            MessagePropertyConversionTest.assertEquals((long)127L, (long)message.getLongProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLong2Int() {
        try {
            Message message = this.senderSession.createMessage();
            message.setLongProperty("prop", 127L);
            message.getIntProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLong2Short() {
        try {
            Message message = this.senderSession.createMessage();
            message.setLongProperty("prop", 127L);
            message.getShortProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLong2Byte() {
        try {
            Message message = this.senderSession.createMessage();
            message.setLongProperty("prop", 127L);
            message.getByteProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLong2Boolean() {
        try {
            Message message = this.senderSession.createMessage();
            message.setLongProperty("prop", 127L);
            message.getBooleanProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testInt2String() {
        try {
            Message message = this.senderSession.createMessage();
            message.setIntProperty("prop", 127);
            MessagePropertyConversionTest.assertEquals((String)"127", (String)message.getStringProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testInt2Double() {
        try {
            Message message = this.senderSession.createMessage();
            message.setIntProperty("prop", 127);
            message.getDoubleProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testInt2Float() {
        try {
            Message message = this.senderSession.createMessage();
            message.setIntProperty("prop", 127);
            message.getFloatProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testInt2Long() {
        try {
            Message message = this.senderSession.createMessage();
            message.setIntProperty("prop", 127);
            MessagePropertyConversionTest.assertEquals((long)127L, (long)message.getLongProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testInt2Int() {
        try {
            Message message = this.senderSession.createMessage();
            message.setIntProperty("prop", 127);
            MessagePropertyConversionTest.assertEquals((int)127, (int)message.getIntProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testInt2Short() {
        try {
            Message message = this.senderSession.createMessage();
            message.setIntProperty("prop", Integer.MAX_VALUE);
            message.getShortProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testInt2Byte() {
        try {
            Message message = this.senderSession.createMessage();
            message.setIntProperty("prop", Integer.MAX_VALUE);
            message.getByteProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testInt2Boolean() {
        try {
            Message message = this.senderSession.createMessage();
            message.setIntProperty("prop", Integer.MAX_VALUE);
            message.getBooleanProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testShort2String() {
        try {
            Message message = this.senderSession.createMessage();
            message.setShortProperty("prop", (short)127);
            MessagePropertyConversionTest.assertEquals((String)"127", (String)message.getStringProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testShort2Double() {
        try {
            Message message = this.senderSession.createMessage();
            message.setShortProperty("prop", (short)127);
            message.getDoubleProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testShort2Float() {
        try {
            Message message = this.senderSession.createMessage();
            message.setShortProperty("prop", (short)127);
            message.getFloatProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testShort2Long() {
        try {
            Message message = this.senderSession.createMessage();
            message.setShortProperty("prop", (short)127);
            MessagePropertyConversionTest.assertEquals((long)127L, (long)message.getLongProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testShort2Int() {
        try {
            Message message = this.senderSession.createMessage();
            message.setShortProperty("prop", (short)127);
            MessagePropertyConversionTest.assertEquals((int)127, (int)message.getIntProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testShort2Short() {
        try {
            Message message = this.senderSession.createMessage();
            message.setShortProperty("prop", (short)127);
            MessagePropertyConversionTest.assertEquals((short)127, (short)message.getShortProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testShort2Byte() {
        try {
            Message message = this.senderSession.createMessage();
            message.setShortProperty("prop", (short)127);
            message.getByteProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testShort2Boolean() {
        try {
            Message message = this.senderSession.createMessage();
            message.setShortProperty("prop", (short)127);
            message.getBooleanProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testByte2String() {
        try {
            Message message = this.senderSession.createMessage();
            message.setByteProperty("prop", (byte)127);
            MessagePropertyConversionTest.assertEquals((String)"127", (String)message.getStringProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testByte2Double() {
        try {
            Message message = this.senderSession.createMessage();
            message.setByteProperty("prop", (byte)127);
            message.getDoubleProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testByte2Float() {
        try {
            Message message = this.senderSession.createMessage();
            message.setByteProperty("prop", (byte)127);
            message.getFloatProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testByte2Long() {
        try {
            Message message = this.senderSession.createMessage();
            message.setByteProperty("prop", (byte)127);
            MessagePropertyConversionTest.assertEquals((long)127L, (long)message.getLongProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testByte2Int() {
        try {
            Message message = this.senderSession.createMessage();
            message.setByteProperty("prop", (byte)127);
            MessagePropertyConversionTest.assertEquals((int)127, (int)message.getIntProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testByte2Short() {
        try {
            Message message = this.senderSession.createMessage();
            message.setByteProperty("prop", (byte)127);
            MessagePropertyConversionTest.assertEquals((short)127, (short)message.getShortProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testByte2Byte() {
        try {
            Message message = this.senderSession.createMessage();
            message.setByteProperty("prop", (byte)127);
            MessagePropertyConversionTest.assertEquals((byte)127, (byte)message.getByteProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testByte2Boolean() {
        try {
            Message message = this.senderSession.createMessage();
            message.setByteProperty("prop", (byte)127);
            message.getBooleanProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBoolean2String() {
        try {
            Message message = this.senderSession.createMessage();
            message.setBooleanProperty("prop", true);
            MessagePropertyConversionTest.assertEquals((String)"true", (String)message.getStringProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBoolean2Double() {
        try {
            Message message = this.senderSession.createMessage();
            message.setBooleanProperty("prop", true);
            message.getDoubleProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBoolean2Float() {
        try {
            Message message = this.senderSession.createMessage();
            message.setBooleanProperty("prop", true);
            message.getFloatProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBoolean2Long() {
        try {
            Message message = this.senderSession.createMessage();
            message.setBooleanProperty("true", true);
            message.getLongProperty("true");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBoolean2Int() {
        try {
            Message message = this.senderSession.createMessage();
            message.setBooleanProperty("prop", true);
            message.getIntProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBoolean2Short() {
        try {
            Message message = this.senderSession.createMessage();
            message.setBooleanProperty("prop", true);
            message.getShortProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBoolean2Byte() {
        try {
            Message message = this.senderSession.createMessage();
            message.setBooleanProperty("prop", true);
            message.getByteProperty("prop");
            MessagePropertyConversionTest.fail((String)"\ufffd3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBoolean2Boolean() {
        try {
            Message message = this.senderSession.createMessage();
            message.setBooleanProperty("prop", true);
            MessagePropertyConversionTest.assertEquals((boolean)true, (boolean)message.getBooleanProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public static Test suite() {
        return new TestSuite(MessagePropertyConversionTest.class);
    }

    public MessagePropertyConversionTest(String name) {
        super(name);
    }
}

