/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.serviceref;

import java.io.File;
import java.lang.reflect.AnnotatedElement;
import java.net.MalformedURLException;
import java.net.URL;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.rpc.Service;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.URLLoaderAdapter;
import org.jboss.wsf.framework.serviceref.ServiceRefObjectFactory;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.WSFException;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefBinder;
import org.jboss.wsf.spi.serviceref.ServiceRefBinderFactory;
import org.jboss.wsf.spi.serviceref.ServiceRefElement;
import org.jboss.wsf.spi.serviceref.ServiceRefHandler;
import org.jboss.wsf.spi.serviceref.ServiceRefMetaData;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class DefaultServiceRefHandler
implements ServiceRefHandler {
    private static Logger log = Logger.getLogger(DefaultServiceRefHandler.class);
    private ServiceRefObjectFactory objectFactory = new ServiceRefObjectFactory();

    private ServiceRefBinder getJaxrpcBinder() {
        SPIProvider sPIProvider = SPIProviderResolver.getInstance().getProvider();
        return ((ServiceRefBinderFactory)sPIProvider.getSPI(ServiceRefBinderFactory.class)).newServiceRefBinder(ServiceRefHandler.Type.JAXRPC);
    }

    private ServiceRefBinder getJaxwsBinder() {
        SPIProvider sPIProvider = SPIProviderResolver.getInstance().getProvider();
        return ((ServiceRefBinderFactory)sPIProvider.getSPI(ServiceRefBinderFactory.class)).newServiceRefBinder(ServiceRefHandler.Type.JAXWS);
    }

    public ServiceRefMetaData newServiceRefMetaData() {
        return new UnifiedServiceRefMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindServiceRef(Context context, String string, UnifiedVirtualFile unifiedVirtualFile, ClassLoader classLoader, ServiceRefMetaData serviceRefMetaData) throws NamingException {
        String string2;
        URLLoaderAdapter uRLLoaderAdapter;
        Object object;
        if (serviceRefMetaData.isProcessed()) {
            log.debug((Object)("Attempt to rebind the service-ref: " + serviceRefMetaData.getServiceRefName()));
            return;
        }
        if (unifiedVirtualFile instanceof URLLoaderAdapter && "file".equals(((URL)(object = (uRLLoaderAdapter = (URLLoaderAdapter)unifiedVirtualFile).toURL())).getProtocol()) && ((URL)object).getFile().endsWith(".war") && !new File(string2 = ((URL)object).getFile()).exists()) {
            File file = new File(string2 = string2.substring(0, string2.indexOf(".war")) + "-exp.war");
            if (!file.exists()) {
                throw new WSFException("Failed to bind service-ref, the deployment root expandedDirectory doesn't exist: " + string2);
            }
            try {
                unifiedVirtualFile = new URLLoaderAdapter(file.toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        uRLLoaderAdapter = (UnifiedServiceRefMetaData)serviceRefMetaData;
        uRLLoaderAdapter.setVfsRoot(unifiedVirtualFile);
        try {
            if (this.getServiceRefType((UnifiedServiceRefMetaData)uRLLoaderAdapter, classLoader) == ServiceRefHandler.Type.JAXRPC) {
                this.getJaxrpcBinder().setupServiceRef(context, string, null, (UnifiedServiceRefMetaData)uRLLoaderAdapter, classLoader);
            } else {
                object = (AnnotatedElement)serviceRefMetaData.getAnnotatedElement();
                this.getJaxwsBinder().setupServiceRef(context, string, (AnnotatedElement)object, (UnifiedServiceRefMetaData)uRLLoaderAdapter, classLoader);
            }
        }
        finally {
            serviceRefMetaData.setProcessed(true);
        }
    }

    public Object newChild(ServiceRefElement serviceRefElement, UnmarshallingContext unmarshallingContext, String string, String string2, Attributes attributes) {
        return this.objectFactory.newChild(serviceRefElement, unmarshallingContext, string, string2, attributes);
    }

    public void setValue(ServiceRefElement serviceRefElement, UnmarshallingContext unmarshallingContext, String string, String string2, String string3) {
        this.objectFactory.setValue(serviceRefElement, unmarshallingContext, string, string2, string3);
    }

    private ServiceRefHandler.Type getServiceRefType(UnifiedServiceRefMetaData unifiedServiceRefMetaData, ClassLoader classLoader) throws NamingException {
        String string = unifiedServiceRefMetaData.getServiceRefType();
        if (string != null || unifiedServiceRefMetaData.getAnnotatedElement() != null) {
            return ServiceRefHandler.Type.JAXWS;
        }
        if (unifiedServiceRefMetaData.getMappingFile() != null) {
            return ServiceRefHandler.Type.JAXRPC;
        }
        String string2 = unifiedServiceRefMetaData.getServiceInterface();
        if (string2 == null) {
            throw new IllegalStateException("<service-interface> cannot be null");
        }
        if (string2.equals("javax.xml.rpc.Service")) {
            return ServiceRefHandler.Type.JAXRPC;
        }
        try {
            Class<?> clazz = classLoader.loadClass(string2);
            if (javax.xml.ws.Service.class.isAssignableFrom(clazz)) {
                return ServiceRefHandler.Type.JAXWS;
            }
            if (Service.class.isAssignableFrom(clazz)) {
                return ServiceRefHandler.Type.JAXRPC;
            }
            throw new IllegalStateException("Illegal service interface: " + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Cannot load <service-interface>: " + string2);
        }
    }
}

