/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.management;

import java.util.Date;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointMetrics;

public class EndpointMetricsImpl
implements EndpointMetrics {
    private Endpoint endpoint;
    private Date startTime;
    private Date stopTime;
    private long requestCount;
    private long responseCount;
    private long faultCount;
    private long maxProcessingTime;
    private long minProcessingTime;
    private long avgProcessingTime;
    private long totalProcessingTime;

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void start() {
        this.startTime = new Date();
        this.stopTime = null;
        this.requestCount = 0L;
        this.responseCount = 0L;
        this.faultCount = 0L;
        this.maxProcessingTime = 0L;
        this.minProcessingTime = 0L;
        this.avgProcessingTime = 0L;
        this.totalProcessingTime = 0L;
    }

    public void stop() {
        this.stopTime = new Date();
    }

    public long processRequestMessage() {
        ++this.requestCount;
        return System.currentTimeMillis();
    }

    public void processResponseMessage(long l) {
        ++this.responseCount;
        this.processAnyMessage(l);
    }

    public void processFaultMessage(long l) {
        ++this.faultCount;
        this.processAnyMessage(l);
    }

    private void processAnyMessage(long l) {
        if (l > 0L) {
            long l2 = System.currentTimeMillis() - l;
            if (this.minProcessingTime == 0L) {
                this.minProcessingTime = l2;
            }
            this.maxProcessingTime = Math.max(this.maxProcessingTime, l2);
            this.minProcessingTime = Math.min(this.minProcessingTime, l2);
            this.totalProcessingTime += l2;
            this.avgProcessingTime = this.totalProcessingTime / (this.responseCount + this.faultCount);
        }
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getStopTime() {
        return this.stopTime;
    }

    public long getMinProcessingTime() {
        return this.minProcessingTime;
    }

    public long getMaxProcessingTime() {
        return this.maxProcessingTime;
    }

    public long getAverageProcessingTime() {
        return this.avgProcessingTime;
    }

    public long getTotalProcessingTime() {
        return this.totalProcessingTime;
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public long getFaultCount() {
        return this.faultCount;
    }

    public long getResponseCount() {
        return this.responseCount;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("\nEndpoint Metrics: " + this.endpoint.getName());
        stringBuilder.append("\n  startTime=" + this.startTime);
        stringBuilder.append("\n  stopTime=" + this.stopTime);
        stringBuilder.append("\n  requestCount=" + this.requestCount);
        stringBuilder.append("\n  responseCount=" + this.responseCount);
        stringBuilder.append("\n  faultCount=" + this.faultCount);
        stringBuilder.append("\n  maxProcessingTime=" + this.maxProcessingTime);
        stringBuilder.append("\n  minProcessingTime=" + this.minProcessingTime);
        stringBuilder.append("\n  avgProcessingTime=" + this.avgProcessingTime);
        stringBuilder.append("\n  totalProcessingTime=" + this.totalProcessingTime);
        return stringBuilder.toString();
    }
}

