/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;

public class EndpointAddressDeploymentAspect
extends DeploymentAspect {
    public void create(Deployment deployment) {
        String string = deployment.getService().getContextRoot();
        if (string == null) {
            throw new IllegalStateException("Cannot obtain context root");
        }
        SPIProvider sPIProvider = SPIProviderResolver.getInstance().getProvider();
        ServerConfigFactory serverConfigFactory = (ServerConfigFactory)sPIProvider.getSPI(ServerConfigFactory.class);
        ServerConfig serverConfig = serverConfigFactory.getServerConfig();
        String string2 = serverConfig.getWebServiceHost();
        int n = serverConfig.getWebServicePort();
        String string3 = string2 + (n > 0 ? ":" + n : "");
        for (Endpoint endpoint : deployment.getService().getEndpoints()) {
            String string4 = endpoint.getURLPattern();
            if (string4 == null) {
                throw new IllegalStateException("Cannot obtain url pattern");
            }
            if (string4.endsWith("/*")) {
                string4 = string4.substring(0, string4.length() - 2);
            }
            endpoint.setAddress("http://" + string3 + string + string4);
        }
    }
}

