/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.DeploymentAspectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentAspectInstaller {
    private static final Logger log = Logger.getLogger(DeploymentAspectInstaller.class);
    private DeploymentAspectManager manager;
    private Set<DeploymentAspect> aspects;
    private boolean sortAspectsOnCreate;
    private Set<String> parentProvidedConditions = new HashSet<String>();

    public void setManager(DeploymentAspectManager deploymentAspectManager) {
        this.manager = deploymentAspectManager;
    }

    public void setAspects(Set<DeploymentAspect> set) {
        this.aspects = set;
    }

    public void setSortAspectsOnCreate(boolean bl) {
        this.sortAspectsOnCreate = bl;
    }

    public void create() {
        ArrayList<DeploymentAspect> arrayList = new ArrayList<DeploymentAspect>();
        arrayList.addAll(this.manager.getDeploymentAspects());
        arrayList.addAll(this.aspects);
        ArrayList<DeploymentAspect> arrayList2 = arrayList;
        if (this.sortAspectsOnCreate) {
            Object object;
            Object object22;
            if (this.manager.getParent() != null) {
                for (Object object22 : this.manager.getParent().getDeploymentAspects()) {
                    this.parentProvidedConditions.addAll(object22.getProvidesAsSet());
                }
            }
            arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList(arrayList);
            object22 = arrayList3.iterator();
            while (object22.hasNext()) {
                object = (DeploymentAspect)object22.next();
                if (object.getRequires() != null && !this.parentProvidedConditions.containsAll(object.getRequiresAsSet())) continue;
                arrayList2.add((DeploymentAspect)object);
                object22.remove();
            }
            object22 = arrayList3.iterator();
            while (object22.hasNext()) {
                object = (DeploymentAspect)object22.next();
                int n = this.getAspectIndex(arrayList2, (DeploymentAspect)object);
                if (n == -1) continue;
                arrayList2.add(n, (DeploymentAspect)object);
                object22.remove();
                object22 = arrayList3.iterator();
            }
            object22 = arrayList3.iterator();
            while (object22.hasNext()) {
                object = (DeploymentAspect)object22.next();
                if (!"LAST_DEPLOYMENT_ASPECT".equals(object.getRequires())) continue;
                arrayList2.add((DeploymentAspect)object);
                object22.remove();
            }
            if (arrayList3.size() != 0) {
                this.throwSortException(arrayList2, arrayList3);
            }
            for (DeploymentAspect deploymentAspect : arrayList2) {
                log.debug((Object)(this.manager.getName() + ": " + deploymentAspect));
            }
        }
        this.manager.setDeploymentAspects(arrayList2);
    }

    private void throwSortException(List<DeploymentAspect> list, List<DeploymentAspect> list2) {
        Object object;
        HashSet hashSet = new HashSet();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            hashSet.addAll(object.getProvidesAsSet());
        }
        String string = "Cannot add deployment aspect(s)";
        object = new StringBuilder(string);
        if (this.manager.getParent() != null) {
            ((StringBuilder)object).append("\n" + this.manager.getParent().getName() + " provides: " + this.parentProvidedConditions);
        }
        ((StringBuilder)object).append("\n" + this.manager.getName() + " provides: " + hashSet);
        for (DeploymentAspect deploymentAspect : list2) {
            ((StringBuilder)object).append("\n   " + deploymentAspect.getClass().getName() + ", requires: " + deploymentAspect.getRequires());
        }
        log.error(object);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    private int getAspectIndex(List<DeploymentAspect> list, DeploymentAspect deploymentAspect) {
        int n = -1;
        HashSet<String> hashSet = new HashSet<String>(this.parentProvidedConditions);
        for (int i = 0; i < list.size(); ++i) {
            DeploymentAspect deploymentAspect2 = list.get(i);
            hashSet.addAll(deploymentAspect2.getProvidesAsSet());
            if (!hashSet.containsAll(deploymentAspect.getRequiresAsSet())) continue;
            n = i + 1;
            break;
        }
        return n;
    }
}

