/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.wsf.spi.binding.BindingCustomization;
import org.jboss.wsf.spi.deployment.AbstractExtensible;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.LifecycleHandler;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;
import org.jboss.wsf.spi.invocation.InvocationHandler;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointMetrics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEndpoint
extends AbstractExtensible
implements Endpoint {
    private Service service;
    private ObjectName name;
    private String shortName;
    private String urlPattern;
    private String targetBean;
    private Endpoint.EndpointState state;
    private RequestHandler requestHandler;
    private InvocationHandler invocationHandler;
    private LifecycleHandler lifecycleHandler;
    private EndpointMetrics metrics;
    private List<BindingCustomization> bindingCustomizsations = new ArrayList<BindingCustomization>();
    private String address;

    DefaultEndpoint(String string) {
        this.targetBean = string;
        this.state = Endpoint.EndpointState.UNDEFINED;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.assertEndpointSetterAccess();
        this.service = service;
    }

    public String getTargetBeanName() {
        return this.targetBean;
    }

    public void setTargetBeanName(String string) {
        this.assertEndpointSetterAccess();
        this.targetBean = string;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public Class getTargetBeanClass() {
        Class<?> clazz;
        if (this.targetBean == null) {
            throw new IllegalStateException("Target bean not set");
        }
        ClassLoader classLoader = this.service.getDeployment().getRuntimeClassLoader();
        if (classLoader == null) {
            classLoader = this.service.getDeployment().getInitialClassLoader();
        }
        if (classLoader == null) {
            throw new IllegalStateException("Deployment classloader not set");
        }
        try {
            clazz = classLoader.loadClass(this.targetBean);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WSFDeploymentException((Throwable)classNotFoundException);
        }
        return clazz;
    }

    public ObjectName getName() {
        return this.name;
    }

    public void setName(ObjectName objectName) {
        this.assertEndpointSetterAccess();
        this.name = objectName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String string) {
        this.assertEndpointSetterAccess();
        this.shortName = string;
    }

    public String getURLPattern() {
        return this.urlPattern;
    }

    public void setURLPattern(String string) {
        this.assertEndpointSetterAccess();
        this.urlPattern = string;
    }

    public Endpoint.EndpointState getState() {
        return this.state;
    }

    public void setState(Endpoint.EndpointState endpointState) {
        this.state = endpointState;
    }

    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(RequestHandler requestHandler) {
        this.assertEndpointSetterAccess();
        this.requestHandler = requestHandler;
    }

    public LifecycleHandler getLifecycleHandler() {
        return this.lifecycleHandler;
    }

    public void setLifecycleHandler(LifecycleHandler lifecycleHandler) {
        this.assertEndpointSetterAccess();
        this.lifecycleHandler = lifecycleHandler;
    }

    public InvocationHandler getInvocationHandler() {
        return this.invocationHandler;
    }

    public void setInvocationHandler(InvocationHandler invocationHandler) {
        this.assertEndpointSetterAccess();
        this.invocationHandler = invocationHandler;
    }

    public EndpointMetrics getEndpointMetrics() {
        return this.metrics;
    }

    public void setEndpointMetrics(EndpointMetrics endpointMetrics) {
        this.assertEndpointSetterAccess();
        endpointMetrics.setEndpoint((Endpoint)this);
        this.metrics = endpointMetrics;
    }

    public <T> T addAttachment(Class<T> clazz, Object object) {
        this.assertEndpointSetterAccess();
        return (T)super.addAttachment(clazz, object);
    }

    public <T> T removeAttachment(Class<T> clazz) {
        this.assertEndpointSetterAccess();
        return (T)super.removeAttachment(clazz);
    }

    public void removeProperty(String string) {
        this.assertEndpointSetterAccess();
        super.removeProperty(string);
    }

    public void setProperty(String string, Object object) {
        this.assertEndpointSetterAccess();
        super.setProperty(string, object);
    }

    private void assertEndpointSetterAccess() {
        if (this.state == Endpoint.EndpointState.STARTED) {
            throw new IllegalStateException("Cannot modify endpoint properties in state: " + this.state);
        }
    }
}

