/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.MBeanProxyInstance;
import org.jboss.mx.util.MBeanServerLocator;

public class MBeanProxyExt
implements InvocationHandler,
MBeanProxyInstance {
    private final MBeanServer server;
    private final ObjectName name;
    private final HashMap attributeMap = new HashMap();
    private boolean inited = false;
    private static final Object[] EMPTY_ARGS = new Object[0];

    MBeanProxyExt(ObjectName name, MBeanServer server, boolean lazyInit) {
        this.name = name;
        this.server = server;
        if (!lazyInit) {
            this.init();
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object retType;
        String attrName;
        MBeanAttributeInfo info;
        Class<?> type = method.getDeclaringClass();
        if (type == MBeanProxyInstance.class || type == Object.class) {
            return method.invoke((Object)this, args);
        }
        String methodName = method.getName();
        if (methodName.startsWith("get") && args == null) {
            if (!this.inited) {
                this.init();
            }
            if ((info = (MBeanAttributeInfo)this.attributeMap.get(attrName = methodName.substring(3))) != null && ((String)(retType = method.getReturnType().getName())).equals(info.getType())) {
                try {
                    return this.server.getAttribute(this.name, attrName);
                }
                catch (Exception e) {
                    throw JMXExceptionDecoder.decode(e);
                }
            }
        } else if (methodName.startsWith("is") && args == null) {
            if (!this.inited) {
                this.init();
            }
            if ((info = (MBeanAttributeInfo)this.attributeMap.get(attrName = methodName.substring(2))) != null && info.isIs() && ((retType = method.getReturnType()).equals(Boolean.class) || retType.equals(Boolean.TYPE))) {
                try {
                    return this.server.getAttribute(this.name, attrName);
                }
                catch (Exception e) {
                    throw JMXExceptionDecoder.decode(e);
                }
            }
        } else if (methodName.startsWith("set") && args != null && args.length == 1) {
            if (!this.inited) {
                this.init();
            }
            if ((info = (MBeanAttributeInfo)this.attributeMap.get(attrName = methodName.substring(3))) != null && method.getReturnType() == Void.TYPE) {
                try {
                    this.server.setAttribute(this.name, new Attribute(attrName, args[0]));
                    return null;
                }
                catch (Exception e) {
                    throw JMXExceptionDecoder.decode(e);
                }
            }
        }
        Class<?>[] types = method.getParameterTypes();
        String[] sig = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            sig[i] = types[i].getName();
        }
        try {
            return this.server.invoke(this.name, methodName, args == null ? EMPTY_ARGS : args, sig);
        }
        catch (Exception e) {
            throw JMXExceptionDecoder.decode(e);
        }
    }

    public final ObjectName getMBeanProxyObjectName() {
        return this.name;
    }

    public final MBeanServer getMBeanProxyMBeanServer() {
        return this.server;
    }

    public boolean equals(Object that) {
        MBeanProxyInstance proxy;
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        return that instanceof MBeanProxyInstance && this.name.equals((proxy = (MBeanProxyInstance)that).getMBeanProxyObjectName()) && this.server.equals(proxy.getMBeanProxyMBeanServer());
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.server.hashCode();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(128);
        sbuf.append("MBeanProxyExt[").append(this.name.toString()).append(']');
        return sbuf.toString();
    }

    public static Object create(Class intf, String name) throws MalformedObjectNameException {
        return MBeanProxyExt.create(intf, new ObjectName(name));
    }

    public static Object create(Class intf, String name, MBeanServer server) throws MalformedObjectNameException {
        return MBeanProxyExt.create(intf, new ObjectName(name), server);
    }

    public static Object create(Class intf, ObjectName name) {
        return MBeanProxyExt.create(intf, name, MBeanServerLocator.locateJBoss());
    }

    public static Object create(Class intf, ObjectName name, MBeanServer server) {
        return MBeanProxyExt.create(intf, name, server, false);
    }

    public static Object create(final Class intf, ObjectName name, MBeanServer server, boolean lazyInit) {
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                ClassLoader cl = new ClassLoader(intf.getClassLoader()){

                    public Class loadClass(String className) throws ClassNotFoundException {
                        try {
                            return super.loadClass(className);
                        }
                        catch (ClassNotFoundException e) {
                            if (className.equals((class$org$jboss$mx$util$MBeanProxyInstance == null ? (class$org$jboss$mx$util$MBeanProxyInstance = MBeanProxyExt.class$("org.jboss.mx.util.MBeanProxyInstance")) : class$org$jboss$mx$util$MBeanProxyInstance).getName())) {
                                return (class$org$jboss$mx$util$MBeanProxyInstance == null ? (class$org$jboss$mx$util$MBeanProxyInstance = MBeanProxyExt.class$("org.jboss.mx.util.MBeanProxyInstance")) : class$org$jboss$mx$util$MBeanProxyInstance).getClassLoader().loadClass(className);
                            }
                            throw e;
                        }
                    }
                };
                return cl;
            }
        };
        ClassLoader cl = (ClassLoader)AccessController.doPrivileged(action);
        Class[] ifaces = new Class[]{MBeanProxyInstance.class, intf};
        MBeanProxyExt handler = new MBeanProxyExt(name, server, lazyInit);
        return Proxy.newProxyInstance(cl, ifaces, (InvocationHandler)handler);
    }

    private synchronized void init() {
        this.inited = true;
        try {
            MBeanInfo info = this.server.getMBeanInfo(this.name);
            MBeanAttributeInfo[] attributes = info.getAttributes();
            for (int i = 0; i < attributes.length; ++i) {
                this.attributeMap.put(attributes[i].getName(), attributes[i]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating MBeanProxy: " + this.name, e);
        }
    }
}

