/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Permission;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.management.ObjectName;

public class MBeanPermission
extends Permission {
    private static final long serialVersionUID = -2416928705275160661L;
    private static ObjectName ANY_NAME;
    private static TreeSet VALID_ACTIONS;
    private transient String className;
    private transient boolean prefixMatch;
    private transient String member;
    private transient ObjectName objectName;
    private transient TreeSet actionSet;
    private String actions;

    public MBeanPermission(String name, String actions) {
        super(name);
        this.parseName(name);
        this.parseActions(actions);
    }

    public MBeanPermission(String className, String member, ObjectName objectName, String actions) {
        super((className == null ? "-" : className) + "#" + (member == null ? "-" : member) + "[" + (objectName == null ? "-" : objectName.toString()) + "]");
        this.className = className;
        this.member = member;
        this.objectName = objectName;
        this.parseActions(actions);
    }

    public String getActions() {
        return this.actions;
    }

    public int hashCode() {
        int hashCode = this.getName().hashCode();
        if (this.actionSet != null) {
            hashCode += this.actionSet.hashCode();
        }
        return hashCode;
    }

    public boolean implies(Permission p) {
        if (p == null || !(p instanceof MBeanPermission)) {
            return false;
        }
        MBeanPermission perm = (MBeanPermission)p;
        boolean implies = false;
        implies = perm.className == null ? true : (this.className == null ? false : (this.className.length() == 0 ? true : (this.prefixMatch && perm.className != null ? perm.className.startsWith(this.className) : this.className.equals(perm.className))));
        if (implies) {
            implies = perm.member == null ? true : (this.member == null ? false : (this.member.length() == 0 ? true : this.member.equals(perm.member)));
        }
        if (implies) {
            if (perm.objectName == null) {
                implies = true;
            } else if (this.objectName == null) {
                implies = false;
            } else {
                boolean bl = implies = this.objectName == perm.objectName || this.objectName.apply(perm.objectName);
                if (!implies && perm.objectName.isPattern()) {
                    implies = this.objectName.equals(perm.objectName);
                }
            }
        }
        if (this.actionSet != null && implies) {
            implies = perm.actionSet != null && this.actionSet.containsAll(perm.actionSet);
        }
        return implies;
    }

    public boolean equals(Object p) {
        if (p == null || !(p instanceof MBeanPermission)) {
            return false;
        }
        MBeanPermission perm = (MBeanPermission)p;
        boolean equals = this.getName().equals(perm.getName());
        if (equals) {
            boolean bl = equals = this.actionSet == perm.actionSet;
            if (!equals && this.actionSet != null) {
                equals = this.actionSet.equals(perm.actionSet);
            }
        }
        return equals;
    }

    private void parseName(String name) throws IllegalArgumentException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name must not be empty or null");
        }
        StringTokenizer tokenizer = new StringTokenizer(name, "#[]", true);
        boolean inMember = false;
        boolean inObjectName = false;
        this.className = tokenizer.nextToken();
        if (this.className.equals("#")) {
            this.className = "";
            inMember = true;
        } else if (this.className.equals("[")) {
            this.className = "";
            inObjectName = true;
        } else if (this.className.equals("*")) {
            this.className = "";
        } else if (this.className.equals("-")) {
            this.className = null;
        } else if (this.className.endsWith(".*")) {
            this.className = this.className.substring(0, this.className.length() - 2);
            this.prefixMatch = true;
        }
        this.member = "";
        if (!inObjectName) {
            if (inMember) {
                if (tokenizer.hasMoreTokens()) {
                    this.member = tokenizer.nextToken();
                    if (this.member.equals("[")) {
                        inObjectName = true;
                        this.member = "";
                    } else if (this.member.equals("*")) {
                        this.member = "";
                    } else if (this.member.equals("-")) {
                        this.member = null;
                    }
                }
            } else if (tokenizer.hasMoreTokens()) {
                this.member = tokenizer.nextToken();
                if (this.member.equals("#")) {
                    if (tokenizer.hasMoreTokens()) {
                        this.member = tokenizer.nextToken();
                        if (this.member.equals("[")) {
                            inObjectName = true;
                            this.member = "";
                        } else if (this.member.equals("*")) {
                            this.member = "";
                        } else if (this.member.equals("-")) {
                            this.member = null;
                        }
                    } else {
                        this.member = "";
                    }
                } else {
                    inObjectName = true;
                }
            }
        }
        if (ANY_NAME == null) {
            try {
                ANY_NAME = new ObjectName("*:*");
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not create ObjectName(*:*)");
            }
        }
        this.objectName = ANY_NAME;
        if (!inObjectName && tokenizer.hasMoreTokens()) {
            inObjectName = true;
            tokenizer.nextToken();
        }
        if (inObjectName) {
            String token = tokenizer.nextToken("]");
            try {
                this.objectName = token.equals("-") ? null : (token.equals("]") ? ANY_NAME : new ObjectName(token));
            }
            catch (Exception e) {
                IllegalArgumentException ex = new IllegalArgumentException("Invalid objectName");
                ex.initCause(e);
                throw ex;
            }
        }
    }

    private void parseActions(String actions) throws IllegalArgumentException {
        if (actions == null || actions.length() == 0) {
            throw new IllegalArgumentException("actions must not be empty or null");
        }
        if (actions.equals("*")) {
            this.actionSet = null;
            this.actions = "*";
        } else {
            this.actionSet = new TreeSet();
            StringTokenizer tokenizer = new StringTokenizer(actions, ", ");
            while (tokenizer.hasMoreTokens()) {
                String action = tokenizer.nextToken();
                if (!VALID_ACTIONS.contains(action)) {
                    throw new IllegalArgumentException(action + " is not one of: " + VALID_ACTIONS);
                }
                this.actionSet.add(action);
            }
            if (this.actionSet.contains("queryMBeans")) {
                this.actionSet.add("queryNames");
            }
            StringBuffer tmp = new StringBuffer();
            Iterator iter = this.actionSet.iterator();
            while (iter.hasNext()) {
                tmp.append(iter.next());
                tmp.append(',');
            }
            tmp.setLength(tmp.length() - 1);
            this.actions = tmp.toString();
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.parseName(this.getName());
        this.parseActions(this.getActions());
    }

    static {
        VALID_ACTIONS = new TreeSet();
        VALID_ACTIONS.add("addNotificationListener");
        VALID_ACTIONS.add("getAttribute");
        VALID_ACTIONS.add("getClassLoader");
        VALID_ACTIONS.add("getClassLoaderFor");
        VALID_ACTIONS.add("getClassLoaderRepository");
        VALID_ACTIONS.add("getDomains");
        VALID_ACTIONS.add("getMBeanInfo");
        VALID_ACTIONS.add("getObjectInstance");
        VALID_ACTIONS.add("instantiate");
        VALID_ACTIONS.add("invoke");
        VALID_ACTIONS.add("isInstanceOf");
        VALID_ACTIONS.add("queryMBeans");
        VALID_ACTIONS.add("queryNames");
        VALID_ACTIONS.add("registerMBean");
        VALID_ACTIONS.add("removeNotificationListener");
        VALID_ACTIONS.add("setAttribute");
        VALID_ACTIONS.add("unregisterMBean");
    }
}

