/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.mapper;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.mapper.AbstractDecoratorMapper;
import com.opensymphony.module.sitemesh.mapper.ConfigLoader;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class ConfigDecoratorMapper
extends AbstractDecoratorMapper {
    private ConfigLoader configLoader = null;

    public void init(Config config, Properties properties, DecoratorMapper decoratorMapper) throws InstantiationException {
        super.init(config, properties, decoratorMapper);
        try {
            String string = properties.getProperty("config", "/WEB-INF/decorators.xml");
            this.configLoader = new ConfigLoader(string, config);
        }
        catch (Exception exception) {
            throw new InstantiationException(exception.toString());
        }
    }

    public Decorator getDecorator(HttpServletRequest httpServletRequest, Page page) {
        Decorator decorator = null;
        try {
            String string;
            String string2 = httpServletRequest.getServletPath();
            if (string2 == null) {
                string = httpServletRequest.getRequestURI();
                string2 = httpServletRequest.getPathInfo() != null ? string.substring(0, string.indexOf(httpServletRequest.getPathInfo())) : string;
            }
            string = this.configLoader.getMappedName(string2);
            decorator = this.getNamedDecorator(httpServletRequest, string);
        }
        catch (ServletException servletException) {
            // empty catch block
        }
        return decorator == null ? super.getDecorator(httpServletRequest, page) : decorator;
    }

    public Decorator getNamedDecorator(HttpServletRequest httpServletRequest, String string) {
        Decorator decorator = null;
        try {
            decorator = this.configLoader.getDecoratorByName(string);
        }
        catch (ServletException servletException) {
            // empty catch block
        }
        return decorator == null ? super.getNamedDecorator(httpServletRequest, string) : decorator;
    }
}

