/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.factory;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.factory.BaseFactory;
import com.opensymphony.module.sitemesh.util.Container;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultFactory
extends BaseFactory {
    String configFileName = "/WEB-INF/sitemesh.xml";
    File configFile;
    long configLastModified;

    public DefaultFactory(Config config) {
        super(config);
        String string = config.getServletContext().getRealPath(this.configFileName);
        if (string != null) {
            this.configFile = new File(string);
        }
        this.loadConfig();
    }

    public DecoratorMapper getDecoratorMapper() {
        this.refresh();
        return super.getDecoratorMapper();
    }

    public PageParser getPageParser(String string) {
        this.refresh();
        return super.getPageParser(string);
    }

    public boolean shouldParsePage(String string) {
        this.refresh();
        return super.shouldParsePage(string);
    }

    private synchronized void loadConfig() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputStream inputStream = null;
            if (this.configFile == null) {
                inputStream = this.config.getServletContext().getResourceAsStream(this.configFileName);
            } else if (this.configFile.exists() && this.configFile.canRead()) {
                inputStream = this.configFile.toURL().openStream();
            }
            if (inputStream == null) {
                inputStream = Container.get() == 4 ? this.getClass().getClassLoader().getResourceAsStream("com/opensymphony/module/sitemesh/factory/sitemesh-default.xml") : Thread.currentThread().getContextClassLoader().getResourceAsStream("com/opensymphony/module/sitemesh/factory/sitemesh-default.xml");
            }
            Document document = documentBuilder.parse(inputStream);
            Element element = document.getDocumentElement();
            if (this.configFile != null) {
                this.configLastModified = this.configFile.lastModified();
            }
            if (!"sitemesh".equalsIgnoreCase(element.getTagName())) {
                Factory.report("Root element of sitemesh configuration file not <sitemesh>", null);
            }
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                if (nodeList.item(n) instanceof Element) {
                    Element element2 = (Element)nodeList.item(n);
                    NodeList nodeList2 = element2.getChildNodes();
                    if ("page-parsers".equalsIgnoreCase(element2.getTagName())) {
                        this.loadPageParsers(nodeList2);
                    } else if ("decorator-mappers".equalsIgnoreCase(element2.getTagName())) {
                        this.loadDecoratorMappers(nodeList2);
                    }
                }
                ++n;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Factory.report("Could not get XML parser", parserConfigurationException);
        }
        catch (IOException iOException) {
            Factory.report("Could not read config file : " + this.configFileName, iOException);
        }
        catch (SAXException sAXException) {
            Factory.report("Could not parse config file : " + this.configFileName, sAXException);
        }
    }

    private void loadPageParsers(NodeList nodeList) {
        this.clearParserMappings();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element;
            if (nodeList.item(n) instanceof Element && "parser".equalsIgnoreCase((element = (Element)nodeList.item(n)).getTagName())) {
                String string = element.getAttribute("class");
                String string2 = element.getAttribute("content-type");
                this.mapParser(string2, string);
            }
            ++n;
        }
    }

    private void loadDecoratorMappers(NodeList nodeList) {
        this.clearDecoratorMappers();
        Properties properties = new Properties();
        this.pushDecoratorMapper("com.opensymphony.module.sitemesh.mapper.NullDecoratorMapper", properties);
        int n = nodeList.getLength() - 1;
        while (n > 0) {
            Element element;
            if (nodeList.item(n) instanceof Element && "mapper".equalsIgnoreCase((element = (Element)nodeList.item(n)).getTagName())) {
                String string = element.getAttribute("class");
                Properties properties2 = new Properties();
                NodeList nodeList2 = element.getChildNodes();
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    Element element2;
                    if (nodeList2.item(n2) instanceof Element && "param".equalsIgnoreCase((element2 = (Element)nodeList2.item(n2)).getTagName())) {
                        ((Hashtable)properties2).put(element2.getAttribute("name"), element2.getAttribute("value"));
                    }
                    ++n2;
                }
                this.pushDecoratorMapper(string, properties2);
            }
            --n;
        }
        this.pushDecoratorMapper("com.opensymphony.module.sitemesh.mapper.InlineDecoratorMapper", properties);
    }

    private void refresh() {
        if (this.configFile != null && this.configLastModified != this.configFile.lastModified()) {
            this.loadConfig();
        }
    }
}

