/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.util.graph;

import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Get;
import org.jboss.ant.types.ComponentRef;
import org.jboss.ant.types.build.Artifact;
import org.jboss.ant.types.build.Component;
import org.jboss.ant.util.graph.ComponentRefVertex;
import org.jboss.ant.util.graph.Edge;
import org.jboss.ant.util.graph.Graph;
import org.jboss.ant.util.graph.Vertex;
import org.jboss.ant.util.graph.Visitor;
import org.jboss.ant.util.graph.VisitorListener;

public class ComponentRefGraphLicenseVisitor
implements Visitor,
VisitorListener {
    private HashMap components = new HashMap();

    public void beforeVisit(Graph graph, Visitor visitor, Project project) {
        project.log("beforeVisit", 3);
    }

    public void afterVisit(Graph graph, Visitor visitor, Project project) throws BuildException {
        project.log("afterVisit", 3);
        String baseDir = project.getProperty("basedir");
        File licensesDir = project.getProperty("external.project") != null ? new File(baseDir, "thirdparty/licenses") : new File(baseDir, "../thirdparty/licenses");
        licensesDir.mkdirs();
        project.log("Writing license info to dir: " + licensesDir);
        File licenseInfo = new File(licensesDir, "thirdparty-licenses.xml");
        HashSet<String> licenses = new HashSet<String>();
        try {
            FileWriter fw = new FileWriter(licenseInfo);
            fw.write("<thirdparty-licenses>");
            Iterator<Object> iter = this.components.values().iterator();
            while (iter.hasNext()) {
                Component comp = (Component)((Object)iter.next());
                Hashtable attributes = comp.getAttributes();
                project.log("Component, name: " + comp.getName() + ", attrs: " + attributes);
                fw.write("\t<module name='");
                fw.write(comp.getName());
                fw.write("'\n\t\tlicenseType='");
                String license = (String)attributes.get("licensetype");
                if (license == null) {
                    project.log("No licenseType for component: " + comp.getName(), 0);
                } else {
                    licenses.add(license);
                }
                fw.write(license);
                fw.write("'\n\t\tversion='");
                fw.write(comp.getVersion().toString());
                fw.write("'\n\t\tprojectHome='");
                fw.write("" + attributes.get("projecthome"));
                fw.write("'\n\t\tdescription='");
                String description = comp.getDescription();
                fw.write(description == null ? "no description" : description);
                fw.write("'>\n");
                Vector artifacts = comp.getArtifacts();
                int n = 0;
                while (n < artifacts.size()) {
                    Artifact artifact = (Artifact)((Object)artifacts.get(n));
                    fw.write("\t\t<jar name='");
                    fw.write(artifact.getId());
                    fw.write("' />\n");
                    ++n;
                }
                fw.write("\t</module>\n");
            }
            fw.write("</thirdparty-licenses>");
            fw.close();
            URL licensesURL = new URL("http://repository.jboss.com/licenses/");
            iter = licenses.iterator();
            Target target = new Target();
            target.setName("getLicenses");
            target.setProject(project);
            while (iter.hasNext()) {
                Get get = new Get();
                String type = (String)iter.next();
                File licenseFile = new File(licensesDir, String.valueOf(type) + ".txt");
                URL licenseSrc = new URL(licensesURL, String.valueOf(type) + ".txt");
                get.setTaskName("get-" + type);
                get.setSrc(licenseSrc);
                get.setDest(licenseFile);
                get.setUseTimestamp(true);
                get.setIgnoreErrors(false);
                get.setVerbose(true);
                get.setProject(project);
                target.addTask((Task)get);
            }
            Get getInfo = new Get();
            File licenseFile = new File(licensesDir, "license-info.xml");
            URL licenseSrc = new URL(licensesURL, "license-info.xml");
            getInfo.setTaskName("get-license-info.xml");
            getInfo.setSrc(licenseSrc);
            getInfo.setDest(licenseFile);
            getInfo.setUseTimestamp(true);
            getInfo.setIgnoreErrors(true);
            getInfo.setVerbose(true);
            getInfo.setProject(project);
            target.addTask((Task)getInfo);
            project.addTarget(target);
            project.executeTarget("getLicenses");
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void visit(Graph g, Vertex v) {
        if (v instanceof ComponentRefVertex) {
            ComponentRefVertex currentVertex = (ComponentRefVertex)v;
            ComponentRef compRef = currentVertex.getComponentRef();
            Component comp = compRef.getComponent();
            this.components.put(comp.getName(), comp);
        }
    }

    public void visit(Graph g, Vertex v, Edge e) {
    }
}

