/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tools.ant.BuildException;
import org.jboss.ant.types.AbstractDataType;
import org.jboss.ant.util.AttributeException;

public abstract class AttributeUtil {
    public static String replace(Object object, String value) {
        int lastIndex = -1;
        int state = 0;
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char current = value.charAt(i);
            switch (state) {
                case 0: {
                    if (current == '@') {
                        state = 1;
                        break;
                    }
                    result.append(current);
                    lastIndex = i;
                    break;
                }
                case 1: {
                    if (current == '{') {
                        state = 2;
                        break;
                    }
                    result.append('@').append(current);
                    lastIndex = i;
                    state = 0;
                    break;
                }
                case 2: {
                    if (current != '}') break;
                    result.append(AttributeUtil.resolveAttributeAsString(object, value.substring(lastIndex + 3, i)));
                    lastIndex = i;
                    state = 0;
                }
            }
            ++i;
        }
        if (state != 0) {
            result.append(value.substring(lastIndex + 1));
        }
        return result.toString();
    }

    public static String resolveAttributeAsString(Object object, String value) {
        int len = value.length();
        if (len == 0) {
            return value;
        }
        int dot = value.indexOf(".");
        if (dot != -1) {
            String first = value.substring(0, dot);
            Object next = AttributeUtil.resolveAttribute(object, first);
            String remaining = value.substring(dot + 1);
            return AttributeUtil.resolveAttributeAsString(next, remaining);
        }
        return AttributeUtil.resolveAttribute(object, value).toString();
    }

    public static Object resolveAttribute(Object object, String value) {
        Method getter = null;
        try {
            String getterName = "get" + Character.toUpperCase(value.charAt(0));
            if (value.length() > 1) {
                getterName = getterName.concat(value.substring(1));
            }
            getter = object.getClass().getMethod(getterName, null);
        }
        catch (NoSuchMethodException e) {
            try {
                String getterName = "is" + Character.toUpperCase(value.charAt(0));
                if (value.length() > 1) {
                    getterName = getterName.concat(value.substring(1));
                }
                getter = object.getClass().getMethod(getterName, null);
            }
            catch (NoSuchMethodException e1) {
                if (object instanceof AbstractDataType) {
                    String result = ((AbstractDataType)((Object)object)).getDynamicAttribute(value);
                    if (result != null) {
                        return result;
                    }
                    throw new BuildException("Value not set '" + value + "' for " + object);
                }
                e.printStackTrace();
                throw new AttributeException("Getter not found", value, object, e);
            }
        }
        try {
            Object result = getter.invoke(object, null);
            if (result != null) {
                return result;
            }
            throw new BuildException("Value not set '" + value + "' for " + object);
        }
        catch (InvocationTargetException e) {
            throw new AttributeException("Error getting attribute", value, object, e);
        }
        catch (IllegalAccessException e) {
            throw new AttributeException("Illegal access getting attribute", value, object, e);
        }
    }

    private AttributeUtil() {
    }
}

