/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.types;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.jboss.ant.types.AbstractBuildDataType;
import org.jboss.ant.types.Export;
import org.jboss.ant.types.Includes;
import org.jboss.ant.types.Pattern;
import org.jboss.ant.types.Source;
import org.jboss.ant.types.SourceSink;
import org.jboss.ant.types.build.Component;
import org.jboss.ant.util.FileUtil;
import org.jboss.ant.util.ImportUtil;

public class Include
extends AbstractBuildDataType {
    private String input;
    private String prefix;
    private String component;
    private Vector includes = new Vector();
    private Vector excludes = new Vector();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void setInput(String input) {
        this.input = input;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public List getFiles() {
        Source source = this.resolveInput();
        return source.getOutputs();
    }

    public List getSources() {
        Source source = this.resolveInput();
        if (source instanceof Includes || source instanceof Export) {
            SourceSink sourceSink = (SourceSink)source;
            ArrayList list = new ArrayList();
            int i = 0;
            while (i < sourceSink.getSize()) {
                Include include = sourceSink.getInclude(i);
                list.addAll(include.getSources());
                ++i;
            }
            return list;
        }
        return Collections.singletonList(source);
    }

    public Vector getIncludes() {
        return this.includes;
    }

    public void addInclude(Pattern include) {
        this.includes.add(include);
    }

    public Vector getExcludes() {
        return this.excludes;
    }

    public void addExclude(Pattern exclude) {
        this.excludes.add(exclude);
    }

    public String getThirdpartyPath() {
        return this.getProject().getProperty("jbossbuild.thirdparty.dir");
    }

    public File getThirdparty() {
        return FileUtil.resolve(FileUtil.getRoot(this.getProject()), this.getThirdpartyPath());
    }

    public String getComponentInfoPath() {
        return this.getProject().getProperty("jbossbuild.component.info");
    }

    protected void doValidate() {
        this.resolveInput().validate();
    }

    protected void appendIdentity(StringBuffer buffer) {
        super.appendIdentity(buffer);
        buffer.append(" input=").append(this.input);
    }

    protected void toString(StringBuffer buffer) {
        super.toString(buffer);
        buffer.append(" input=").append(this.input);
        if (this.includes.size() > 0) {
            buffer.append(" includes=").append(this.includes);
        }
        if (this.excludes.size() > 0) {
            buffer.append(" excludes=").append(this.excludes);
        }
    }

    protected Source resolveInput() {
        if (this.component != null) {
            this.importComponent(this.component);
        }
        if (this.input == null && this.component != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.jboss.ant.types.build.Component");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Component importedComponent = (Component)this.resolve("component", this.component, clazz);
            return importedComponent.getExport();
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.jboss.ant.types.Source");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Source)this.resolve("input", this.input, clazz);
    }

    private void importComponent(String component) {
        block10: {
            String componentInfo = String.valueOf(component) + "/" + this.getComponentInfoPath();
            File componentInfoFile = FileUtil.resolve(FileUtil.getRoot(this.getProject()), componentInfo);
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Attempting to import file: " + componentInfoFile.getAbsolutePath());
                }
                ImportUtil.importFile(componentInfoFile, this.getProject());
            }
            catch (BuildException buildException) {
                if (buildException.getCause() instanceof FileNotFoundException) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Import of file failed.  Attempting to locate it in thirdparty location...");
                    }
                    componentInfoFile = FileUtil.resolve(this.getThirdparty(), componentInfo);
                    try {
                        ImportUtil.importFile(componentInfoFile, this.getProject());
                    }
                    catch (BuildException f) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Import of file from thirdpary location failed.\n  Giving up, please ensure the component is defined in top level build file and run the target synchronize.");
                        }
                        if (buildException.getCause() instanceof FileNotFoundException) {
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("Possible future implementation of retrieving the component-info from the repository could go here.");
                            }
                            throw new BuildException("Unable to locate file: " + componentInfoFile.getAbsolutePath() + "\nPlease ensure the component is defined in top level build and the target synchronize has been executed");
                        }
                        break block10;
                    }
                }
                throw buildException;
            }
        }
    }
}

