/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.tasks.build;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Mkdir;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.jboss.ant.tasks.build.BuildTask;
import org.jboss.ant.types.build.Artifact;
import org.jboss.ant.types.deployment.Deployment;
import org.jboss.ant.types.deployment.DeploymentType;
import org.jboss.ant.types.deployment.Profile;
import org.jboss.ant.util.FileUtil;

public class ReleaseDeploymentsTask
extends BuildTask {
    public void execute() {
        this.setTaskName("ReleaseDeploymentsTask");
        if (this.log.isTraceEnabled()) {
            this.log.trace("Executing: " + this.getTaskName());
        }
        if (this.getBuildInstance() != null) {
            int i = 0;
            while (i < this.getBuildInstance().getProfiles().size()) {
                Profile currentDeploymentProfile = (Profile)((Object)this.getBuildInstance().getProfiles().elementAt(i));
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Deploying Profile with id: " + currentDeploymentProfile.getId());
                }
                this.deployProfile(currentDeploymentProfile);
                ++i;
            }
        } else {
            throw new BuildException("Build instance is null, unable to complete " + this.getTaskName());
        }
    }

    private void deployProfile(Profile profile) {
        File outputDir = FileUtil.resolve(this.getBuildInstance().getReleaseDir(), profile.getOutputPath());
        int j = 0;
        while (j < profile.getDeployments().size()) {
            Deployment currentDeployment = (Deployment)((Object)profile.getDeployments().elementAt(j));
            if (this.log.isTraceEnabled()) {
                this.log.trace("Deploying deployment with artifact: " + currentDeployment.getArtifactId());
            }
            this.deployDeployment(currentDeployment, outputDir);
            ++j;
        }
        j = 0;
        while (j < profile.getDeploymentTypes().size()) {
            DeploymentType currentDeploymentType = (DeploymentType)((Object)profile.getDeploymentTypes().elementAt(j));
            this.deployDeploymentType(currentDeploymentType, outputDir);
            ++j;
        }
    }

    private void deployDeploymentType(DeploymentType deploymentType, File outputDir) {
        String version = JavaEnvUtils.getJavaVersion();
        if (!version.equalsIgnoreCase(deploymentType.getRequiredJDK()) && !deploymentType.getRequiredJDK().equalsIgnoreCase("default")) {
            return;
        }
        File typeOutputDir = FileUtil.resolve(outputDir, deploymentType.getType());
        if (this.log.isTraceEnabled()) {
            this.log.trace("Deploying deployment type: " + deploymentType.getType() + " to location " + outputDir.getAbsolutePath());
        }
        int k = 0;
        while (k < deploymentType.getDeployments().size()) {
            Deployment currentDeployment = (Deployment)((Object)deploymentType.getDeployments().elementAt(k));
            if (this.log.isTraceEnabled()) {
                this.log.trace("Deploying deployment with artifact: " + currentDeployment.getArtifactId());
            }
            this.deployDeployment(currentDeployment, typeOutputDir);
            ++k;
        }
        int j = 0;
        while (j < deploymentType.getDeploymentTypes().size()) {
            DeploymentType currentDeploymentType = (DeploymentType)((Object)deploymentType.getDeploymentTypes().elementAt(j));
            this.deployDeploymentType(currentDeploymentType, typeOutputDir);
            ++j;
        }
    }

    private void deployDeployment(Deployment deployment, File outputDir) {
        Artifact artifact = deployment.getArtifact();
        if (artifact == null) {
            throw new BuildException("Unable to resolve artifact with id: " + deployment.getArtifactId() + " while deploying");
        }
        String version = JavaEnvUtils.getJavaVersion();
        if (version.equalsIgnoreCase(deployment.getRequiredJDK()) || deployment.getRequiredJDK().equalsIgnoreCase("default")) {
            Mkdir mkdir = new Mkdir();
            mkdir.setTaskName("mkdir");
            mkdir.setProject(this.getProject());
            mkdir.setDir(outputDir);
            mkdir.execute();
            if (deployment.getExploded().equalsIgnoreCase("true")) {
                Expand expand = new Expand();
                expand.setTaskName("unzip");
                expand.setProject(this.getProject());
                expand.setDest(outputDir);
                expand.setSrc(artifact.getOutput());
                if (deployment.getOverwrite() != null) {
                    if (deployment.getOverwrite().equalsIgnoreCase("true")) {
                        expand.setOverwrite(true);
                    } else {
                        expand.setOverwrite(false);
                    }
                }
                expand.execute();
            }
            if (deployment.getExploded().equalsIgnoreCase("false")) {
                Copy copy = new Copy();
                copy.setTaskName("copy");
                copy.setProject(this.getProject());
                copy.setVerbose(true);
                if (artifact.getArtifactType().type.equalsIgnoreCase("dir")) {
                    FileSet f = new FileSet();
                    f.setDir(artifact.getOutput());
                    copy.addFileset(f);
                    if (deployment.getToName() != null) {
                        copy.setTodir(FileUtil.resolve(outputDir, deployment.getToName()));
                    } else {
                        copy.setTodir(FileUtil.resolve(outputDir, artifact.getId()));
                    }
                } else {
                    copy.setFile(artifact.getOutput());
                    if (deployment.getToName() != null) {
                        File renameFile = FileUtil.resolve(this.getBuildInstance().getReleaseDir(), deployment.getOutputPath());
                        renameFile = FileUtil.resolve(renameFile, deployment.getToName());
                        copy.setTofile(renameFile);
                    } else {
                        copy.setTofile(FileUtil.resolve(outputDir, artifact.getId()));
                    }
                }
                copy.execute();
            }
        }
    }
}

