/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.messaging.util.NamedThreadQueuedExecutor;

public class JBMExecutor
extends NamedThreadQueuedExecutor {
    private boolean needToSetClassLoader = true;

    public JBMExecutor(String name) {
        super(name);
    }

    public void execute(Runnable runnable) throws InterruptedException {
        super.execute((Runnable)new TCLRunnable(runnable));
    }

    public void clearClassLoader() throws InterruptedException {
        super.execute(new Runnable(){

            public void run() {
                JBMExecutor.this.needToSetClassLoader = true;
            }
        });
    }

    public void clearAllExceptCurrentTask() {
        try {
            while (this.queue_.poll(0L) != null) {
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    class TCLRunnable
    implements Runnable {
        private Runnable realRunnable;
        private ClassLoader tcl;

        public TCLRunnable(Runnable realRunnable) {
            if (JBMExecutor.this.needToSetClassLoader) {
                this.tcl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            this.realRunnable = realRunnable;
        }

        public void run() {
            if (JBMExecutor.this.needToSetClassLoader) {
                JBMExecutor.this.needToSetClassLoader = false;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(TCLRunnable.this.tcl);
                        return null;
                    }
                });
            }
            this.realRunnable.run();
        }
    }
}

