/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.bridge;

import java.util.Properties;
import javax.jms.Destination;
import javax.jms.Topic;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.jboss.jms.server.bridge.Bridge;
import org.jboss.jms.server.bridge.BridgeMBean;
import org.jboss.jms.server.bridge.JNDIConnectionFactoryFactory;
import org.jboss.jms.server.bridge.JNDIDestinationFactory;
import org.jboss.messaging.core.contract.MessagingComponent;
import org.jboss.system.ServiceMBeanSupport;

public class BridgeService
extends ServiceMBeanSupport
implements BridgeMBean {
    private Bridge bridge = new Bridge();
    private String sourceDestinationLookup;
    private String targetDestinationLookup;
    private ObjectName sourceProviderLoader;
    private ObjectName targetProviderLoader;

    public synchronized ObjectName getSourceProviderLoader() {
        return this.sourceProviderLoader;
    }

    public synchronized void setSourceProviderLoader(ObjectName sourceProvider) {
        if (this.bridge.isStarted()) {
            this.log.warn((Object)"Cannot set SourceProvider when bridge is started");
            return;
        }
        this.sourceProviderLoader = sourceProvider;
    }

    public synchronized ObjectName getTargetProviderLoader() {
        return this.targetProviderLoader;
    }

    public synchronized void setTargetProviderLoader(ObjectName targetProvider) {
        if (this.bridge.isStarted()) {
            this.log.warn((Object)"Cannot set TargetProvider when bridge is started");
            return;
        }
        this.targetProviderLoader = targetProvider;
    }

    public String getSourceDestinationLookup() {
        return this.sourceDestinationLookup;
    }

    public String getTargetDestinationLookup() {
        return this.targetDestinationLookup;
    }

    public void setSourceDestinationLookup(String lookup) {
        if (this.bridge.isStarted()) {
            this.log.warn((Object)"Cannot set SourceDestinationLookup when bridge is started");
            return;
        }
        this.sourceDestinationLookup = this.checkAndTrim(lookup);
    }

    public void setTargetDestinationLookup(String lookup) {
        if (this.bridge.isStarted()) {
            this.log.warn((Object)"Cannot set TargetDestinationLookup when bridge is started");
            return;
        }
        this.targetDestinationLookup = this.checkAndTrim(lookup);
    }

    public String getSourceUsername() {
        return this.bridge.getSourceUsername();
    }

    public String getSourcePassword() {
        return this.bridge.getSourcePassword();
    }

    public void setSourceUsername(String name) {
        this.bridge.setSourceUsername(name);
    }

    public void setSourcePassword(String pwd) {
        this.bridge.setSourcePassword(pwd);
    }

    public String getTargetUsername() {
        return this.bridge.getDestUsername();
    }

    public String getTargetPassword() {
        return this.bridge.getDestPassword();
    }

    public void setTargetUsername(String name) {
        this.bridge.setDestUserName(name);
    }

    public void setTargetPassword(String pwd) {
        this.bridge.setDestPassword(pwd);
    }

    public int getQualityOfServiceMode() {
        return this.bridge.getQualityOfServiceMode();
    }

    public void setQualityOfServiceMode(int mode) {
        this.bridge.setQualityOfServiceMode(mode);
    }

    public String getSelector() {
        return this.bridge.getSelector();
    }

    public void setSelector(String selector) {
        this.bridge.setSelector(selector);
    }

    public int getMaxBatchSize() {
        return this.bridge.getMaxBatchSize();
    }

    public void setMaxBatchSize(int size) {
        this.bridge.setMaxBatchSize(size);
    }

    public long getMaxBatchTime() {
        return this.bridge.getMaxBatchTime();
    }

    public void setMaxBatchTime(long time) {
        this.bridge.setMaxBatchTime(time);
    }

    public String getSubName() {
        return this.bridge.getSubName();
    }

    public void setSubName(String subname) {
        this.bridge.setSubName(subname);
    }

    public String getClientID() {
        return this.bridge.getClientID();
    }

    public void setClientID(String clientID) {
        this.bridge.setClientID(clientID);
    }

    public long getFailureRetryInterval() {
        return this.bridge.getFailureRetryInterval();
    }

    public void setFailureRetryInterval(long interval) {
        this.bridge.setFailureRetryInterval(interval);
    }

    public int getMaxRetries() {
        return this.bridge.getMaxRetries();
    }

    public void setMaxRetries(int retries) {
        this.bridge.setMaxRetries(retries);
    }

    public boolean isAddMessageIDInHeader() {
        return this.bridge.isAddMessageIDInHeader();
    }

    public void setAddMessageIDInHeader(boolean value) {
        this.bridge.setAddMessageIDInHeader(value);
    }

    public boolean isFailed() {
        return this.bridge.isFailed();
    }

    public boolean isPaused() {
        return this.bridge.isPaused();
    }

    public boolean isStarted() {
        return this.bridge.isStarted();
    }

    public MessagingComponent getInstance() {
        return this.bridge;
    }

    public void pause() throws Exception {
        this.bridge.pause();
    }

    public void resume() throws Exception {
        this.bridge.resume();
    }

    protected void startService() throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Starting bridge");
        }
        super.startService();
        if (this.sourceProviderLoader == null) {
            throw new IllegalArgumentException("sourceProvider cannot be null");
        }
        if (this.targetProviderLoader == null) {
            throw new IllegalArgumentException("targetProvider cannot be null");
        }
        if (this.sourceDestinationLookup == null) {
            throw new IllegalArgumentException("Source destination lookup cannot be null");
        }
        if (this.targetDestinationLookup == null) {
            throw new IllegalArgumentException("Target destination lookup cannot be null");
        }
        boolean sameSourceAndTarget = this.sourceProviderLoader.equals(this.targetProviderLoader);
        Properties sourceProps = (Properties)this.server.getAttribute(this.sourceProviderLoader, "Properties");
        Properties targetProps = (Properties)this.server.getAttribute(this.targetProviderLoader, "Properties");
        InitialContext icSource = new InitialContext(sourceProps);
        InitialContext icTarget = new InitialContext(targetProps);
        Destination sourceDest = (Destination)icSource.lookup(this.sourceDestinationLookup);
        Destination targetDest = (Destination)icTarget.lookup(this.targetDestinationLookup);
        String sourceFactoryRef = "QueueFactoryRef";
        if (sourceDest instanceof Topic) {
            sourceFactoryRef = "TopicFactoryRef";
        }
        String targetFactoryRef = "QueueFactoryRef";
        if (targetDest instanceof Topic) {
            targetFactoryRef = "TopicFactoryRef";
        }
        String sourceCFRef = (String)this.server.getAttribute(this.sourceProviderLoader, sourceFactoryRef);
        String targetCFRef = (String)this.server.getAttribute(this.targetProviderLoader, targetFactoryRef);
        JNDIConnectionFactoryFactory sourceCff = new JNDIConnectionFactoryFactory(sourceProps, sourceCFRef);
        JNDIConnectionFactoryFactory destCff = sameSourceAndTarget ? sourceCff : new JNDIConnectionFactoryFactory(targetProps, targetCFRef);
        this.bridge.setSourceConnectionFactoryFactory(sourceCff);
        this.bridge.setDestConnectionFactoryFactory(destCff);
        JNDIDestinationFactory sourceDestinationFactory = new JNDIDestinationFactory(sourceProps, this.sourceDestinationLookup);
        JNDIDestinationFactory targetDestinationFactory = new JNDIDestinationFactory(targetProps, this.targetDestinationLookup);
        this.bridge.setSourceDestinationFactory(sourceDestinationFactory);
        this.bridge.setTargetDestinationFactory(targetDestinationFactory);
        this.bridge.start();
        this.log.info((Object)("Started bridge " + this.getName() + ". Source: " + this.sourceDestinationLookup + " Target: " + this.targetDestinationLookup));
    }

    protected void stopService() throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Stopping bridge");
        }
        this.bridge.stop();
        this.log.info((Object)("Stopped bridge " + this.getName()));
    }

    private String checkAndTrim(String s) {
        if (s != null && "".equals(s = s.trim())) {
            s = null;
        }
        return s;
    }
}

