/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.destination;

import javax.jms.JMSException;
import javax.jms.TemporaryQueue;
import org.jboss.jms.delegate.SessionDelegate;
import org.jboss.jms.destination.JBossQueue;
import org.jboss.messaging.util.GUIDGenerator;

public class JBossTemporaryQueue
extends JBossQueue
implements TemporaryQueue {
    private static final long serialVersionUID = 4250425221695034957L;
    private transient SessionDelegate delegate;
    private boolean deleted = false;

    public JBossTemporaryQueue(SessionDelegate delegate) {
        super(GUIDGenerator.generateGUID());
        this.delegate = delegate;
    }

    public JBossTemporaryQueue(String name) {
        super(name);
    }

    public void delete() throws JMSException {
        this.deleted = true;
        if (this.delegate != null) {
            this.delegate.deleteTemporaryDestination(this);
        }
    }

    public boolean isTemporary() {
        return true;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public String toString() {
        return "JBossTemporaryQueue[" + this.name + "]";
    }
}

