/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util.asm;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.drools.asm.ClassWriter;
import org.drools.asm.Label;
import org.drools.asm.MethodVisitor;
import org.drools.asm.Opcodes;
import org.drools.asm.Type;
import org.drools.util.asm.ClassFieldInspector;
import org.drools.util.asm.FieldAccessor;
import org.drools.util.asm.FieldAccessorMap;

public class FieldAccessorGenerator {
    private static FieldAccessorGenerator INSTANCE;
    private static final String GEN_PACKAGE_PREFIX = "org.drools.fieldaccess.";
    private final Map cache = new HashMap();
    static /* synthetic */ Class class$org$drools$util$asm$FieldAccessor;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Void;

    private FieldAccessorGenerator() {
    }

    public static FieldAccessorGenerator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FieldAccessorGenerator();
        }
        return INSTANCE;
    }

    public FieldAccessorMap getInstanceFor(Class clazz) throws Exception {
        Object object = this.cache.get(clazz);
        if (object == null) {
            object = this.newInstanceFor(clazz);
            this.cache.put(clazz, object);
        }
        return (FieldAccessorMap)object;
    }

    public FieldAccessorMap newInstanceFor(Class clazz) throws Exception {
        ClassFieldInspector classFieldInspector = new ClassFieldInspector(clazz);
        Method[] methodArray = classFieldInspector.getPropertyGetters().toArray(new Method[0]);
        String string = GEN_PACKAGE_PREFIX + clazz.getName();
        byte[] byArray = AccessorClassFactory.generateClass(methodArray, clazz, string);
        ByteArrayClassLoader byteArrayClassLoader = new ByteArrayClassLoader(Thread.currentThread().getContextClassLoader());
        byteArrayClassLoader.addByteArray(string, byArray);
        FieldAccessor fieldAccessor = (FieldAccessor)byteArrayClassLoader.loadClass(string).newInstance();
        FieldAccessorMap fieldAccessorMap = new FieldAccessorMap(fieldAccessor, classFieldInspector.getFieldNames());
        return fieldAccessorMap;
    }

    static class ByteArrayClassLoader
    extends ClassLoader {
        public ByteArrayClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        public void addByteArray(String string, byte[] byArray) {
            this.defineClass(string, byArray, 0, byArray.length);
        }
    }

    static class AccessorClassFactory
    implements Opcodes {
        private static final String GET_FIELD_BY_INDEX_METHOD_NAME = "getFieldByIndex";

        AccessorClassFactory() {
        }

        private static String getShortName(Class clazz) {
            String string = clazz.getName();
            String string2 = clazz.getPackage().getName();
            return string.substring(string2.length() + 1, string.length());
        }

        public static byte[] generateClass(Method[] methodArray, Class clazz, String string) throws Exception {
            ClassWriter classWriter = new ClassWriter(true);
            string = string.replaceAll("\\.", "/");
            classWriter.visit(46, 33, string, null, "java/lang/Object", new String[]{Type.getInternalName(class$org$drools$util$asm$FieldAccessor == null ? (class$org$drools$util$asm$FieldAccessor = FieldAccessorGenerator.class$("org.drools.util.asm.FieldAccessor")) : class$org$drools$util$asm$FieldAccessor)});
            classWriter.visitSource(AccessorClassFactory.getShortName(clazz) + ".java", null);
            AccessorClassFactory.doConstructor(classWriter);
            AccessorClassFactory.doMethods(classWriter, Type.getInternalName(clazz), methodArray, clazz.isInterface());
            classWriter.visitEnd();
            return classWriter.toByteArray();
        }

        private static void doMethods(ClassWriter classWriter, String string, Method[] methodArray, boolean bl) {
            MethodVisitor methodVisitor = classWriter.visitMethod(1, GET_FIELD_BY_INDEX_METHOD_NAME, "(Ljava/lang/Object;I)Ljava/lang/Object;", null, null);
            methodVisitor.visitCode();
            Label label = new Label();
            methodVisitor.visitLabel(label);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitTypeInsn(192, string);
            methodVisitor.visitVarInsn(58, 3);
            Label label2 = new Label();
            methodVisitor.visitLabel(label2);
            methodVisitor.visitVarInsn(21, 2);
            Label[] labelArray = new Label[methodArray.length];
            for (int i = 0; i < methodArray.length; ++i) {
                labelArray[i] = new Label();
            }
            Label label3 = new Label();
            methodVisitor.visitTableSwitchInsn(0, labelArray.length - 1, label3, labelArray);
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                if (method.getReturnType().isPrimitive()) {
                    AccessorClassFactory.doSwitchItemBoxed(methodVisitor, labelArray[i], 3, string, method.getName(), method.getReturnType(), bl);
                    continue;
                }
                AccessorClassFactory.doSwitchItemObject(methodVisitor, labelArray[i], 3, string, method.getName(), method.getReturnType(), bl);
            }
            methodVisitor.visitLabel(label3);
            methodVisitor.visitInsn(1);
            methodVisitor.visitInsn(176);
            Label label4 = new Label();
            methodVisitor.visitLabel(label4);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        private static void doSwitchItemBoxed(MethodVisitor methodVisitor, Label label, int n, String string, String string2, Class clazz, boolean bl) {
            Class clazz2 = null;
            clazz2 = AccessorClassFactory.getBoxType(clazz);
            String string3 = Type.getDescriptor(clazz);
            String string4 = Type.getInternalName(clazz2);
            methodVisitor.visitLabel(label);
            methodVisitor.visitTypeInsn(187, string4);
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(25, n);
            if (bl) {
                methodVisitor.visitMethodInsn(185, string, string2, "()" + string3);
            } else {
                methodVisitor.visitMethodInsn(182, string, string2, "()" + string3);
            }
            methodVisitor.visitMethodInsn(183, string4, "<init>", "(" + string3 + ")V");
            methodVisitor.visitInsn(176);
        }

        private static Class getBoxType(Class clazz) {
            if (clazz == Integer.TYPE) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = FieldAccessorGenerator.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            if (clazz == Boolean.TYPE) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = FieldAccessorGenerator.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (clazz == Character.TYPE) {
                return class$java$lang$Character == null ? (class$java$lang$Character = FieldAccessorGenerator.class$("java.lang.Character")) : class$java$lang$Character;
            }
            if (clazz == Byte.TYPE) {
                return class$java$lang$Byte == null ? (class$java$lang$Byte = FieldAccessorGenerator.class$("java.lang.Byte")) : class$java$lang$Byte;
            }
            if (clazz == Short.TYPE) {
                return class$java$lang$Short == null ? (class$java$lang$Short = FieldAccessorGenerator.class$("java.lang.Short")) : class$java$lang$Short;
            }
            if (clazz == Long.TYPE) {
                return class$java$lang$Long == null ? (class$java$lang$Long = FieldAccessorGenerator.class$("java.lang.Long")) : class$java$lang$Long;
            }
            if (clazz == Float.TYPE) {
                return class$java$lang$Float == null ? (class$java$lang$Float = FieldAccessorGenerator.class$("java.lang.Float")) : class$java$lang$Float;
            }
            if (clazz == Double.TYPE) {
                return class$java$lang$Double == null ? (class$java$lang$Double = FieldAccessorGenerator.class$("java.lang.Double")) : class$java$lang$Double;
            }
            if (clazz == Void.TYPE) {
                return class$java$lang$Void == null ? (class$java$lang$Void = FieldAccessorGenerator.class$("java.lang.Void")) : class$java$lang$Void;
            }
            throw new IllegalArgumentException("Unknown scalar type: " + clazz.getName());
        }

        private static void doSwitchItemObject(MethodVisitor methodVisitor, Label label, int n, String string, String string2, Class clazz, boolean bl) {
            String string3 = "()" + Type.getDescriptor(clazz);
            methodVisitor.visitLabel(label);
            methodVisitor.visitVarInsn(25, n);
            if (bl) {
                methodVisitor.visitMethodInsn(185, string, string2, string3);
            } else {
                methodVisitor.visitMethodInsn(182, string, string2, string3);
            }
            methodVisitor.visitInsn(176);
        }

        private static void doConstructor(ClassWriter classWriter) {
            MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
            methodVisitor.visitCode();
            Label label = new Label();
            methodVisitor.visitLabel(label);
            methodVisitor.visitLineNumber(5, label);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
            methodVisitor.visitInsn(177);
            Label label2 = new Label();
            methodVisitor.visitLabel(label2);
            methodVisitor.visitMaxs(1, 1);
            methodVisitor.visitEnd();
        }
    }
}

