/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.Serializable;

public class PrimitiveLongStack
implements Serializable {
    private static final long serialVersionUID = 1121303319795490425L;
    private final int tableSize;
    private int currentPageId;
    private Page currentPage;

    public PrimitiveLongStack() {
        this(256);
    }

    public PrimitiveLongStack(int n) {
        this.tableSize = n;
        this.currentPageId = 0;
        this.currentPage = new Page(null, this.currentPageId, this.tableSize);
    }

    public void push(long l) {
        if (this.currentPage.getPosition() == this.tableSize - 1) {
            Page page;
            this.currentPage = page = new Page(this.currentPage, ++this.currentPageId, this.tableSize);
        }
        this.currentPage.push(l);
    }

    public long pop() {
        if (this.currentPage.getPosition() == -1) {
            if (this.currentPageId == 0) {
                throw new RuntimeException("Unable to pop");
            }
            Page page = this.currentPage;
            this.currentPage = page.getPreviousSibling();
            --this.currentPageId;
            page.remove();
        }
        return this.currentPage.pop();
    }

    public boolean isEmpty() {
        return this.currentPageId == 0 && this.currentPage.getPosition() == -1;
    }

    private static final class Page
    implements Serializable {
        private static final long serialVersionUID = 3287090599941407636L;
        private final int pageId;
        private Page nextSibling;
        private Page previousSibling;
        private long[] table;
        private int lastKey;

        Page(Page page, int n, int n2) {
            this.previousSibling = page;
            if (this.previousSibling != null) {
                this.previousSibling.setNextSibling(this);
            }
            this.pageId = n;
            this.lastKey = -1;
            this.table = new long[n2];
        }

        public int getNodeId() {
            return this.pageId;
        }

        void setNextSibling(Page page) {
            this.nextSibling = page;
        }

        public Page getNextSibling() {
            return this.nextSibling;
        }

        public Page getPreviousSibling() {
            return this.previousSibling;
        }

        public long pop() {
            return this.table[this.lastKey--];
        }

        public void push(long l) {
            this.table[++this.lastKey] = l;
        }

        public int getPosition() {
            return this.lastKey;
        }

        void remove() {
            this.previousSibling.setNextSibling(null);
            this.previousSibling = null;
            this.table = null;
        }
    }
}

