/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class IteratorChain
implements Iterator {
    protected final List iteratorChain = new ArrayList();
    protected int currentIteratorIndex = 0;
    protected Iterator currentIterator = null;
    protected Iterator lastUsedIterator = null;
    protected boolean isLocked = false;

    public IteratorChain() {
    }

    public IteratorChain(Iterator iterator) {
        this.addIterator(iterator);
    }

    public IteratorChain(Iterator iterator, Iterator iterator2) {
        this.addIterator(iterator);
        this.addIterator(iterator2);
    }

    public IteratorChain(Iterator[] iteratorArray) {
        for (int i = 0; i < iteratorArray.length; ++i) {
            this.addIterator(iteratorArray[i]);
        }
    }

    public IteratorChain(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = (Iterator)iterator.next();
            this.addIterator(iterator2);
        }
    }

    public void addIterator(Iterator iterator) {
        this.checkLocked();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iteratorChain.add(iterator);
    }

    public void setIterator(int n, Iterator iterator) throws IndexOutOfBoundsException {
        this.checkLocked();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iteratorChain.set(n, iterator);
    }

    public List getIterators() {
        return Collections.unmodifiableList(this.iteratorChain);
    }

    public int size() {
        return this.iteratorChain.size();
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    private void checkLocked() {
        if (this.isLocked) {
            throw new UnsupportedOperationException("IteratorChain cannot be changed after the first use of a method from the Iterator interface");
        }
    }

    private void lockChain() {
        if (!this.isLocked) {
            this.isLocked = true;
        }
    }

    protected void updateCurrentIterator() {
        if (this.currentIterator == null) {
            this.currentIterator = this.iteratorChain.isEmpty() ? Collections.EMPTY_LIST.iterator() : (Iterator)this.iteratorChain.get(0);
            this.lastUsedIterator = this.currentIterator;
        }
        while (!this.currentIterator.hasNext() && this.currentIteratorIndex < this.iteratorChain.size() - 1) {
            ++this.currentIteratorIndex;
            this.currentIterator = (Iterator)this.iteratorChain.get(this.currentIteratorIndex);
        }
    }

    public boolean hasNext() {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.hasNext();
    }

    public Object next() {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.next();
    }

    public void remove() {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator.remove();
    }
}

