/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.rule.Column;
import org.drools.rule.ConditionalElement;
import org.drools.rule.EvalCondition;
import org.drools.rule.GroupElement;
import org.drools.rule.InvalidRulePackage;
import org.drools.rule.PackageCompilationData;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.ReturnValueConstraint;
import org.drools.rule.Rule;
import org.drools.spi.TypeResolver;

public class Package
implements Externalizable {
    private static final long serialVersionUID = -3098171849409626501L;
    public static final Package[] EMPTY_ARRAY = new Package[0];
    private String name;
    private Map rules;
    private List imports;
    private Map globals;
    private TypeResolver typeResolver;
    private PackageCompilationData packageCompilationData;
    private boolean valid = true;
    private String errorSummary;

    public Package() {
    }

    public Package(String string) {
        this(string, null);
    }

    public Package(String string, ClassLoader classLoader) {
        this.name = string;
        this.imports = new ArrayList(1);
        this.rules = new LinkedHashMap();
        this.globals = new HashMap();
        this.packageCompilationData = new PackageCompilationData(classLoader);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.packageCompilationData);
        objectOutput.writeObject(this.name);
        objectOutput.writeObject(this.imports);
        objectOutput.writeObject(this.globals);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.rules);
        objectOutput.writeObject(byteArrayOutputStream.toByteArray());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.packageCompilationData = (PackageCompilationData)objectInput.readObject();
        this.name = (String)objectInput.readObject();
        this.imports = (List)objectInput.readObject();
        this.globals = (Map)objectInput.readObject();
        byte[] byArray = (byte[])objectInput.readObject();
        ObjectInputStreamWithLoader objectInputStreamWithLoader = new ObjectInputStreamWithLoader(new ByteArrayInputStream(byArray), this.packageCompilationData.getClassLoader());
        this.rules = (Map)objectInputStreamWithLoader.readObject();
    }

    public String getName() {
        return this.name;
    }

    public void addImport(String string) {
        this.imports.add(string);
    }

    public void removeImport(String string) {
        this.imports.remove(string);
    }

    public List getImports() {
        return this.imports;
    }

    public void addGlobal(String string, Class clazz) {
        this.globals.put(string, clazz);
    }

    public void removeGlobal(String string) {
        this.globals.remove(string);
    }

    public Map getGlobals() {
        return this.globals;
    }

    public void removeFunction(String string) {
        this.packageCompilationData.remove(this.name + "." + this.ucFirst(string));
    }

    public void addRule(Rule rule) {
        String string = rule.getName();
        this.rules.put(string, rule);
        rule.setLoadOrder(this.rules.size());
    }

    public void removeRule(Rule rule) {
        this.rules.remove(rule.getName());
        String string = rule.getConsequence().getClass().getName();
        this.packageCompilationData.remove(string);
        this.removeClasses(rule.getLhs());
        this.packageCompilationData.remove(string.substring(0, string.indexOf("ConsequenceInvoker")));
    }

    private void removeClasses(ConditionalElement conditionalElement) {
        if (conditionalElement instanceof GroupElement) {
            GroupElement groupElement = (GroupElement)conditionalElement;
            Iterator iterator = groupElement.getChildren().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof ConditionalElement) {
                    this.removeClasses((ConditionalElement)e);
                    continue;
                }
                if (!(e instanceof Column)) continue;
                this.removeClasses((Column)e);
            }
        } else if (conditionalElement instanceof EvalCondition) {
            this.packageCompilationData.remove(((EvalCondition)conditionalElement).getEvalExpression().getClass().getName());
        }
    }

    private void removeClasses(Column column) {
        Iterator iterator = column.getConstraints().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof PredicateConstraint) {
                this.packageCompilationData.remove(((PredicateConstraint)e).getPredicateExpression().getClass().getName());
                continue;
            }
            if (!(e instanceof ReturnValueConstraint)) continue;
            this.packageCompilationData.remove(((ReturnValueConstraint)e).getExpression().getClass().getName());
        }
    }

    public Rule getRule(String string) {
        return (Rule)this.rules.get(string);
    }

    public Rule[] getRules() {
        return this.rules.values().toArray(new Rule[this.rules.size()]);
    }

    public void setTypeSolver(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public PackageCompilationData getPackageCompilationData() {
        return this.packageCompilationData;
    }

    public String toString() {
        return "[Package name=" + this.name + "]";
    }

    public void setError(String string) {
        this.errorSummary = string;
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void checkValidity() {
        if (!this.isValid()) {
            throw new InvalidRulePackage(this.getErrorSummary());
        }
    }

    public String getErrorSummary() {
        return this.errorSummary;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Package)) {
            return false;
        }
        Package package_ = (Package)object;
        return this.name.equals(package_.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private String ucFirst(String string) {
        return string.toUpperCase().charAt(0) + string.substring(1);
    }

    public void clear() {
        this.rules.clear();
        this.packageCompilationData.clear();
    }

    private static class ObjectInputStreamWithLoader
    extends ObjectInputStream {
        private final ClassLoader classLoader;

        public ObjectInputStreamWithLoader(InputStream inputStream, ClassLoader classLoader) throws IOException {
            super(inputStream);
            this.classLoader = classLoader;
            this.enableResolveObject(true);
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            if (this.classLoader == null) {
                return super.resolveClass(objectStreamClass);
            }
            String string = objectStreamClass.getName();
            return this.classLoader.loadClass(string);
        }
    }
}

