/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Iterator;
import org.drools.RuleBaseConfiguration;
import org.drools.common.DefaultFactHandle;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkList;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.Rete;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;
import org.drools.util.PrimitiveLongMap;

class ObjectTypeNode
extends ObjectSource
implements ObjectSink,
Serializable,
NodeMemory {
    private static final long serialVersionUID = 1397702820739948690L;
    private final ObjectType objectType;
    private final Rete rete;

    public ObjectTypeNode(int n, ObjectType objectType, Rete rete) {
        this(n, null, objectType, rete);
    }

    public ObjectTypeNode(int n, ObjectSinkList objectSinkList, ObjectType objectType, Rete rete) {
        super(n, objectSinkList);
        this.rete = rete;
        this.objectType = objectType;
        this.setHasMemory(true);
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public boolean matches(Object object) {
        return this.objectType.matches(object);
    }

    public void assertObject(DefaultFactHandle defaultFactHandle, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        PrimitiveLongMap primitiveLongMap = (PrimitiveLongMap)reteooWorkingMemory.getNodeMemory(this);
        primitiveLongMap.put(defaultFactHandle.getId(), defaultFactHandle);
        this.propagateAssertObject(defaultFactHandle, propagationContext, reteooWorkingMemory);
    }

    public void retractObject(DefaultFactHandle defaultFactHandle, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        PrimitiveLongMap primitiveLongMap = (PrimitiveLongMap)reteooWorkingMemory.getNodeMemory(this);
        primitiveLongMap.remove(defaultFactHandle.getId());
        this.propagateRetractObject(defaultFactHandle, propagationContext, reteooWorkingMemory);
    }

    public void modifyObject(DefaultFactHandle defaultFactHandle, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        PrimitiveLongMap primitiveLongMap = (PrimitiveLongMap)reteooWorkingMemory.getNodeMemory(this);
        this.propagateModifyObject(defaultFactHandle, propagationContext, reteooWorkingMemory);
    }

    public void updateNewNode(ReteooWorkingMemory reteooWorkingMemory, PropagationContext propagationContext) {
        this.attachingNewNode = true;
        PrimitiveLongMap primitiveLongMap = (PrimitiveLongMap)reteooWorkingMemory.getNodeMemory(this);
        Iterator iterator = primitiveLongMap.values().iterator();
        while (iterator.hasNext()) {
            DefaultFactHandle defaultFactHandle = (DefaultFactHandle)iterator.next();
            ObjectSink objectSink = this.objectSinks.getLastObjectSink();
            if (objectSink != null) {
                objectSink.assertObject(defaultFactHandle, propagationContext, reteooWorkingMemory);
                continue;
            }
            throw new RuntimeException("Possible BUG: trying to propagate an assert to a node that was the last added node");
        }
        this.attachingNewNode = false;
    }

    public void attach() {
        this.rete.addObjectSink(this);
    }

    public void attach(ReteooWorkingMemory[] reteooWorkingMemoryArray) {
        this.attach();
        int n = reteooWorkingMemoryArray.length;
        for (int i = 0; i < n; ++i) {
            ReteooWorkingMemory reteooWorkingMemory = reteooWorkingMemoryArray[i];
            PropagationContextImpl propagationContextImpl = new PropagationContextImpl(reteooWorkingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.rete.updateNewNode(reteooWorkingMemory, propagationContextImpl);
        }
    }

    public void remove(BaseNode baseNode, ReteooWorkingMemory[] reteooWorkingMemoryArray) {
        if (!baseNode.isInUse()) {
            this.objectSinks.remove((ObjectSink)((Object)baseNode));
        }
        this.removeShare();
        if (!this.isInUse()) {
            int n = reteooWorkingMemoryArray.length;
            for (int i = 0; i < n; ++i) {
                reteooWorkingMemoryArray[i].clearNodeMemory(this);
            }
            this.rete.removeObjectSink(this);
        }
    }

    public void addShare() {
        super.addShare();
    }

    public Object createMemory(RuleBaseConfiguration ruleBaseConfiguration) {
        return new PrimitiveLongMap(32, 8);
    }

    public String toString() {
        return "[ObjectTypeNode(" + this.id + ") objectType=" + this.objectType + "]";
    }

    public int hashCode() {
        return this.objectType.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != ObjectTypeNode.class) {
            return false;
        }
        ObjectTypeNode objectTypeNode = (ObjectTypeNode)object;
        return this.objectType.equals(objectTypeNode.objectType);
    }
}

